/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.resource;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.nifi.registry.security.authorization.AuthorizationResult;
import org.apache.nifi.registry.security.authorization.Authorizer;
import org.apache.nifi.registry.security.authorization.RequestAction;
import org.apache.nifi.registry.security.authorization.Resource;
import org.apache.nifi.registry.security.authorization.UntrustedProxyException;
import org.apache.nifi.registry.security.authorization.exception.AccessDeniedException;
import org.apache.nifi.registry.security.authorization.resource.Authorizable;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyChainAuthorizable
implements Authorizable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyChainAuthorizable.class);
    private final Authorizable wrappedAuthorizable;
    private final Authorizable proxyAuthorizable;
    private final BiFunction<Resource, RequestAction, Boolean> publicResourceCheck;

    public ProxyChainAuthorizable(Authorizable wrappedAuthorizable, Authorizable proxyAuthorizable, BiFunction<Resource, RequestAction, Boolean> publicResourceCheck) {
        this.wrappedAuthorizable = Objects.requireNonNull(wrappedAuthorizable);
        this.proxyAuthorizable = Objects.requireNonNull(proxyAuthorizable);
        this.publicResourceCheck = Objects.requireNonNull(publicResourceCheck);
    }

    @Override
    public Authorizable getParentAuthorizable() {
        if (this.wrappedAuthorizable.getParentAuthorizable() == null) {
            return null;
        }
        Authorizable parentAuthorizable = this.wrappedAuthorizable.getParentAuthorizable();
        return new ProxyChainAuthorizable(parentAuthorizable, this.proxyAuthorizable, this.publicResourceCheck);
    }

    @Override
    public Resource getResource() {
        return this.wrappedAuthorizable.getResource();
    }

    @Override
    public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
        Boolean isPublicAccessAllowed;
        Resource requestResource = this.wrappedAuthorizable.getRequestedResource();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Requested resource is {}", new Object[]{requestResource.getIdentifier()});
        }
        if ((isPublicAccessAllowed = this.publicResourceCheck.apply(requestResource, action)).booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Proxy chain will not be checked, public access is allowed for {} on {}", new Object[]{action.toString(), requestResource.getIdentifier()});
            }
            return AuthorizationResult.approved();
        }
        for (NiFiUser proxyUser = user.getChain(); proxyUser != null; proxyUser = proxyUser.getChain()) {
            AuthorizationResult proxyAuthorizationResult;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Checking proxy [{}] for {}", new Object[]{proxyUser, action});
            }
            if ((proxyAuthorizationResult = this.proxyAuthorizable.checkAuthorization(authorizer, action, proxyUser)).getResult() != AuthorizationResult.Result.Denied) continue;
            String deniedMessage = String.format("Untrusted proxy [%s] for %s operation.", proxyUser.getIdentity(), action.toString());
            return AuthorizationResult.denied((String)deniedMessage);
        }
        return this.wrappedAuthorizable.checkAuthorization(authorizer, action, user, resourceContext);
    }

    @Override
    public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
        Boolean isPublicAccessAllowed;
        Resource requestResource = this.wrappedAuthorizable.getRequestedResource();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Requested resource is {}", new Object[]{requestResource.getIdentifier()});
        }
        if ((isPublicAccessAllowed = this.publicResourceCheck.apply(requestResource, action)).booleanValue()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Proxy chain will not be authorized, public access is allowed for {} on {}", new Object[]{action.toString(), requestResource.getIdentifier()});
            }
            return;
        }
        for (NiFiUser proxyUser = user.getChain(); proxyUser != null; proxyUser = proxyUser.getChain()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Authorizing proxy [{}] for {}", new Object[]{proxyUser, action});
            }
            try {
                this.proxyAuthorizable.authorize(authorizer, action, proxyUser);
                continue;
            }
            catch (AccessDeniedException e) {
                String actionString = action.toString();
                throw new UntrustedProxyException(String.format("Untrusted proxy [%s] for %s operation.", proxyUser.getIdentity(), actionString));
            }
        }
        this.wrappedAuthorizable.authorize(authorizer, action, user, resourceContext);
    }
}

