/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.database;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserAndGroups;
import org.apache.nifi.registry.security.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.annotation.AuthorizerContext;
import org.apache.nifi.registry.security.authorization.database.entity.DatabaseGroup;
import org.apache.nifi.registry.security.authorization.database.entity.DatabaseUser;
import org.apache.nifi.registry.security.authorization.database.mapper.DatabaseGroupRowMapper;
import org.apache.nifi.registry.security.authorization.database.mapper.DatabaseUserRowMapper;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.registry.security.authorization.util.UserGroupProviderUtils;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DatabaseUserGroupProvider
implements ConfigurableUserGroupProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseUserGroupProvider.class);
    private DataSource dataSource;
    private IdentityMapper identityMapper;
    private JdbcTemplate jdbcTemplate;

    @AuthorizerContext
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @AuthorizerContext
    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
    }

    public void initialize(UserGroupProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        Set<String> initialUserIdentities = UserGroupProviderUtils.getInitialUserIdentities(configurationContext, this.identityMapper);
        for (String initialUserIdentity : initialUserIdentities) {
            User existingUser = this.getUserByIdentity(initialUserIdentity);
            if (existingUser == null) {
                User initialUser = new User.Builder().identifierGenerateFromSeed(initialUserIdentity).identity(initialUserIdentity).build();
                this.addUser(initialUser);
                LOGGER.info("Created initial user with identity {}", new Object[]{initialUserIdentity});
                continue;
            }
            LOGGER.debug("User already exists with identity {}", new Object[]{initialUserIdentity});
        }
    }

    public void preDestruction() throws SecurityProviderDestructionException {
    }

    public String getFingerprint() throws AuthorizationAccessException {
        throw new UnsupportedOperationException("Fingerprinting is not supported by this provider");
    }

    public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        throw new UnsupportedOperationException("Fingerprinting is not supported by this provider");
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
        throw new UnsupportedOperationException("Fingerprinting is not supported by this provider");
    }

    public User addUser(User user) throws AuthorizationAccessException {
        Validate.notNull((Object)user);
        String sql = "INSERT INTO UGP_USER(IDENTIFIER, IDENTITY) VALUES (?, ?)";
        this.jdbcTemplate.update("INSERT INTO UGP_USER(IDENTIFIER, IDENTITY) VALUES (?, ?)", new Object[]{user.getIdentifier(), user.getIdentity()});
        return user;
    }

    public User updateUser(User user) throws AuthorizationAccessException {
        Validate.notNull((Object)user);
        String sql = "UPDATE UGP_USER SET IDENTITY = ? WHERE IDENTIFIER = ?";
        int updated = this.jdbcTemplate.update("UPDATE UGP_USER SET IDENTITY = ? WHERE IDENTIFIER = ?", new Object[]{user.getIdentity(), user.getIdentifier()});
        if (updated <= 0) {
            return null;
        }
        return user;
    }

    public Set<User> getUsers() throws AuthorizationAccessException {
        String sql = "SELECT * FROM UGP_USER";
        List databaseUsers = this.jdbcTemplate.query("SELECT * FROM UGP_USER", (RowMapper)new DatabaseUserRowMapper());
        HashSet<User> users = new HashSet<User>();
        databaseUsers.forEach(u -> users.add(this.mapToUser((DatabaseUser)u)));
        return users;
    }

    public User getUser(String identifier) throws AuthorizationAccessException {
        Validate.notBlank((CharSequence)identifier);
        DatabaseUser databaseUser = this.getDatabaseUser(identifier);
        if (databaseUser == null) {
            return null;
        }
        return this.mapToUser(databaseUser);
    }

    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        Validate.notBlank((CharSequence)identity);
        String sql = "SELECT * FROM UGP_USER WHERE IDENTITY = ?";
        DatabaseUser databaseUser = this.queryForObject("SELECT * FROM UGP_USER WHERE IDENTITY = ?", new Object[]{identity}, new DatabaseUserRowMapper());
        if (databaseUser == null) {
            return null;
        }
        return this.mapToUser(databaseUser);
    }

    public UserAndGroups getUserAndGroups(String userIdentity) throws AuthorizationAccessException {
        HashSet groups;
        Validate.notBlank((CharSequence)userIdentity);
        final User user = this.getUserByIdentity(userIdentity);
        if (user == null) {
            groups = null;
        } else {
            String userGroupSql = "SELECT G.IDENTIFIER AS IDENTIFIER, G.IDENTITY AS IDENTITY FROM UGP_GROUP AS G, UGP_USER_GROUP AS UG WHERE G.IDENTIFIER = UG.GROUP_IDENTIFIER AND UG.USER_IDENTIFIER = ?";
            Object[] args = new Object[]{user.getIdentifier()};
            List databaseGroups = this.jdbcTemplate.query("SELECT G.IDENTIFIER AS IDENTIFIER, G.IDENTITY AS IDENTITY FROM UGP_GROUP AS G, UGP_USER_GROUP AS UG WHERE G.IDENTIFIER = UG.GROUP_IDENTIFIER AND UG.USER_IDENTIFIER = ?", args, (RowMapper)new DatabaseGroupRowMapper());
            groups = new HashSet();
            databaseGroups.forEach(g -> {
                Set<String> userIdentifiers = this.getUserIdentifiers(g.getIdentifier());
                groups.add(this.mapToGroup((DatabaseGroup)g, userIdentifiers));
            });
        }
        return new UserAndGroups(){

            public User getUser() {
                return user;
            }

            public Set<Group> getGroups() {
                return groups;
            }
        };
    }

    public User deleteUser(User user) throws AuthorizationAccessException {
        Validate.notNull((Object)user);
        String deleteFromUserGroupSql = "DELETE FROM UGP_USER_GROUP WHERE USER_IDENTIFIER = ?";
        this.jdbcTemplate.update("DELETE FROM UGP_USER_GROUP WHERE USER_IDENTIFIER = ?", new Object[]{user.getIdentifier()});
        String deleteFromUserSql = "DELETE FROM UGP_USER WHERE IDENTIFIER = ?";
        int rowsDeletedFromUser = this.jdbcTemplate.update("DELETE FROM UGP_USER WHERE IDENTIFIER = ?", new Object[]{user.getIdentifier()});
        if (rowsDeletedFromUser <= 0) {
            return null;
        }
        return user;
    }

    private DatabaseUser getDatabaseUser(String userIdentifier) {
        String sql = "SELECT * FROM UGP_USER WHERE IDENTIFIER = ?";
        return this.queryForObject("SELECT * FROM UGP_USER WHERE IDENTIFIER = ?", new Object[]{userIdentifier}, new DatabaseUserRowMapper());
    }

    private User mapToUser(DatabaseUser databaseUser) {
        return new User.Builder().identifier(databaseUser.getIdentifier()).identity(databaseUser.getIdentity()).build();
    }

    public Group addGroup(Group group) throws AuthorizationAccessException {
        Validate.notNull((Object)group);
        String groupSql = "INSERT INTO UGP_GROUP(IDENTIFIER, IDENTITY) VALUES (?, ?)";
        this.jdbcTemplate.update("INSERT INTO UGP_GROUP(IDENTIFIER, IDENTITY) VALUES (?, ?)", new Object[]{group.getIdentifier(), group.getName()});
        this.createUserGroups(group);
        return group;
    }

    public Group updateGroup(Group group) throws AuthorizationAccessException {
        Validate.notNull((Object)group);
        String updateGroupSql = "UPDATE UGP_GROUP SET IDENTITY = ? WHERE IDENTIFIER = ?";
        int updated = this.jdbcTemplate.update("UPDATE UGP_GROUP SET IDENTITY = ? WHERE IDENTIFIER = ?", new Object[]{group.getName(), group.getIdentifier()});
        if (updated <= 0) {
            return null;
        }
        String deleteUserGroups = "DELETE FROM UGP_USER_GROUP WHERE GROUP_IDENTIFIER = ?";
        this.jdbcTemplate.update("DELETE FROM UGP_USER_GROUP WHERE GROUP_IDENTIFIER = ?", new Object[]{group.getIdentifier()});
        this.createUserGroups(group);
        return group;
    }

    public Set<Group> getGroups() throws AuthorizationAccessException {
        String sql = "SELECT * FROM UGP_GROUP";
        List databaseGroups = this.jdbcTemplate.query("SELECT * FROM UGP_GROUP", (RowMapper)new DatabaseGroupRowMapper());
        HashMap groupToUsers = new HashMap();
        this.jdbcTemplate.query("SELECT * FROM UGP_USER_GROUP", rs -> {
            String groupIdentifier = rs.getString("GROUP_IDENTIFIER");
            String userIdentifier = rs.getString("USER_IDENTIFIER");
            Set userIdentifiers = groupToUsers.computeIfAbsent(groupIdentifier, k -> new HashSet());
            userIdentifiers.add(userIdentifier);
        });
        HashSet<Group> groups = new HashSet<Group>();
        databaseGroups.forEach(g -> groups.add(this.mapToGroup((DatabaseGroup)g, (Set)groupToUsers.get(g.getIdentifier()))));
        return groups;
    }

    public Group getGroup(String groupIdentifier) throws AuthorizationAccessException {
        Validate.notBlank((CharSequence)groupIdentifier);
        DatabaseGroup databaseGroup = this.getDatabaseGroup(groupIdentifier);
        if (databaseGroup == null) {
            return null;
        }
        Set<String> userIdentifiers = this.getUserIdentifiers(groupIdentifier);
        return this.mapToGroup(databaseGroup, userIdentifiers);
    }

    public Group deleteGroup(Group group) throws AuthorizationAccessException {
        Validate.notNull((Object)group);
        String sql = "DELETE FROM UGP_GROUP WHERE IDENTIFIER = ?";
        int rowsUpdated = this.jdbcTemplate.update("DELETE FROM UGP_GROUP WHERE IDENTIFIER = ?", new Object[]{group.getIdentifier()});
        if (rowsUpdated <= 0) {
            return null;
        }
        return group;
    }

    private void createUserGroups(Group group) {
        if (group.getUsers() != null) {
            for (String userIdentifier : group.getUsers()) {
                String userGroupSql = "INSERT INTO UGP_USER_GROUP (USER_IDENTIFIER, GROUP_IDENTIFIER) VALUES (?, ?)";
                this.jdbcTemplate.update("INSERT INTO UGP_USER_GROUP (USER_IDENTIFIER, GROUP_IDENTIFIER) VALUES (?, ?)", new Object[]{userIdentifier, group.getIdentifier()});
            }
        }
    }

    private DatabaseGroup getDatabaseGroup(String groupIdentifier) {
        String sql = "SELECT * FROM UGP_GROUP WHERE IDENTIFIER = ?";
        return this.queryForObject("SELECT * FROM UGP_GROUP WHERE IDENTIFIER = ?", new Object[]{groupIdentifier}, new DatabaseGroupRowMapper());
    }

    private Set<String> getUserIdentifiers(String groupIdentifier) {
        String sql = "SELECT * FROM UGP_USER_GROUP WHERE GROUP_IDENTIFIER = ?";
        HashSet<String> userIdentifiers = new HashSet<String>();
        this.jdbcTemplate.query("SELECT * FROM UGP_USER_GROUP WHERE GROUP_IDENTIFIER = ?", new Object[]{groupIdentifier}, rs -> userIdentifiers.add(rs.getString("USER_IDENTIFIER")));
        return userIdentifiers;
    }

    private Group mapToGroup(DatabaseGroup databaseGroup, Set<String> userIdentifiers) {
        return new Group.Builder().identifier(databaseGroup.getIdentifier()).name(databaseGroup.getIdentity()).addUsers(userIdentifiers == null ? Collections.emptySet() : userIdentifiers).build();
    }

    private <T> T queryForObject(String sql, Object[] args, RowMapper<T> rowMapper) {
        try {
            return (T)this.jdbcTemplate.queryForObject(sql, args, rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}

