/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.flow;

import java.util.Date;
import java.util.List;
import org.apache.nifi.registry.db.entity.BucketEntity;
import org.apache.nifi.registry.db.entity.BucketItemEntityType;
import org.apache.nifi.registry.db.entity.FlowEntity;
import org.apache.nifi.registry.db.entity.FlowSnapshotEntity;
import org.apache.nifi.registry.flow.FlowPersistenceProvider;
import org.apache.nifi.registry.flow.MetadataAwareFlowPersistenceProvider;
import org.apache.nifi.registry.metadata.BucketMetadata;
import org.apache.nifi.registry.metadata.FlowMetadata;
import org.apache.nifi.registry.metadata.FlowSnapshotMetadata;
import org.apache.nifi.registry.service.MetadataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class FlowMetadataSynchronizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowMetadataSynchronizer.class);
    private MetadataService metadataService;
    private FlowPersistenceProvider persistenceProvider;

    @Autowired
    public FlowMetadataSynchronizer(MetadataService metadataService, FlowPersistenceProvider persistenceProvider) {
        this.metadataService = metadataService;
        this.persistenceProvider = persistenceProvider;
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void synchronize() {
        LOGGER.info("**************************************************");
        if (!(this.persistenceProvider instanceof MetadataAwareFlowPersistenceProvider)) {
            LOGGER.info("*  FlowPersistenceProvider is not metadata-aware, nothing to synchronize");
            LOGGER.info("**************************************************");
            return;
        }
        LOGGER.info("*  Found metadata-aware FlowPersistenceProvider...");
        if (!this.metadataService.getAllBuckets().isEmpty()) {
            LOGGER.info("*  Found existing buckets, will not synchronize metadata");
            LOGGER.info("**************************************************");
            return;
        }
        MetadataAwareFlowPersistenceProvider metadataAwareFlowPersistenceProvider = (MetadataAwareFlowPersistenceProvider)this.persistenceProvider;
        LOGGER.info("*  Synchronizing metadata from FlowPersistenceProvider to metadata database...");
        List metadata = metadataAwareFlowPersistenceProvider.getMetadata();
        LOGGER.info("*  Synchronizing {} bucket(s)", new Object[]{metadata.size()});
        for (BucketMetadata bucketMetadata : metadata) {
            BucketEntity bucketEntity = new BucketEntity();
            bucketEntity.setId(bucketMetadata.getIdentifier());
            bucketEntity.setName(bucketMetadata.getName());
            bucketEntity.setDescription(bucketMetadata.getDescription());
            bucketEntity.setCreated(new Date());
            this.metadataService.createBucket(bucketEntity);
            this.createFlows(bucketMetadata);
        }
        LOGGER.info("*  Done synchronizing metadata!");
        LOGGER.info("**************************************************");
    }

    private void createFlows(BucketMetadata bucketMetadata) {
        LOGGER.info("*  Synchronizing {} flow(s) for bucket {}", new Object[]{bucketMetadata.getFlowMetadata().size(), bucketMetadata.getIdentifier()});
        for (FlowMetadata flowMetadata : bucketMetadata.getFlowMetadata()) {
            FlowEntity flowEntity = new FlowEntity();
            flowEntity.setType(BucketItemEntityType.FLOW);
            flowEntity.setId(flowMetadata.getIdentifier());
            flowEntity.setName(flowMetadata.getName());
            flowEntity.setDescription(flowMetadata.getDescription());
            flowEntity.setBucketId(bucketMetadata.getIdentifier());
            flowEntity.setCreated(new Date());
            flowEntity.setModified(new Date());
            this.metadataService.createFlow(flowEntity);
            this.createFlowSnapshots(flowMetadata);
        }
    }

    private void createFlowSnapshots(FlowMetadata flowMetadata) {
        LOGGER.info("*  Synchronizing {} version(s) for flow {}", new Object[]{flowMetadata.getFlowSnapshotMetadata().size(), flowMetadata.getIdentifier()});
        for (FlowSnapshotMetadata snapshotMetadata : flowMetadata.getFlowSnapshotMetadata()) {
            FlowSnapshotEntity snapshotEntity = new FlowSnapshotEntity();
            snapshotEntity.setFlowId(flowMetadata.getIdentifier());
            snapshotEntity.setVersion(snapshotMetadata.getVersion());
            snapshotEntity.setComments(snapshotMetadata.getComments());
            String author = snapshotMetadata.getAuthor();
            if (author == null) {
                author = "unknown";
            }
            snapshotEntity.setCreatedBy(author);
            Long created = snapshotMetadata.getCreated();
            if (created == null) {
                created = System.currentTimeMillis();
            }
            snapshotEntity.setCreated(new Date(created));
            this.metadataService.createFlowSnapshot(snapshotEntity);
        }
    }
}

