/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.flow;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.flow.FlowPersistenceException;
import org.apache.nifi.registry.flow.FlowPersistenceProvider;
import org.apache.nifi.registry.flow.FlowSnapshotContext;
import org.apache.nifi.registry.provider.ProviderConfigurationContext;
import org.apache.nifi.registry.provider.ProviderCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemFlowPersistenceProvider
implements FlowPersistenceProvider {
    static final Logger LOGGER = LoggerFactory.getLogger(FileSystemFlowPersistenceProvider.class);
    static final String FLOW_STORAGE_DIR_PROP = "Flow Storage Directory";
    static final String SNAPSHOT_EXTENSION = ".snapshot";
    private File flowStorageDir;

    public void onConfigured(ProviderConfigurationContext configurationContext) throws ProviderCreationException {
        Map props = configurationContext.getProperties();
        if (!props.containsKey(FLOW_STORAGE_DIR_PROP)) {
            throw new ProviderCreationException("The property Flow Storage Directory must be provided");
        }
        String flowStorageDirValue = (String)props.get(FLOW_STORAGE_DIR_PROP);
        if (StringUtils.isBlank((CharSequence)flowStorageDirValue)) {
            throw new ProviderCreationException("The property Flow Storage Directory cannot be null or blank");
        }
        try {
            this.flowStorageDir = new File(flowStorageDirValue);
            org.apache.nifi.registry.util.FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)this.flowStorageDir);
            LOGGER.info("Configured FileSystemFlowPersistenceProvider with Flow Storage Directory {}", new Object[]{this.flowStorageDir.getAbsolutePath()});
        }
        catch (IOException e) {
            throw new ProviderCreationException((Throwable)e);
        }
    }

    public synchronized void saveFlowContent(FlowSnapshotContext context, byte[] content) throws FlowPersistenceException {
        File bucketDir = new File(this.flowStorageDir, context.getBucketId());
        try {
            org.apache.nifi.registry.util.FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)bucketDir);
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error accessing bucket directory at " + bucketDir.getAbsolutePath(), (Throwable)e);
        }
        File flowDir = new File(bucketDir, context.getFlowId());
        try {
            org.apache.nifi.registry.util.FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)flowDir);
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error accessing flow directory at " + flowDir.getAbsolutePath(), (Throwable)e);
        }
        String versionString = String.valueOf(context.getVersion());
        File versionDir = new File(flowDir, versionString);
        try {
            org.apache.nifi.registry.util.FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)versionDir);
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error accessing version directory at " + versionDir.getAbsolutePath(), (Throwable)e);
        }
        File versionFile = new File(versionDir, versionString + SNAPSHOT_EXTENSION);
        if (versionFile.exists()) {
            throw new FlowPersistenceException("Unable to save, a snapshot already exists with version " + versionString);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Saving snapshot with filename {}", new Object[]{versionFile.getAbsolutePath()});
        }
        try (FileOutputStream out = new FileOutputStream(versionFile);){
            ((OutputStream)out).write(content);
            out.flush();
        }
        catch (Exception e) {
            throw new FlowPersistenceException("Unable to write snapshot to disk due to " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] getFlowContent(String bucketId, String flowId, int version) throws FlowPersistenceException {
        File snapshotFile = this.getSnapshotFile(bucketId, flowId, version);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Retrieving snapshot with filename {}", new Object[]{snapshotFile.getAbsolutePath()});
        }
        if (!snapshotFile.exists()) {
            return null;
        }
        try (FileInputStream in = new FileInputStream(snapshotFile);){
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error reading snapshot file: " + snapshotFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public synchronized void deleteAllFlowContent(String bucketId, String flowId) throws FlowPersistenceException {
        boolean deletedBucket;
        File bucketDir;
        File[] bucketFiles;
        File flowDir = new File(this.flowStorageDir, bucketId + "/" + flowId);
        if (!flowDir.exists()) {
            LOGGER.debug("Snapshot directory does not exist at {}", new Object[]{flowDir.getAbsolutePath()});
            return;
        }
        try {
            FileUtils.cleanDirectory((File)flowDir);
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error deleting snapshots at " + flowDir.getAbsolutePath(), (Throwable)e);
        }
        boolean flowDirDeleted = flowDir.delete();
        if (!flowDirDeleted) {
            LOGGER.error("Unable to delete flow directory: " + flowDir.getAbsolutePath());
        }
        if ((bucketFiles = (bucketDir = new File(this.flowStorageDir, bucketId)).listFiles()).length == 0 && !(deletedBucket = bucketDir.delete())) {
            LOGGER.error("Unable to delete bucket directory: " + flowDir.getAbsolutePath());
        }
    }

    public synchronized void deleteFlowContent(String bucketId, String flowId, int version) throws FlowPersistenceException {
        File snapshotFile = this.getSnapshotFile(bucketId, flowId, version);
        if (!snapshotFile.exists()) {
            LOGGER.debug("Snapshot file does not exist at {}", new Object[]{snapshotFile.getAbsolutePath()});
            return;
        }
        boolean deleted = snapshotFile.delete();
        if (!deleted) {
            throw new FlowPersistenceException("Unable to delete snapshot at " + snapshotFile.getAbsolutePath());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleted snapshot at {}", new Object[]{snapshotFile.getAbsolutePath()});
        }
    }

    protected File getSnapshotFile(String bucketId, String flowId, int version) {
        String snapshotFilename = bucketId + "/" + flowId + "/" + version + "/" + version + SNAPSHOT_EXTENSION;
        return new File(this.flowStorageDir, snapshotFilename);
    }
}

