/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.extension;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.extension.BundleCoordinate;
import org.apache.nifi.registry.extension.BundlePersistenceContext;
import org.apache.nifi.registry.extension.BundlePersistenceException;
import org.apache.nifi.registry.extension.BundlePersistenceProvider;
import org.apache.nifi.registry.extension.BundleVersionCoordinate;
import org.apache.nifi.registry.extension.BundleVersionType;
import org.apache.nifi.registry.flow.FlowPersistenceException;
import org.apache.nifi.registry.provider.ProviderConfigurationContext;
import org.apache.nifi.registry.provider.ProviderCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemBundlePersistenceProvider
implements BundlePersistenceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemBundlePersistenceProvider.class);
    static final String BUNDLE_STORAGE_DIR_PROP = "Extension Bundle Storage Directory";
    static final String NAR_EXTENSION = ".nar";
    static final String CPP_EXTENSION = ".cpp";
    private File bundleStorageDir;

    public void onConfigured(ProviderConfigurationContext configurationContext) throws ProviderCreationException {
        Map props = configurationContext.getProperties();
        if (!props.containsKey(BUNDLE_STORAGE_DIR_PROP)) {
            throw new ProviderCreationException("The property Extension Bundle Storage Directory must be provided");
        }
        String bundleStorageDirValue = (String)props.get(BUNDLE_STORAGE_DIR_PROP);
        if (StringUtils.isBlank((CharSequence)bundleStorageDirValue)) {
            throw new ProviderCreationException("The property Extension Bundle Storage Directory cannot be null or blank");
        }
        try {
            this.bundleStorageDir = new File(bundleStorageDirValue);
            org.apache.nifi.registry.util.FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)this.bundleStorageDir);
            LOGGER.info("Configured BundlePersistenceProvider with Extension Bundle Storage Directory {}", new Object[]{this.bundleStorageDir.getAbsolutePath()});
        }
        catch (IOException e) {
            throw new ProviderCreationException((Throwable)e);
        }
    }

    public synchronized void createBundleVersion(BundlePersistenceContext context, InputStream contentStream) throws BundlePersistenceException {
        this.saveOrUpdateBundleVersion(context, contentStream, false);
    }

    public synchronized void updateBundleVersion(BundlePersistenceContext context, InputStream contentStream) throws BundlePersistenceException {
        this.saveOrUpdateBundleVersion(context, contentStream, true);
    }

    private synchronized void saveOrUpdateBundleVersion(BundlePersistenceContext context, InputStream contentStream, boolean overwrite) throws BundlePersistenceException {
        BundleVersionCoordinate versionCoordinate = context.getCoordinate();
        File bundleVersionDir = FileSystemBundlePersistenceProvider.getBundleVersionDirectory(this.bundleStorageDir, versionCoordinate);
        try {
            org.apache.nifi.registry.util.FileUtils.ensureDirectoryExistAndCanReadAndWrite((File)bundleVersionDir);
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error accessing directory for extension bundle version at " + bundleVersionDir.getAbsolutePath(), (Throwable)e);
        }
        File bundleFile = FileSystemBundlePersistenceProvider.getBundleFile(bundleVersionDir, versionCoordinate);
        if (bundleFile.exists() && !overwrite) {
            String existingPath = bundleFile.getAbsolutePath();
            throw new BundlePersistenceException("Unable to save because a bundle versions already exists at " + existingPath);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Writing extension bundle to {}", new Object[]{bundleFile.getAbsolutePath()});
        }
        try (FileOutputStream out = new FileOutputStream(bundleFile);){
            IOUtils.copy((InputStream)contentStream, (OutputStream)out);
            out.flush();
        }
        catch (Exception e) {
            throw new FlowPersistenceException("Unable to write bundle file to disk due to " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void getBundleVersionContent(BundleVersionCoordinate versionCoordinate, OutputStream outputStream) throws BundlePersistenceException {
        File bundleFile = this.getBundleFile(versionCoordinate);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Reading extension bundle from {}", new Object[]{bundleFile.getAbsolutePath()});
        }
        try (FileInputStream in = new FileInputStream(bundleFile);
             BufferedInputStream bufIn = new BufferedInputStream(in);){
            IOUtils.copy((InputStream)bufIn, (OutputStream)outputStream);
            outputStream.flush();
        }
        catch (FileNotFoundException e) {
            throw new BundlePersistenceException("Extension bundle content was not found for: " + bundleFile.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            throw new BundlePersistenceException("Error reading extension bundle content", (Throwable)e);
        }
    }

    public synchronized void deleteBundleVersion(BundleVersionCoordinate versionCoordinate) throws BundlePersistenceException {
        File bundleFile = this.getBundleFile(versionCoordinate);
        if (!bundleFile.exists()) {
            LOGGER.warn("Extension bundle content does not exist at {}", new Object[]{bundleFile.getAbsolutePath()});
            return;
        }
        boolean deleted = bundleFile.delete();
        if (!deleted) {
            throw new BundlePersistenceException("Unable to delete extension bundle content at " + bundleFile.getAbsolutePath());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleted extension bundle content at {}", new Object[]{bundleFile.getAbsolutePath()});
        }
    }

    public synchronized void deleteAllBundleVersions(BundleCoordinate bundleCoordinate) throws BundlePersistenceException {
        File groupDir;
        File[] groupFiles;
        File bundleDir = FileSystemBundlePersistenceProvider.getBundleDirectory(this.bundleStorageDir, bundleCoordinate);
        if (!bundleDir.exists()) {
            LOGGER.warn("Extension bundle directory does not exist at {}", new Object[]{bundleDir.getAbsolutePath()});
            return;
        }
        try {
            FileUtils.cleanDirectory((File)bundleDir);
        }
        catch (IOException e) {
            throw new FlowPersistenceException("Error deleting extension bundles at " + bundleDir.getAbsolutePath(), (Throwable)e);
        }
        boolean bundleDirDeleted = bundleDir.delete();
        if (!bundleDirDeleted) {
            LOGGER.error("Unable to delete extension bundle directory: " + bundleDir.getAbsolutePath());
        }
        if ((groupFiles = (groupDir = bundleDir.getParentFile()).listFiles()).length == 0) {
            boolean deletedGroup = groupDir.delete();
            if (!deletedGroup) {
                LOGGER.error("Unable to delete group directory: " + groupDir.getAbsolutePath());
            } else {
                boolean deletedBucket;
                File bucketDir = groupDir.getParentFile();
                File[] bucketFiles = bucketDir.listFiles();
                if (bucketFiles.length == 0 && !(deletedBucket = bucketDir.delete())) {
                    LOGGER.error("Unable to delete bucket directory: " + bucketDir.getAbsolutePath());
                }
            }
        }
    }

    private File getBundleFile(BundleVersionCoordinate coordinate) {
        File bundleVersionDir = FileSystemBundlePersistenceProvider.getBundleVersionDirectory(this.bundleStorageDir, coordinate);
        return FileSystemBundlePersistenceProvider.getBundleFile(bundleVersionDir, coordinate);
    }

    static File getBundleDirectory(File bundleStorageDir, BundleCoordinate bundleCoordinate) {
        String bucketId = bundleCoordinate.getBucketId();
        String groupId = bundleCoordinate.getGroupId();
        String artifactId = bundleCoordinate.getArtifactId();
        return new File(bundleStorageDir, FileSystemBundlePersistenceProvider.sanitize(bucketId) + "/" + FileSystemBundlePersistenceProvider.sanitize(groupId) + "/" + FileSystemBundlePersistenceProvider.sanitize(artifactId));
    }

    static File getBundleVersionDirectory(File bundleStorageDir, BundleVersionCoordinate versionCoordinate) {
        String bucketId = versionCoordinate.getBucketId();
        String groupId = versionCoordinate.getGroupId();
        String artifactId = versionCoordinate.getArtifactId();
        String version = versionCoordinate.getVersion();
        return new File(bundleStorageDir, FileSystemBundlePersistenceProvider.sanitize(bucketId) + "/" + FileSystemBundlePersistenceProvider.sanitize(groupId) + "/" + FileSystemBundlePersistenceProvider.sanitize(artifactId) + "/" + FileSystemBundlePersistenceProvider.sanitize(version));
    }

    static File getBundleFile(File parentDir, BundleVersionCoordinate versionCoordinate) {
        String artifactId = versionCoordinate.getArtifactId();
        String version = versionCoordinate.getVersion();
        BundleVersionType bundleType = versionCoordinate.getType();
        String bundleFileExtension = FileSystemBundlePersistenceProvider.getBundleFileExtension(bundleType);
        String bundleFilename = FileSystemBundlePersistenceProvider.sanitize(artifactId) + "-" + FileSystemBundlePersistenceProvider.sanitize(version) + bundleFileExtension;
        return new File(parentDir, bundleFilename);
    }

    static String sanitize(String input) {
        return org.apache.nifi.registry.util.FileUtils.sanitizeFilename((String)input).trim().toLowerCase();
    }

    static String getBundleFileExtension(BundleVersionType bundleType) {
        switch (bundleType) {
            case NIFI_NAR: {
                return NAR_EXTENSION;
            }
            case MINIFI_CPP: {
                return CPP_EXTENSION;
            }
        }
        LOGGER.warn("Unknown bundle type: " + bundleType);
        return "";
    }
}

