/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.connect;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.nifi.kafka.connect.StatelessNiFiCommonConfig;
import org.apache.nifi.kafka.connect.StatelessNiFiSourceTask;
import org.apache.nifi.stateless.bootstrap.StatelessBootstrap;
import org.apache.nifi.stateless.config.ExtensionClientDefinition;
import org.apache.nifi.stateless.config.ParameterOverride;
import org.apache.nifi.stateless.config.SslContextDefinition;
import org.apache.nifi.stateless.engine.StatelessEngineConfiguration;
import org.apache.nifi.stateless.flow.DataflowDefinition;
import org.apache.nifi.stateless.flow.StatelessDataflow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class StatelessKafkaConnectorUtil {
    private static final String UNKNOWN_VERSION = "<Unable to determine Stateless NiFi Kafka Connector Version>";
    private static final Logger logger = LoggerFactory.getLogger(StatelessKafkaConnectorUtil.class);
    private static final Lock unpackNarLock = new ReentrantLock();
    protected static final Pattern STATELESS_BOOTSTRAP_FILE_PATTERN = Pattern.compile("nifi-stateless-bootstrap-(.*).jar");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        File bootstrapJar = StatelessKafkaConnectorUtil.detectBootstrapJar();
        if (bootstrapJar == null) {
            return UNKNOWN_VERSION;
        }
        try (JarFile jarFile = new JarFile(bootstrapJar);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) return UNKNOWN_VERSION;
            String string = manifest.getMainAttributes().getValue("Implementation-Version");
            return string;
        }
        catch (IOException e) {
            logger.warn("Could not determine Version of NiFi Stateless Kafka Connector", (Throwable)e);
            return UNKNOWN_VERSION;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StatelessDataflow createDataflow(StatelessNiFiCommonConfig config) {
        StatelessEngineConfiguration engineConfiguration = StatelessKafkaConnectorUtil.createEngineConfiguration(config);
        List<ParameterOverride> parameterOverrides = config.getParameterOverrides();
        String dataflowName = config.getDataflowName();
        try {
            StatelessBootstrap bootstrap;
            HashMap<String, String> dataflowDefinitionProperties = new HashMap<String, String>();
            config.setFlowDefinition(dataflowDefinitionProperties);
            dataflowDefinitionProperties.put("nifi.stateless.flow.name", dataflowName);
            MDC.setContextMap(Collections.singletonMap("dataflow", dataflowName));
            unpackNarLock.lock();
            try {
                bootstrap = StatelessBootstrap.bootstrap((StatelessEngineConfiguration)engineConfiguration, (ClassLoader)StatelessNiFiSourceTask.class.getClassLoader());
            }
            finally {
                unpackNarLock.unlock();
            }
            DataflowDefinition dataflowDefinition = bootstrap.parseDataflowDefinition(dataflowDefinitionProperties, parameterOverrides);
            return bootstrap.createDataflow(dataflowDefinition);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to bootstrap Stateless NiFi Engine", e);
        }
    }

    private static StatelessEngineConfiguration createEngineConfiguration(final StatelessNiFiCommonConfig config) {
        String narDirectoryFilename = config.getNarDirectory();
        final File narDirectory = narDirectoryFilename == null ? StatelessKafkaConnectorUtil.detectNarDirectory() : new File(narDirectoryFilename);
        String dataflowName = config.getDataflowName();
        String workingDirectoryFilename = config.getWorkingDirectory();
        File baseWorkingDirectory = workingDirectoryFilename == null ? StatelessNiFiCommonConfig.DEFAULT_WORKING_DIRECTORY : new File(workingDirectoryFilename);
        final File workingDirectory = new File(baseWorkingDirectory, dataflowName);
        String extensionsDirectoryFilename = config.getExtensionsDirectory();
        final File extensionsDirectory = extensionsDirectoryFilename == null ? StatelessNiFiCommonConfig.DEFAULT_EXTENSIONS_DIRECTORY : new File(extensionsDirectoryFilename);
        final SslContextDefinition sslContextDefinition = StatelessKafkaConnectorUtil.createSslContextDefinition(config);
        return new StatelessEngineConfiguration(){

            public File getWorkingDirectory() {
                return workingDirectory;
            }

            public File getNarDirectory() {
                return narDirectory;
            }

            public File getExtensionsDirectory() {
                return extensionsDirectory;
            }

            public Collection<File> getReadOnlyExtensionsDirectories() {
                return Collections.emptyList();
            }

            public File getKrb5File() {
                return new File(config.getKrb5File());
            }

            public Optional<File> getContentRepositoryDirectory() {
                return Optional.empty();
            }

            public SslContextDefinition getSslContext() {
                return sslContextDefinition;
            }

            public String getSensitivePropsKey() {
                return config.getSensitivePropsKey();
            }

            public List<ExtensionClientDefinition> getExtensionClients() {
                ArrayList<ExtensionClientDefinition> extensionClientDefinitions = new ArrayList<ExtensionClientDefinition>();
                String nexusBaseUrl = config.getNexusBaseUrl();
                if (nexusBaseUrl != null) {
                    ExtensionClientDefinition definition = new ExtensionClientDefinition();
                    definition.setUseSslContext(false);
                    definition.setExtensionClientType("nexus");
                    definition.setCommsTimeout("30 secs");
                    definition.setBaseUrl(nexusBaseUrl);
                    extensionClientDefinitions.add(definition);
                }
                return extensionClientDefinitions;
            }

            public String getStatusTaskInterval() {
                return "1 min";
            }
        };
    }

    private static SslContextDefinition createSslContextDefinition(StatelessNiFiCommonConfig config) {
        String truststoreFile = config.getTruststoreFile();
        if (truststoreFile == null || truststoreFile.trim().isEmpty()) {
            return null;
        }
        SslContextDefinition sslContextDefinition = new SslContextDefinition();
        sslContextDefinition.setTruststoreFile(truststoreFile);
        sslContextDefinition.setTruststorePass(config.getTruststorePassword());
        sslContextDefinition.setTruststoreType(config.getTruststoreType());
        String keystoreFile = config.getKeystoreFile();
        if (keystoreFile != null && !keystoreFile.trim().isEmpty()) {
            sslContextDefinition.setKeystoreFile(keystoreFile);
            sslContextDefinition.setKeystoreType(config.getKeystoreType());
            String keystorePass = config.getKeystorePassword();
            sslContextDefinition.setKeystorePass(keystorePass);
            String explicitKeyPass = config.getKeystoreKeyPassword();
            String keyPass = explicitKeyPass == null || explicitKeyPass.trim().isEmpty() ? keystorePass : explicitKeyPass;
            sslContextDefinition.setKeyPass(keyPass);
        }
        return sslContextDefinition;
    }

    private static URLClassLoader getConnectClassLoader() {
        ClassLoader classLoader = StatelessKafkaConnectorUtil.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            throw new IllegalStateException("No configuration value was set for the nar.directory configuration property, and was unable to determine the NAR directory automatically");
        }
        return (URLClassLoader)classLoader;
    }

    private static File detectBootstrapJar() {
        URLClassLoader urlClassLoader = StatelessKafkaConnectorUtil.getConnectClassLoader();
        for (URL url : urlClassLoader.getURLs()) {
            File artifactFile;
            String artifactFilename = url.getFile();
            if (artifactFilename == null || !STATELESS_BOOTSTRAP_FILE_PATTERN.matcher((artifactFile = new File(artifactFilename)).getName()).matches()) continue;
            return artifactFile;
        }
        return null;
    }

    private static File detectNarDirectory() {
        File bootstrapJar = StatelessKafkaConnectorUtil.detectBootstrapJar();
        if (bootstrapJar == null) {
            URLClassLoader urlClassLoader = StatelessKafkaConnectorUtil.getConnectClassLoader();
            logger.error("ClassLoader that loaded Stateless Kafka Connector did not contain nifi-stateless-bootstrap. URLs that were present: {}", Arrays.asList(urlClassLoader.getURLs()));
            throw new IllegalStateException("No configuration value was set for the nar.directory configuration property, and was unable to determine the NAR directory automatically");
        }
        File narDirectory = bootstrapJar.getParentFile();
        logger.info("Detected NAR Directory to be {}", (Object)narDirectory.getAbsolutePath());
        return narDirectory;
    }
}

