/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.mapping;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceDefinition;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flow.BatchSize;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ConnectableComponent;
import org.apache.nifi.flow.ConnectableComponentType;
import org.apache.nifi.flow.ControllerServiceAPI;
import org.apache.nifi.flow.ExternalControllerServiceReference;
import org.apache.nifi.flow.ParameterProviderReference;
import org.apache.nifi.flow.PortType;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedFlowRegistryClient;
import org.apache.nifi.flow.VersionedFunnel;
import org.apache.nifi.flow.VersionedLabel;
import org.apache.nifi.flow.VersionedParameter;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedParameterProvider;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedPropertyDescriptor;
import org.apache.nifi.flow.VersionedRemoteGroupPort;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.flow.VersionedResourceCardinality;
import org.apache.nifi.flow.VersionedResourceDefinition;
import org.apache.nifi.flow.VersionedResourceType;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.parameter.ParameterProviderConfiguration;
import org.apache.nifi.parameter.ParameterReferencedControllerServiceData;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.mapping.FlowMappingOptions;
import org.apache.nifi.registry.flow.mapping.InstantiatedConnectableComponent;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedConnection;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedControllerService;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedFunnel;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedLabel;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedPort;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessor;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedRemoteGroupPort;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedRemoteProcessGroup;
import org.apache.nifi.registry.flow.mapping.SensitiveValueEncryptor;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;

public class NiFiRegistryFlowMapper {
    private static final String ENCRYPTED_PREFIX = "enc{";
    private static final String ENCRYPTED_SUFFIX = "}";
    private static final String REGISTRY_URL_DESCRIPTOR_NAME = "url";
    private final ExtensionManager extensionManager;
    private final FlowMappingOptions flowMappingOptions;
    private Map<String, String> versionedComponentIds = new HashMap<String, String>();

    public NiFiRegistryFlowMapper(ExtensionManager extensionManager) {
        this(extensionManager, FlowMappingOptions.DEFAULT_OPTIONS);
    }

    public NiFiRegistryFlowMapper(ExtensionManager extensionManager, FlowMappingOptions flowMappingOptions) {
        this.extensionManager = extensionManager;
        this.flowMappingOptions = flowMappingOptions;
    }

    public InstantiatedVersionedProcessGroup mapNonVersionedProcessGroup(ProcessGroup group, ControllerServiceProvider serviceProvider) {
        this.versionedComponentIds.clear();
        return this.mapGroup(group, serviceProvider, (processGroup, versionedGroup) -> true);
    }

    public InstantiatedVersionedProcessGroup mapProcessGroup(ProcessGroup group, ControllerServiceProvider serviceProvider, FlowManager flowManager, boolean mapDescendantVersionedFlows) {
        this.versionedComponentIds.clear();
        return this.mapGroup(group, serviceProvider, (processGroup, versionedGroup) -> {
            VersionControlInformation versionControlInfo = processGroup.getVersionControlInformation();
            if (versionControlInfo != null) {
                VersionedFlowCoordinates coordinates = new VersionedFlowCoordinates();
                String registryId = versionControlInfo.getRegistryIdentifier();
                FlowRegistryClientNode registry = flowManager.getFlowRegistryClient(registryId);
                if (registry == null) {
                    throw new IllegalStateException("Process Group refers to a Flow Registry with ID " + registryId + " but no Flow Registry exists with that ID. Cannot resolve to a URL.");
                }
                if (this.flowMappingOptions.isMapFlowRegistryClientId()) {
                    coordinates.setRegistryId(registryId);
                }
                coordinates.setRegistryUrl(this.getRegistryUrl(registry));
                String storageLocation = this.determineStorageLocation(registry, versionControlInfo);
                coordinates.setStorageLocation(storageLocation);
                coordinates.setBucketId(versionControlInfo.getBucketIdentifier());
                coordinates.setFlowId(versionControlInfo.getFlowIdentifier());
                coordinates.setVersion(versionControlInfo.getVersion());
                versionedGroup.setVersionedFlowCoordinates(coordinates);
                for (Port port : processGroup.getInputPorts()) {
                    this.getId(port.getVersionedComponentId(), port.getIdentifier());
                }
                for (Port port : processGroup.getOutputPorts()) {
                    this.getId(port.getVersionedComponentId(), port.getIdentifier());
                }
                return mapDescendantVersionedFlows;
            }
            return true;
        });
    }

    private boolean isNiFiRegistryClient(FlowRegistryClientNode clientNode) {
        return clientNode.getComponentType().endsWith("NifiRegistryFlowRegistryClient");
    }

    private String getRegistryUrl(FlowRegistryClientNode registry) {
        return this.isNiFiRegistryClient(registry) ? registry.getRawPropertyValue(registry.getPropertyDescriptor(REGISTRY_URL_DESCRIPTOR_NAME)) : "";
    }

    private String determineStorageLocation(FlowRegistryClientNode registryClient, VersionControlInformation versionControlInformation) {
        String explicitStorageLocation = versionControlInformation.getStorageLocation();
        if (!StringUtils.isEmpty((CharSequence)explicitStorageLocation)) {
            return explicitStorageLocation;
        }
        String registryUrl = this.getRegistryUrl(registryClient);
        if (StringUtils.isEmpty((CharSequence)registryUrl)) {
            return "";
        }
        String bucketId = versionControlInformation.getBucketIdentifier();
        String flowId = versionControlInformation.getFlowIdentifier();
        int version = versionControlInformation.getVersion();
        return String.format("%s/nifi-registry-api/buckets/%s/flows/%s/versions/%s", registryUrl, bucketId, flowId, version);
    }

    private InstantiatedVersionedProcessGroup mapGroup(ProcessGroup group, ControllerServiceProvider serviceProvider, BiFunction<ProcessGroup, VersionedProcessGroup, Boolean> applyVersionControlInfo) {
        Set<String> allIncludedGroupsIds = group.findAllProcessGroups().stream().map(ProcessGroup::getIdentifier).collect(Collectors.toSet());
        allIncludedGroupsIds.add(group.getIdentifier());
        HashMap<String, ExternalControllerServiceReference> externalControllerServiceReferences = new HashMap<String, ExternalControllerServiceReference>();
        InstantiatedVersionedProcessGroup versionedGroup = this.mapGroup(group, serviceProvider, applyVersionControlInfo, true, allIncludedGroupsIds, externalControllerServiceReferences);
        this.populateReferencedAncestorVariables(group, versionedGroup);
        return versionedGroup;
    }

    private InstantiatedVersionedProcessGroup mapGroup(ProcessGroup group, ControllerServiceProvider serviceProvider, BiFunction<ProcessGroup, VersionedProcessGroup, Boolean> applyVersionControlInfo, boolean topLevel, Set<String> includedGroupIds, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences) {
        boolean mapDescendantVersionedFlows;
        InstantiatedVersionedProcessGroup versionedGroup = new InstantiatedVersionedProcessGroup(group.getIdentifier(), group.getProcessGroupIdentifier());
        versionedGroup.setIdentifier(this.getId(group.getVersionedComponentId(), group.getIdentifier()));
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            versionedGroup.setInstanceIdentifier(group.getIdentifier());
        }
        versionedGroup.setGroupIdentifier(this.getGroupId(group.getProcessGroupIdentifier()));
        versionedGroup.setName(group.getName());
        versionedGroup.setComments(group.getComments());
        versionedGroup.setPosition(this.mapPosition(group.getPosition()));
        versionedGroup.setFlowFileConcurrency(group.getFlowFileConcurrency().name());
        versionedGroup.setFlowFileOutboundPolicy(group.getFlowFileOutboundPolicy().name());
        versionedGroup.setDefaultFlowFileExpiration(group.getDefaultFlowFileExpiration());
        versionedGroup.setDefaultBackPressureObjectThreshold(group.getDefaultBackPressureObjectThreshold());
        versionedGroup.setDefaultBackPressureDataSizeThreshold(group.getDefaultBackPressureDataSizeThreshold());
        versionedGroup.setLogFileSuffix(group.getLogFileSuffix());
        ParameterContext parameterContext = group.getParameterContext();
        versionedGroup.setParameterContextName(parameterContext == null ? null : parameterContext.getName());
        if (!topLevel && !(mapDescendantVersionedFlows = applyVersionControlInfo.apply(group, versionedGroup).booleanValue())) {
            return versionedGroup;
        }
        versionedGroup.setControllerServices(group.getControllerServices(false).stream().map(service -> this.mapControllerService((ControllerServiceNode)service, serviceProvider, includedGroupIds, externalControllerServiceReferences)).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setFunnels(group.getFunnels().stream().map(this::mapFunnel).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setInputPorts(group.getInputPorts().stream().map(this::mapPort).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setOutputPorts(group.getOutputPorts().stream().map(this::mapPort).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setLabels(group.getLabels().stream().map(this::mapLabel).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setProcessors(group.getProcessors().stream().map(processor -> this.mapProcessor((ProcessorNode)processor, serviceProvider, includedGroupIds, externalControllerServiceReferences)).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setRemoteProcessGroups(group.getRemoteProcessGroups().stream().map(this::mapRemoteProcessGroup).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setProcessGroups(group.getProcessGroups().stream().map(grp -> this.mapGroup((ProcessGroup)grp, serviceProvider, applyVersionControlInfo, false, includedGroupIds, externalControllerServiceReferences)).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setConnections(group.getConnections().stream().map(this::mapConnection).collect(Collectors.toCollection(LinkedHashSet::new)));
        versionedGroup.setVariables(group.getVariableRegistry().getVariableMap().entrySet().stream().collect(Collectors.toMap(entry -> ((VariableDescriptor)entry.getKey()).getName(), Map.Entry::getValue)));
        if (topLevel) {
            versionedGroup.setExternalControllerServiceReferences(externalControllerServiceReferences);
        }
        return versionedGroup;
    }

    private void populateReferencedAncestorVariables(ProcessGroup group, VersionedProcessGroup versionedGroup) {
        HashSet<String> ancestorVariableNames = new HashSet<String>();
        this.populateVariableNames(group.getParent(), ancestorVariableNames);
        HashMap<String, String> implicitlyDefinedVariables = new HashMap<String, String>();
        for (String variableName : ancestorVariableNames) {
            boolean isReferenced = !group.getComponentsAffectedByVariable(variableName).isEmpty();
            if (!isReferenced) continue;
            String value = group.getVariableRegistry().getVariableValue(variableName);
            implicitlyDefinedVariables.put(variableName, value);
        }
        if (!implicitlyDefinedVariables.isEmpty()) {
            if (versionedGroup.getVariables() != null) {
                implicitlyDefinedVariables.putAll(versionedGroup.getVariables());
            }
            versionedGroup.setVariables(implicitlyDefinedVariables);
        }
    }

    private void populateVariableNames(ProcessGroup group, Set<String> variableNames) {
        if (group == null) {
            return;
        }
        group.getVariableRegistry().getVariableMap().keySet().stream().map(VariableDescriptor::getName).forEach(variableNames::add);
        this.populateVariableNames(group.getParent(), variableNames);
    }

    private String getId(Optional<String> currentVersionedId, String componentId) {
        String versionedId = this.flowMappingOptions.getComponentIdLookup().getComponentId(currentVersionedId, componentId);
        this.versionedComponentIds.put(componentId, versionedId);
        return versionedId;
    }

    public static String generateVersionedComponentId(String componentId) {
        return UUID.nameUUIDFromBytes(componentId.getBytes(StandardCharsets.UTF_8)).toString();
    }

    private <E extends Exception> String getIdOrThrow(String componentId, Supplier<E> exceptionSupplier) throws E {
        String resolved = this.versionedComponentIds.get(componentId);
        if (resolved == null) {
            throw (Exception)exceptionSupplier.get();
        }
        return resolved;
    }

    public String getGroupId(String groupId) {
        return this.versionedComponentIds.get(groupId);
    }

    public VersionedConnection mapConnection(Connection connection) {
        FlowFileQueue queue = connection.getFlowFileQueue();
        InstantiatedVersionedConnection versionedConnection = new InstantiatedVersionedConnection(connection.getIdentifier(), connection.getProcessGroup().getIdentifier());
        versionedConnection.setIdentifier(this.getId(connection.getVersionedComponentId(), connection.getIdentifier()));
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            versionedConnection.setInstanceIdentifier(connection.getIdentifier());
        }
        versionedConnection.setGroupIdentifier(this.getGroupId(connection.getProcessGroup().getIdentifier()));
        versionedConnection.setName(connection.getName());
        versionedConnection.setBackPressureDataSizeThreshold(queue.getBackPressureDataSizeThreshold());
        versionedConnection.setBackPressureObjectThreshold(queue.getBackPressureObjectThreshold());
        versionedConnection.setFlowFileExpiration(queue.getFlowFileExpiration());
        versionedConnection.setLabelIndex(connection.getLabelIndex());
        versionedConnection.setPrioritizers(queue.getPriorities().stream().map(p -> p.getClass().getName()).collect(Collectors.toList()));
        versionedConnection.setSelectedRelationships(connection.getRelationships().stream().map(Relationship::getName).collect(Collectors.toSet()));
        versionedConnection.setzIndex(connection.getZIndex());
        FlowFileQueue flowFileQueue = connection.getFlowFileQueue();
        versionedConnection.setLoadBalanceStrategy(flowFileQueue.getLoadBalanceStrategy().name());
        versionedConnection.setPartitioningAttribute(flowFileQueue.getPartitioningAttribute());
        versionedConnection.setLoadBalanceCompression(flowFileQueue.getLoadBalanceCompression().name());
        versionedConnection.setBends(connection.getBendPoints().stream().map(this::mapPosition).collect(Collectors.toList()));
        versionedConnection.setSource(this.mapConnectable(connection.getSource()));
        versionedConnection.setDestination(this.mapConnectable(connection.getDestination()));
        return versionedConnection;
    }

    public ConnectableComponent mapConnectable(Connectable connectable) {
        String groupId;
        InstantiatedConnectableComponent component = new InstantiatedConnectableComponent(connectable.getIdentifier(), connectable.getProcessGroupIdentifier());
        String versionedId = this.getIdOrThrow(connectable.getIdentifier(), () -> new IllegalArgumentException("Unable to map Connectable Component with identifier " + connectable.getIdentifier() + " to any version-controlled component"));
        component.setId(versionedId);
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            component.setInstanceIdentifier(connectable.getIdentifier());
        }
        component.setComments(connectable.getComments());
        if (connectable instanceof RemoteGroupPort) {
            RemoteGroupPort port = (RemoteGroupPort)connectable;
            RemoteProcessGroup rpg = port.getRemoteProcessGroup();
            groupId = this.getIdOrThrow(rpg.getIdentifier(), () -> new IllegalArgumentException("Unable to find the Versioned Component ID for Remote Process Group that " + connectable + " belongs to"));
        } else {
            groupId = this.getIdOrThrow(connectable.getProcessGroupIdentifier(), () -> new IllegalArgumentException("Unable to find the Versioned Component ID for the Process Group that " + connectable + " belongs to"));
        }
        component.setGroupId(groupId);
        component.setName(connectable.getName());
        component.setType(ConnectableComponentType.valueOf((String)connectable.getConnectableType().name()));
        return component;
    }

    public VersionedReportingTask mapReportingTask(ReportingTaskNode taskNode, ControllerServiceProvider serviceProvider) {
        VersionedReportingTask versionedTask = new VersionedReportingTask();
        versionedTask.setIdentifier(taskNode.getIdentifier());
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            versionedTask.setInstanceIdentifier(taskNode.getIdentifier());
        }
        versionedTask.setAnnotationData(taskNode.getAnnotationData());
        versionedTask.setBundle(this.mapBundle(taskNode.getBundleCoordinate()));
        versionedTask.setComments(taskNode.getComments());
        versionedTask.setComponentType(ComponentType.REPORTING_TASK);
        versionedTask.setName(taskNode.getName());
        versionedTask.setProperties(this.mapProperties((ComponentNode)taskNode, serviceProvider));
        versionedTask.setPropertyDescriptors(this.mapPropertyDescriptors((ComponentNode)taskNode, serviceProvider, Collections.emptySet(), Collections.emptyMap()));
        versionedTask.setSchedulingPeriod(taskNode.getSchedulingPeriod());
        versionedTask.setSchedulingStrategy(taskNode.getSchedulingStrategy().name());
        versionedTask.setType(taskNode.getCanonicalClassName());
        versionedTask.setScheduledState(this.flowMappingOptions.getStateLookup().getState(taskNode));
        return versionedTask;
    }

    public VersionedParameterProvider mapParameterProvider(ParameterProviderNode parameterProviderNode, ControllerServiceProvider serviceProvider) {
        VersionedParameterProvider versionedParameterProvider = new VersionedParameterProvider();
        versionedParameterProvider.setIdentifier(parameterProviderNode.getIdentifier());
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            versionedParameterProvider.setInstanceIdentifier(parameterProviderNode.getIdentifier());
        }
        versionedParameterProvider.setAnnotationData(parameterProviderNode.getAnnotationData());
        versionedParameterProvider.setBundle(this.mapBundle(parameterProviderNode.getBundleCoordinate()));
        versionedParameterProvider.setComments(parameterProviderNode.getComments());
        versionedParameterProvider.setComponentType(ComponentType.PARAMETER_PROVIDER);
        versionedParameterProvider.setName(parameterProviderNode.getName());
        versionedParameterProvider.setProperties(this.mapProperties((ComponentNode)parameterProviderNode, serviceProvider));
        versionedParameterProvider.setPropertyDescriptors(this.mapPropertyDescriptors((ComponentNode)parameterProviderNode, serviceProvider, Collections.emptySet(), Collections.emptyMap()));
        versionedParameterProvider.setType(parameterProviderNode.getCanonicalClassName());
        return versionedParameterProvider;
    }

    public VersionedFlowRegistryClient mapFlowRegistryClient(FlowRegistryClientNode clientNode, ControllerServiceProvider serviceProvider) {
        VersionedFlowRegistryClient versionedClient = new VersionedFlowRegistryClient();
        versionedClient.setIdentifier(clientNode.getIdentifier());
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            versionedClient.setInstanceIdentifier(clientNode.getIdentifier());
        }
        versionedClient.setAnnotationData(clientNode.getAnnotationData());
        versionedClient.setBundle(this.mapBundle(clientNode.getBundleCoordinate()));
        versionedClient.setComponentType(ComponentType.FLOW_REGISTRY_CLIENT);
        versionedClient.setName(clientNode.getName());
        versionedClient.setDescription(clientNode.getDescription());
        versionedClient.setProperties(this.mapProperties((ComponentNode)clientNode, serviceProvider));
        versionedClient.setPropertyDescriptors(this.mapPropertyDescriptors((ComponentNode)clientNode, serviceProvider, Collections.emptySet(), Collections.emptyMap()));
        versionedClient.setType(clientNode.getCanonicalClassName());
        return versionedClient;
    }

    public VersionedControllerService mapControllerService(ControllerServiceNode controllerService, ControllerServiceProvider serviceProvider, Set<String> includedGroupIds, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences) {
        InstantiatedVersionedControllerService versionedService = new InstantiatedVersionedControllerService(controllerService.getIdentifier(), controllerService.getProcessGroupIdentifier());
        versionedService.setIdentifier(this.getId(controllerService.getVersionedComponentId(), controllerService.getIdentifier()));
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            versionedService.setInstanceIdentifier(controllerService.getIdentifier());
        }
        versionedService.setGroupIdentifier(this.getGroupId(controllerService.getProcessGroupIdentifier()));
        versionedService.setName(controllerService.getName());
        versionedService.setAnnotationData(controllerService.getAnnotationData());
        versionedService.setBundle(this.mapBundle(controllerService.getBundleCoordinate()));
        versionedService.setComments(controllerService.getComments());
        versionedService.setBulletinLevel(controllerService.getBulletinLevel().name());
        versionedService.setControllerServiceApis(this.mapControllerServiceApis(controllerService));
        versionedService.setProperties(this.mapProperties((ComponentNode)controllerService, serviceProvider));
        versionedService.setPropertyDescriptors(this.mapPropertyDescriptors((ComponentNode)controllerService, serviceProvider, includedGroupIds, externalControllerServiceReferences));
        versionedService.setType(controllerService.getCanonicalClassName());
        versionedService.setScheduledState(this.flowMappingOptions.getStateLookup().getState(controllerService));
        return versionedService;
    }

    private Map<String, String> mapProperties(ComponentNode component, ControllerServiceProvider serviceProvider) {
        HashMap<String, String> mapped = new HashMap<String, String>();
        component.getProperties().keySet().stream().filter(property -> this.isMappable((PropertyDescriptor)property, component.getProperty(property))).forEach(property -> {
            ControllerServiceNode controllerService;
            String value = component.getRawPropertyValue(property);
            if (value == null) {
                value = property.getDefaultValue();
            }
            if (value != null && property.getControllerServiceDefinition() != null && this.flowMappingOptions.isMapControllerServiceReferencesToVersionedId() && (controllerService = serviceProvider.getControllerServiceNode(value)) != null) {
                value = this.getId(controllerService.getVersionedComponentId(), controllerService.getIdentifier());
            }
            if (property.isSensitive()) {
                value = this.encrypt(value);
            }
            mapped.put(property.getName(), value);
        });
        return mapped;
    }

    private String encrypt(String value) {
        if (value == null) {
            return null;
        }
        SensitiveValueEncryptor encryptor = this.flowMappingOptions.getSensitiveValueEncryptor();
        if (encryptor == null) {
            return value;
        }
        String encrypted = encryptor.encrypt(value);
        return ENCRYPTED_PREFIX + encrypted + ENCRYPTED_SUFFIX;
    }

    private boolean isMappable(PropertyDescriptor propertyDescriptor, PropertyConfiguration propertyConfiguration) {
        if (!propertyDescriptor.isSensitive()) {
            return true;
        }
        if (this.flowMappingOptions.isMapSensitiveConfiguration()) {
            return true;
        }
        if (propertyConfiguration == null) {
            return false;
        }
        return !propertyConfiguration.getParameterReferences().isEmpty();
    }

    private Map<String, VersionedPropertyDescriptor> mapPropertyDescriptors(ComponentNode component, ControllerServiceProvider serviceProvider, Set<String> includedGroupIds, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences) {
        if (!this.flowMappingOptions.isMapPropertyDescriptors()) {
            return Collections.emptyMap();
        }
        HashMap<String, VersionedPropertyDescriptor> descriptors = new HashMap<String, VersionedPropertyDescriptor>();
        for (PropertyDescriptor descriptor : component.getProperties().keySet()) {
            String value;
            VersionedPropertyDescriptor versionedDescriptor = new VersionedPropertyDescriptor();
            versionedDescriptor.setName(descriptor.getName());
            versionedDescriptor.setDisplayName(descriptor.getDisplayName());
            versionedDescriptor.setSensitive(descriptor.isSensitive());
            VersionedResourceDefinition versionedResourceDefinition = this.mapResourceDefinition(descriptor.getResourceDefinition());
            versionedDescriptor.setResourceDefinition(versionedResourceDefinition);
            Class referencedServiceType = descriptor.getControllerServiceDefinition();
            versionedDescriptor.setIdentifiesControllerService(referencedServiceType != null);
            if (referencedServiceType != null && (value = component.getProperty(descriptor).getRawValue()) != null) {
                ControllerServiceNode serviceNode = serviceProvider.getControllerServiceNode(value);
                if (serviceNode == null) continue;
                String serviceGroupId = serviceNode.getProcessGroupIdentifier();
                if (!includedGroupIds.contains(serviceGroupId)) {
                    String serviceId = this.getId(serviceNode.getVersionedComponentId(), serviceNode.getIdentifier());
                    ExternalControllerServiceReference controllerServiceReference = new ExternalControllerServiceReference();
                    controllerServiceReference.setIdentifier(serviceId);
                    controllerServiceReference.setName(serviceNode.getName());
                    externalControllerServiceReferences.put(serviceId, controllerServiceReference);
                }
            }
            descriptors.put(descriptor.getName(), versionedDescriptor);
        }
        return descriptors;
    }

    private VersionedResourceDefinition mapResourceDefinition(ResourceDefinition resourceDefinition) {
        if (resourceDefinition == null) {
            return null;
        }
        ResourceCardinality cardinality = resourceDefinition.getCardinality();
        VersionedResourceCardinality versionedCardinality = VersionedResourceCardinality.valueOf((String)cardinality.name());
        HashSet versionedResourceTypes = new HashSet();
        resourceDefinition.getResourceTypes().forEach(resourceType -> versionedResourceTypes.add(VersionedResourceType.valueOf((String)resourceType.name())));
        VersionedResourceDefinition versionedResourceDefinition = new VersionedResourceDefinition();
        versionedResourceDefinition.setCardinality(versionedCardinality);
        versionedResourceDefinition.setResourceTypes(versionedResourceTypes);
        return versionedResourceDefinition;
    }

    private Bundle mapBundle(BundleCoordinate coordinate) {
        Bundle versionedBundle = new Bundle();
        versionedBundle.setGroup(coordinate.getGroup());
        versionedBundle.setArtifact(coordinate.getId());
        versionedBundle.setVersion(coordinate.getVersion());
        return versionedBundle;
    }

    private List<ControllerServiceAPI> mapControllerServiceApis(ControllerServiceNode service) {
        Class<?> serviceClass = service.getControllerServiceImplementation().getClass();
        HashSet<Class> serviceApiClasses = new HashSet<Class>();
        List interfaces = ClassUtils.getAllInterfaces(serviceClass);
        for (Class i : interfaces) {
            if (!ControllerService.class.isAssignableFrom(i) || ControllerService.class.equals((Object)i)) continue;
            serviceApiClasses.add(i);
        }
        ArrayList<ControllerServiceAPI> serviceApis = new ArrayList<ControllerServiceAPI>();
        for (Class serviceApiClass : serviceApiClasses) {
            BundleCoordinate bundleCoordinate = this.extensionManager.getBundle(serviceApiClass.getClassLoader()).getBundleDetails().getCoordinate();
            ControllerServiceAPI serviceApi = new ControllerServiceAPI();
            serviceApi.setType(serviceApiClass.getName());
            serviceApi.setBundle(this.mapBundle(bundleCoordinate));
            serviceApis.add(serviceApi);
        }
        return serviceApis;
    }

    public VersionedFunnel mapFunnel(Funnel funnel) {
        InstantiatedVersionedFunnel versionedFunnel = new InstantiatedVersionedFunnel(funnel.getIdentifier(), funnel.getProcessGroupIdentifier());
        versionedFunnel.setIdentifier(this.getId(funnel.getVersionedComponentId(), funnel.getIdentifier()));
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            versionedFunnel.setInstanceIdentifier(funnel.getIdentifier());
        }
        versionedFunnel.setGroupIdentifier(this.getGroupId(funnel.getProcessGroupIdentifier()));
        versionedFunnel.setPosition(this.mapPosition(funnel.getPosition()));
        return versionedFunnel;
    }

    public VersionedLabel mapLabel(Label label) {
        InstantiatedVersionedLabel versionedLabel = new InstantiatedVersionedLabel(label.getIdentifier(), label.getProcessGroupIdentifier());
        versionedLabel.setIdentifier(this.getId(label.getVersionedComponentId(), label.getIdentifier()));
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            versionedLabel.setInstanceIdentifier(label.getIdentifier());
        }
        versionedLabel.setGroupIdentifier(this.getGroupId(label.getProcessGroupIdentifier()));
        versionedLabel.setHeight(label.getSize().getHeight());
        versionedLabel.setWidth(label.getSize().getWidth());
        versionedLabel.setLabel(label.getValue());
        versionedLabel.setPosition(this.mapPosition(label.getPosition()));
        versionedLabel.setStyle(label.getStyle());
        versionedLabel.setzIndex(label.getZIndex());
        return versionedLabel;
    }

    public VersionedPort mapPort(Port port) {
        InstantiatedVersionedPort versionedPort = new InstantiatedVersionedPort(port.getIdentifier(), port.getProcessGroupIdentifier());
        versionedPort.setIdentifier(this.getId(port.getVersionedComponentId(), port.getIdentifier()));
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            versionedPort.setInstanceIdentifier(port.getIdentifier());
        }
        versionedPort.setGroupIdentifier(this.getGroupId(port.getProcessGroupIdentifier()));
        versionedPort.setComments(port.getComments());
        versionedPort.setConcurrentlySchedulableTaskCount(port.getMaxConcurrentTasks());
        versionedPort.setName(port.getName());
        versionedPort.setPosition(this.mapPosition(port.getPosition()));
        versionedPort.setType(PortType.valueOf((String)port.getConnectableType().name()));
        versionedPort.setScheduledState(this.mapScheduledState(port.getScheduledState()));
        versionedPort.setAllowRemoteAccess(port instanceof PublicPort);
        versionedPort.setScheduledState(this.flowMappingOptions.getStateLookup().getState(port));
        return versionedPort;
    }

    public org.apache.nifi.flow.Position mapPosition(Position pos) {
        org.apache.nifi.flow.Position position = new org.apache.nifi.flow.Position();
        position.setX(pos.getX());
        position.setY(pos.getY());
        return position;
    }

    public VersionedProcessor mapProcessor(ProcessorNode procNode, ControllerServiceProvider serviceProvider, Set<String> includedGroupIds, Map<String, ExternalControllerServiceReference> externalControllerServiceReferences) {
        InstantiatedVersionedProcessor processor = new InstantiatedVersionedProcessor(procNode.getIdentifier(), procNode.getProcessGroupIdentifier());
        processor.setIdentifier(this.getId(procNode.getVersionedComponentId(), procNode.getIdentifier()));
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            processor.setInstanceIdentifier(procNode.getIdentifier());
        }
        processor.setGroupIdentifier(this.getGroupId(procNode.getProcessGroupIdentifier()));
        processor.setType(procNode.getCanonicalClassName());
        processor.setAnnotationData(procNode.getAnnotationData());
        processor.setAutoTerminatedRelationships(procNode.getAutoTerminatedRelationships().stream().map(Relationship::getName).collect(Collectors.toSet()));
        processor.setBulletinLevel(procNode.getBulletinLevel().name());
        processor.setBundle(this.mapBundle(procNode.getBundleCoordinate()));
        processor.setComments(procNode.getComments());
        processor.setConcurrentlySchedulableTaskCount(procNode.getMaxConcurrentTasks());
        processor.setExecutionNode(procNode.getExecutionNode().name());
        processor.setName(procNode.getName());
        processor.setPenaltyDuration(procNode.getPenalizationPeriod());
        processor.setPosition(this.mapPosition(procNode.getPosition()));
        processor.setProperties(this.mapProperties((ComponentNode)procNode, serviceProvider));
        processor.setPropertyDescriptors(this.mapPropertyDescriptors((ComponentNode)procNode, serviceProvider, includedGroupIds, externalControllerServiceReferences));
        processor.setRunDurationMillis(procNode.getRunDuration(TimeUnit.MILLISECONDS));
        processor.setSchedulingPeriod(procNode.getSchedulingPeriod());
        processor.setSchedulingStrategy(procNode.getSchedulingStrategy().name());
        processor.setStyle(procNode.getStyle());
        processor.setYieldDuration(procNode.getYieldPeriod());
        processor.setScheduledState(this.flowMappingOptions.getStateLookup().getState(procNode));
        processor.setRetryCount(procNode.getRetryCount());
        processor.setRetriedRelationships(procNode.getRetriedRelationships());
        processor.setBackoffMechanism(procNode.getBackoffMechanism().name());
        processor.setMaxBackoffPeriod(procNode.getMaxBackoffPeriod());
        return processor;
    }

    public VersionedRemoteProcessGroup mapRemoteProcessGroup(RemoteProcessGroup remoteGroup) {
        InstantiatedVersionedRemoteProcessGroup rpg = new InstantiatedVersionedRemoteProcessGroup(remoteGroup.getIdentifier(), remoteGroup.getProcessGroupIdentifier());
        rpg.setIdentifier(this.getId(remoteGroup.getVersionedComponentId(), remoteGroup.getIdentifier()));
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            rpg.setInstanceIdentifier(remoteGroup.getIdentifier());
        }
        rpg.setGroupIdentifier(this.getGroupId(remoteGroup.getProcessGroupIdentifier()));
        rpg.setComments(remoteGroup.getComments());
        rpg.setCommunicationsTimeout(remoteGroup.getCommunicationsTimeout());
        rpg.setLocalNetworkInterface(remoteGroup.getNetworkInterface());
        rpg.setName(remoteGroup.getName());
        rpg.setInputPorts(remoteGroup.getInputPorts().stream().map(port -> this.mapRemotePort((RemoteGroupPort)port, ComponentType.REMOTE_INPUT_PORT)).collect(Collectors.toSet()));
        rpg.setOutputPorts(remoteGroup.getOutputPorts().stream().map(port -> this.mapRemotePort((RemoteGroupPort)port, ComponentType.REMOTE_OUTPUT_PORT)).collect(Collectors.toSet()));
        rpg.setPosition(this.mapPosition(remoteGroup.getPosition()));
        rpg.setProxyHost(remoteGroup.getProxyHost());
        rpg.setProxyPort(remoteGroup.getProxyPort());
        rpg.setProxyUser(remoteGroup.getProxyUser());
        if (this.flowMappingOptions.isMapSensitiveConfiguration()) {
            rpg.setProxyPassword(this.encrypt(remoteGroup.getProxyPassword()));
        }
        rpg.setTargetUri(remoteGroup.getTargetUri());
        rpg.setTargetUris(remoteGroup.getTargetUris());
        rpg.setTransportProtocol(remoteGroup.getTransportProtocol().name());
        rpg.setYieldDuration(remoteGroup.getYieldDuration());
        return rpg;
    }

    public VersionedRemoteGroupPort mapRemotePort(RemoteGroupPort remotePort, ComponentType componentType) {
        InstantiatedVersionedRemoteGroupPort port = new InstantiatedVersionedRemoteGroupPort(remotePort.getIdentifier(), remotePort.getRemoteProcessGroup().getIdentifier());
        port.setIdentifier(this.getId(remotePort.getVersionedComponentId(), remotePort.getIdentifier()));
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            port.setInstanceIdentifier(remotePort.getIdentifier());
        }
        port.setGroupIdentifier(this.getGroupId(remotePort.getRemoteProcessGroup().getIdentifier()));
        port.setComments(remotePort.getComments());
        port.setConcurrentlySchedulableTaskCount(remotePort.getMaxConcurrentTasks());
        port.setRemoteGroupId(this.getGroupId(remotePort.getRemoteProcessGroup().getIdentifier()));
        port.setName(remotePort.getName());
        port.setUseCompression(remotePort.isUseCompression());
        port.setBatchSize(this.mapBatchSettings(remotePort));
        port.setTargetId(remotePort.getTargetIdentifier());
        port.setComponentType(componentType);
        port.setScheduledState(this.flowMappingOptions.getStateLookup().getState((Port)remotePort));
        return port;
    }

    private BatchSize mapBatchSettings(RemoteGroupPort remotePort) {
        BatchSize batchSize = new BatchSize();
        batchSize.setCount(remotePort.getBatchCount());
        batchSize.setDuration(remotePort.getBatchDuration());
        batchSize.setSize(remotePort.getBatchSize());
        return batchSize;
    }

    public VersionedParameterContext mapParameterContext(ParameterContext parameterContext) {
        Set<VersionedParameter> versionedParameters = this.mapParameters(parameterContext);
        VersionedParameterContext versionedParameterContext = new VersionedParameterContext();
        versionedParameterContext.setDescription(parameterContext.getDescription());
        versionedParameterContext.setName(parameterContext.getName());
        versionedParameterContext.setParameters(versionedParameters);
        String versionedContextId = this.flowMappingOptions.getComponentIdLookup().getComponentId(Optional.empty(), parameterContext.getIdentifier());
        versionedParameterContext.setIdentifier(versionedContextId);
        versionedParameterContext.setInheritedParameterContexts(parameterContext.getInheritedParameterContextNames());
        this.configureParameterProvider(parameterContext, versionedParameterContext);
        if (this.flowMappingOptions.isMapInstanceIdentifiers()) {
            versionedParameterContext.setInstanceIdentifier(parameterContext.getIdentifier());
        }
        return versionedParameterContext;
    }

    private void configureParameterProvider(ParameterContext parameterContext, VersionedParameterContext versionedParameterContext) {
        ParameterProviderConfiguration parameterProviderConfiguration = parameterContext.getParameterProviderConfiguration();
        if (parameterProviderConfiguration != null) {
            versionedParameterContext.setParameterGroupName(parameterProviderConfiguration.getParameterGroupName());
            versionedParameterContext.setParameterProvider(parameterProviderConfiguration.getParameterProviderId());
            versionedParameterContext.setSynchronized(Boolean.valueOf(parameterProviderConfiguration.isSynchronized()));
        }
    }

    public Map<String, VersionedParameterContext> mapParameterContexts(ProcessGroup processGroup, boolean mapDescendantVersionedFlows, Map<String, ParameterProviderReference> parameterProviderReferences) {
        HashMap<String, VersionedParameterContext> parameterContexts = new HashMap<String, VersionedParameterContext>();
        this.mapParameterContexts(processGroup, mapDescendantVersionedFlows, parameterContexts, parameterProviderReferences);
        return parameterContexts;
    }

    private void mapParameterContexts(ProcessGroup processGroup, boolean mapDescendantVersionedFlows, Map<String, VersionedParameterContext> parameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences) {
        ParameterContext parameterContext = processGroup.getParameterContext();
        if (parameterContext != null) {
            this.mapParameterContext(parameterContext, parameterContexts, parameterProviderReferences);
        }
        for (ProcessGroup child : processGroup.getProcessGroups()) {
            if (!mapDescendantVersionedFlows && child.getVersionControlInformation() != null) continue;
            this.mapParameterContexts(child, mapDescendantVersionedFlows, parameterContexts, parameterProviderReferences);
        }
    }

    private void mapParameterContext(ParameterContext parameterContext, Map<String, VersionedParameterContext> parameterContexts, Map<String, ParameterProviderReference> parameterProviderReferences) {
        if (parameterContexts.containsKey(parameterContext.getName())) {
            return;
        }
        Set<VersionedParameter> parameters = this.mapParameters(parameterContext);
        VersionedParameterContext versionedContext = new VersionedParameterContext();
        versionedContext.setName(parameterContext.getName());
        versionedContext.setParameters(parameters);
        versionedContext.setInheritedParameterContexts(parameterContext.getInheritedParameterContextNames());
        this.configureParameterProvider(parameterContext, versionedContext);
        if (versionedContext.getParameterProvider() != null) {
            parameterProviderReferences.put(versionedContext.getParameterProvider(), this.createParameterProviderReference(parameterContext));
        }
        for (ParameterContext inheritedParameterContext : parameterContext.getInheritedParameterContexts()) {
            this.mapParameterContext(inheritedParameterContext, parameterContexts, parameterProviderReferences);
        }
        parameterContexts.put(versionedContext.getName(), versionedContext);
    }

    private Set<VersionedParameter> mapParameters(ParameterContext parameterContext) {
        Set<VersionedParameter> parameters = parameterContext.getParameters().entrySet().stream().map(descriptorAndParameter -> this.mapParameter(parameterContext, (ParameterDescriptor)descriptorAndParameter.getKey(), (Parameter)descriptorAndParameter.getValue())).collect(Collectors.toSet());
        return parameters;
    }

    private VersionedParameter mapParameter(ParameterContext parameterContext, ParameterDescriptor parameterDescriptor, Parameter parameter) {
        List referencedControllerServiceData;
        VersionedParameter versionedParameter = this.flowMappingOptions.isMapControllerServiceReferencesToVersionedId() ? ((referencedControllerServiceData = parameterContext.getParameterReferenceManager().getReferencedControllerServiceData(parameterContext, parameterDescriptor.getName())).isEmpty() ? this.mapParameter(parameter) : this.mapParameter(parameter, this.getId(Optional.ofNullable(((ParameterReferencedControllerServiceData)referencedControllerServiceData.get(0)).getVersionedServiceId()), parameter.getValue()))) : this.mapParameter(parameter);
        return versionedParameter;
    }

    private ParameterProviderReference createParameterProviderReference(ParameterContext parameterContext) {
        if (parameterContext.getParameterProvider() == null) {
            return null;
        }
        ParameterProviderReference reference = new ParameterProviderReference();
        ParameterProvider parameterProvider = parameterContext.getParameterProvider();
        ParameterProviderNode parameterProviderNode = parameterContext.getParameterProviderLookup().getParameterProvider(parameterProvider.getIdentifier());
        BundleCoordinate bundleCoordinate = parameterProviderNode.getBundleCoordinate();
        reference.setIdentifier(parameterProvider.getIdentifier());
        reference.setName(parameterProviderNode.getName());
        reference.setType(parameterProvider.getClass().getName());
        reference.setBundle(new Bundle(bundleCoordinate.getGroup(), bundleCoordinate.getId(), bundleCoordinate.getVersion()));
        return reference;
    }

    private VersionedParameter mapParameter(Parameter parameter) {
        return this.mapParameter(parameter, parameter.getValue());
    }

    private VersionedParameter mapParameter(Parameter parameter, String value) {
        boolean mapParameterValue;
        ParameterDescriptor descriptor = parameter.getDescriptor();
        VersionedParameter versionedParameter = new VersionedParameter();
        versionedParameter.setDescription(descriptor.getDescription());
        versionedParameter.setName(descriptor.getName());
        versionedParameter.setSensitive(descriptor.isSensitive());
        versionedParameter.setProvided(parameter.isProvided());
        boolean bl = mapParameterValue = this.flowMappingOptions.isMapSensitiveConfiguration() || !descriptor.isSensitive();
        String parameterValue = mapParameterValue ? (descriptor.isSensitive() ? this.encrypt(value) : value) : null;
        versionedParameter.setValue(parameterValue);
        return versionedParameter;
    }

    private ScheduledState mapScheduledState(org.apache.nifi.controller.ScheduledState scheduledState) {
        return scheduledState == org.apache.nifi.controller.ScheduledState.DISABLED ? ScheduledState.DISABLED : ScheduledState.ENABLED;
    }
}

