/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.DefaultCairoConfiguration;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.history.ComponentDetails;
import org.apache.nifi.controller.status.history.EmbeddedQuestDbRolloverHandler;
import org.apache.nifi.controller.status.history.GarbageCollectionHistory;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.controller.status.history.InMemoryComponentDetailsStorage;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.controller.status.history.questdb.QuestDbContext;
import org.apache.nifi.controller.status.history.questdb.QuestDbDatabaseManager;
import org.apache.nifi.controller.status.history.storage.BufferedWriterFlushWorker;
import org.apache.nifi.controller.status.history.storage.BufferedWriterForStatusStorage;
import org.apache.nifi.controller.status.history.storage.ComponentStatusStorage;
import org.apache.nifi.controller.status.history.storage.GarbageCollectionStatusStorage;
import org.apache.nifi.controller.status.history.storage.NodeStatusStorage;
import org.apache.nifi.controller.status.history.storage.ProcessorStatusStorage;
import org.apache.nifi.controller.status.history.storage.questdb.QuestDbConnectionStatusStorage;
import org.apache.nifi.controller.status.history.storage.questdb.QuestDbGarbageCollectionStatusStorage;
import org.apache.nifi.controller.status.history.storage.questdb.QuestDbNodeStatusStorage;
import org.apache.nifi.controller.status.history.storage.questdb.QuestDbProcessGroupStatusStorage;
import org.apache.nifi.controller.status.history.storage.questdb.QuestDbProcessorStatusStorage;
import org.apache.nifi.controller.status.history.storage.questdb.QuestDbRemoteProcessGroupStatusStorage;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedQuestDbStatusHistoryRepository
implements StatusHistoryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedQuestDbStatusHistoryRepository.class);
    private static final int PERSIST_BATCH_SIZE = 1000;
    private static final long PERSIST_FREQUENCY = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    private static final long ROLL_FREQUENCY = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES);
    private final InMemoryComponentDetailsStorage componentDetailsProvider = new InMemoryComponentDetailsStorage();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(3, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("EmbeddedQuestDbStatusHistoryRepositoryWorker-%d").build());
    private final QuestDbContext dbContext;
    private final long persistFrequency;
    private final int daysToKeepNodeData;
    private final int daysToKeepComponentData;
    private final ProcessorStatusStorage processorStatusStorage;
    private final ComponentStatusStorage<ConnectionStatus> connectionStatusStorage;
    private final ComponentStatusStorage<ProcessGroupStatus> processGroupStatusStorage;
    private final ComponentStatusStorage<RemoteProcessGroupStatus> remoteProcessGroupStatusStorage;
    private final NodeStatusStorage nodeStatusStorage;
    private final GarbageCollectionStatusStorage garbageCollectionStatusStorage;
    private final BufferedWriterForStatusStorage<ProcessorStatus> processorStatusWriter;
    private final BufferedWriterForStatusStorage<ConnectionStatus> connectionStatusWriter;
    private final BufferedWriterForStatusStorage<ProcessGroupStatus> processGroupStatusWriter;
    private final BufferedWriterForStatusStorage<RemoteProcessGroupStatus> remoteProcessGroupStatusWriter;
    private final BufferedWriterForStatusStorage<NodeStatus> nodeStatusWriter;
    private final BufferedWriterForStatusStorage<GarbageCollectionStatus> garbageCollectionStatusWriter;

    public EmbeddedQuestDbStatusHistoryRepository() {
        this.dbContext = null;
        this.persistFrequency = PERSIST_FREQUENCY;
        this.daysToKeepNodeData = -1;
        this.daysToKeepComponentData = -1;
        this.processorStatusStorage = null;
        this.connectionStatusStorage = null;
        this.processGroupStatusStorage = null;
        this.remoteProcessGroupStatusStorage = null;
        this.nodeStatusStorage = null;
        this.garbageCollectionStatusStorage = null;
        this.processorStatusWriter = null;
        this.connectionStatusWriter = null;
        this.processGroupStatusWriter = null;
        this.remoteProcessGroupStatusWriter = null;
        this.nodeStatusWriter = null;
        this.garbageCollectionStatusWriter = null;
    }

    public EmbeddedQuestDbStatusHistoryRepository(NiFiProperties niFiProperties) {
        this(niFiProperties, PERSIST_FREQUENCY);
    }

    EmbeddedQuestDbStatusHistoryRepository(NiFiProperties niFiProperties, long persistFrequency) {
        Path persistLocation = niFiProperties.getQuestDbStatusRepositoryPath();
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration((CharSequence)persistLocation.toString());
        QuestDbDatabaseManager.checkDatabaseStatus(persistLocation);
        this.persistFrequency = persistFrequency;
        this.daysToKeepNodeData = this.getDaysToKeepNodeData(niFiProperties);
        this.daysToKeepComponentData = this.getDaysToKeepComponentData(niFiProperties);
        this.dbContext = new QuestDbContext(new CairoEngine((CairoConfiguration)configuration));
        this.nodeStatusStorage = new QuestDbNodeStatusStorage(this.dbContext);
        this.garbageCollectionStatusStorage = new QuestDbGarbageCollectionStatusStorage(this.dbContext);
        this.processorStatusStorage = new QuestDbProcessorStatusStorage(this.dbContext, this.componentDetailsProvider);
        this.connectionStatusStorage = new QuestDbConnectionStatusStorage(this.dbContext, this.componentDetailsProvider);
        this.processGroupStatusStorage = new QuestDbProcessGroupStatusStorage(this.dbContext, this.componentDetailsProvider);
        this.remoteProcessGroupStatusStorage = new QuestDbRemoteProcessGroupStatusStorage(this.dbContext, this.componentDetailsProvider);
        this.nodeStatusWriter = new BufferedWriterForStatusStorage<NodeStatus>(this.nodeStatusStorage, 1000);
        this.garbageCollectionStatusWriter = new BufferedWriterForStatusStorage<GarbageCollectionStatus>(this.garbageCollectionStatusStorage, 1000);
        this.processorStatusWriter = new BufferedWriterForStatusStorage<ProcessorStatus>(this.processorStatusStorage, 1000);
        this.connectionStatusWriter = new BufferedWriterForStatusStorage<ConnectionStatus>(this.connectionStatusStorage, 1000);
        this.processGroupStatusWriter = new BufferedWriterForStatusStorage<ProcessGroupStatus>(this.processGroupStatusStorage, 1000);
        this.remoteProcessGroupStatusWriter = new BufferedWriterForStatusStorage<RemoteProcessGroupStatus>(this.remoteProcessGroupStatusStorage, 1000);
    }

    public void start() {
        LOGGER.debug("Starting status history repository");
        EmbeddedQuestDbRolloverHandler nodeRolloverHandler = new EmbeddedQuestDbRolloverHandler(QuestDbDatabaseManager.getNodeTableNames(), this.daysToKeepNodeData, this.dbContext);
        EmbeddedQuestDbRolloverHandler componentRolloverHandler = new EmbeddedQuestDbRolloverHandler(QuestDbDatabaseManager.getComponentTableNames(), this.daysToKeepComponentData, this.dbContext);
        BufferedWriterFlushWorker writer = new BufferedWriterFlushWorker(Arrays.asList(this.nodeStatusWriter, this.garbageCollectionStatusWriter, this.processorStatusWriter, this.connectionStatusWriter, this.processGroupStatusWriter, this.remoteProcessGroupStatusWriter));
        this.scheduledExecutorService.scheduleWithFixedDelay(nodeRolloverHandler, 0L, ROLL_FREQUENCY, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleWithFixedDelay(componentRolloverHandler, 0L, ROLL_FREQUENCY, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleWithFixedDelay(writer, 0L, this.persistFrequency, TimeUnit.MILLISECONDS);
        LOGGER.debug("Status history repository is started");
    }

    public void shutdown() {
        LOGGER.debug("Status history repository started to shut down");
        this.scheduledExecutorService.shutdown();
        this.dbContext.close();
        LOGGER.debug("Status history repository has been shut down");
    }

    public void capture(NodeStatus nodeStatus, ProcessGroupStatus rootGroupStatus, List<GarbageCollectionStatus> garbageCollectionStatus, Date capturedAt) {
        this.captureNodeLevelStatus(nodeStatus, garbageCollectionStatus, capturedAt.toInstant());
        this.captureComponentLevelStatus(rootGroupStatus, capturedAt.toInstant());
    }

    private void captureComponentLevelStatus(ProcessGroupStatus rootGroupStatus, Instant capturedAt) {
        this.captureComponents(rootGroupStatus, capturedAt);
        this.updateComponentDetails(rootGroupStatus);
    }

    private void captureNodeLevelStatus(NodeStatus nodeStatus, List<GarbageCollectionStatus> garbageCollectionStatus, Instant capturedAt) {
        this.nodeStatusWriter.collect((Pair<Instant, NodeStatus>)new ImmutablePair((Object)capturedAt, (Object)nodeStatus));
        garbageCollectionStatus.forEach(s -> this.garbageCollectionStatusWriter.collect((Pair<Instant, GarbageCollectionStatus>)new ImmutablePair((Object)capturedAt, s)));
    }

    private void captureComponents(ProcessGroupStatus groupStatus, Instant capturedAt) {
        this.processGroupStatusWriter.collect((Pair<Instant, ProcessGroupStatus>)new ImmutablePair((Object)capturedAt, (Object)groupStatus));
        groupStatus.getConnectionStatus().forEach(s -> this.connectionStatusWriter.collect((Pair<Instant, ConnectionStatus>)new ImmutablePair((Object)capturedAt, s)));
        groupStatus.getRemoteProcessGroupStatus().forEach(s -> this.remoteProcessGroupStatusWriter.collect((Pair<Instant, RemoteProcessGroupStatus>)new ImmutablePair((Object)capturedAt, s)));
        groupStatus.getProcessorStatus().forEach(s -> this.processorStatusWriter.collect((Pair<Instant, ProcessorStatus>)new ImmutablePair((Object)capturedAt, s)));
        groupStatus.getProcessGroupStatus().forEach(childGroupStatus -> this.captureComponents((ProcessGroupStatus)childGroupStatus, capturedAt));
    }

    private void updateComponentDetails(ProcessGroupStatus groupStatus) {
        HashMap<String, ComponentDetails> accumulator = new HashMap<String, ComponentDetails>();
        this.updateComponentDetails(groupStatus, accumulator);
        this.componentDetailsProvider.setComponentDetails(accumulator);
    }

    private void updateComponentDetails(ProcessGroupStatus groupStatus, Map<String, ComponentDetails> accumulator) {
        accumulator.put(groupStatus.getId(), ComponentDetails.forProcessGroup(groupStatus));
        groupStatus.getConnectionStatus().forEach(status -> accumulator.put(status.getId(), ComponentDetails.forConnection(status)));
        groupStatus.getRemoteProcessGroupStatus().forEach(status -> accumulator.put(status.getId(), ComponentDetails.forRemoteProcessGroup(status)));
        groupStatus.getProcessorStatus().forEach(status -> accumulator.put(status.getId(), ComponentDetails.forProcessor(status)));
        groupStatus.getProcessGroupStatus().forEach(childGroupStatus -> this.updateComponentDetails((ProcessGroupStatus)childGroupStatus, accumulator));
    }

    public StatusHistory getConnectionStatusHistory(String connectionId, Date start, Date end, int preferredDataPoints) {
        return this.connectionStatusStorage.read(connectionId, this.getStartTime(start), this.getEndTime(end), preferredDataPoints);
    }

    public StatusHistory getProcessGroupStatusHistory(String processGroupId, Date start, Date end, int preferredDataPoints) {
        return this.processGroupStatusStorage.read(processGroupId, this.getStartTime(start), this.getEndTime(end), preferredDataPoints);
    }

    public StatusHistory getProcessorStatusHistory(String processorId, Date start, Date end, int preferredDataPoints, boolean includeCounters) {
        return includeCounters ? this.processorStatusStorage.readWithCounter(processorId, this.getStartTime(start), this.getEndTime(end), preferredDataPoints) : this.processorStatusStorage.read(processorId, this.getStartTime(start), this.getEndTime(end), preferredDataPoints);
    }

    public StatusHistory getRemoteProcessGroupStatusHistory(String remoteGroupId, Date start, Date end, int preferredDataPoints) {
        return this.remoteProcessGroupStatusStorage.read(remoteGroupId, this.getStartTime(start), this.getEndTime(end), preferredDataPoints);
    }

    public GarbageCollectionHistory getGarbageCollectionHistory(Date start, Date end) {
        return this.garbageCollectionStatusStorage.read(this.getStartTime(start), this.getEndTime(end));
    }

    public StatusHistory getNodeStatusHistory(Date start, Date end) {
        return this.nodeStatusStorage.read(this.getStartTime(start), this.getEndTime(end));
    }

    private Integer getDaysToKeepNodeData(NiFiProperties niFiProperties) {
        return niFiProperties.getIntegerProperty("nifi.status.repository.questdb.persist.node.days", Integer.valueOf(14));
    }

    private Integer getDaysToKeepComponentData(NiFiProperties niFiProperties) {
        return niFiProperties.getIntegerProperty("nifi.status.repository.questdb.persist.component.days", Integer.valueOf(3));
    }

    private Instant getStartTime(Date start) {
        if (start == null) {
            return Instant.now().minus(1L, ChronoUnit.DAYS);
        }
        return start.toInstant();
    }

    private Instant getEndTime(Date end) {
        return end == null ? Instant.now() : end.toInstant();
    }
}

