/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state.providers.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.components.state.StateProviderInitializationContext;
import org.apache.nifi.components.state.annotation.StateProviderContext;
import org.apache.nifi.components.state.exception.StateTooLargeException;
import org.apache.nifi.controller.cluster.SecureClientZooKeeperFactory;
import org.apache.nifi.controller.cluster.ZooKeeperClientConfig;
import org.apache.nifi.controller.state.StandardStateMap;
import org.apache.nifi.controller.state.providers.AbstractStateProvider;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.NiFiProperties;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ConnectStringParser;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperStateProvider
extends AbstractStateProvider {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperStateProvider.class);
    private NiFiProperties nifiProperties;
    static final AllowableValue OPEN_TO_WORLD = new AllowableValue("Open", "Open", "ZNodes will be open to any ZooKeeper client.");
    static final AllowableValue CREATOR_ONLY = new AllowableValue("CreatorOnly", "CreatorOnly", "ZNodes will be accessible only by the creator. The creator will have full access to create, read, write, delete, and administer the ZNodes.");
    static final PropertyDescriptor CONNECTION_STRING = new PropertyDescriptor.Builder().name("Connect String").description("The ZooKeeper Connect String to use. This is a comma-separated list of hostname/IP and port tuples, such as \"host1:2181,host2:2181,127.0.0.1:2181\". If a port is not specified it defaults to the ZooKeeper client port default of 2181").addValidator(new Validator(){

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            String connectionString = context.getProperty(CONNECTION_STRING).getValue();
            try {
                new ConnectStringParser(connectionString);
            }
            catch (Exception e) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Invalid Connect String: " + connectionString).valid(false).build();
            }
            return new ValidationResult.Builder().subject(subject).input(input).explanation("Valid Connect String").valid(true).build();
        }
    }).addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor SESSION_TIMEOUT = new PropertyDescriptor.Builder().name("Session Timeout").description("Specifies how long this instance of NiFi is allowed to be disconnected from ZooKeeper before creating a new ZooKeeper Session").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 sec").required(true).build();
    static final PropertyDescriptor ROOT_NODE = new PropertyDescriptor.Builder().name("Root Node").description("The Root Node to use in ZooKeeper to store state in").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("/nifi").required(true).build();
    static final PropertyDescriptor ACCESS_CONTROL = new PropertyDescriptor.Builder().name("Access Control").description("Specifies the Access Controls that will be placed on ZooKeeper ZNodes that are created by this State Provider").allowableValues(new AllowableValue[]{OPEN_TO_WORLD, CREATOR_ONLY}).defaultValue(OPEN_TO_WORLD.getValue()).required(true).build();
    private static final byte ENCODING_VERSION = 1;
    private ZooKeeper zooKeeper;
    private int timeoutMillis;
    private String rootNode;
    private String connectionString;
    private byte[] auth;
    private List<ACL> acl;
    private ZooKeeperClientConfig zooKeeperClientConfig;

    @StateProviderContext
    public void setNiFiProperties(NiFiProperties properties) {
        this.nifiProperties = properties;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(CONNECTION_STRING);
        properties.add(SESSION_TIMEOUT);
        properties.add(ROOT_NODE);
        properties.add(ACCESS_CONTROL);
        return properties;
    }

    @Override
    public synchronized void init(StateProviderInitializationContext context) {
        this.connectionString = context.getProperty(CONNECTION_STRING).getValue();
        this.rootNode = context.getProperty(ROOT_NODE).getValue();
        this.timeoutMillis = context.getProperty(SESSION_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        this.acl = context.getProperty(ACCESS_CONTROL).getValue().equalsIgnoreCase(CREATOR_ONLY.getValue()) ? ZooDefs.Ids.CREATOR_ALL_ACL : ZooDefs.Ids.OPEN_ACL_UNSAFE;
    }

    static NiFiProperties combineProperties(final NiFiProperties nifiProps, final Properties additionalProperties) {
        return new NiFiProperties(){

            public String getProperty(String key) {
                return additionalProperties.getProperty(key, nifiProps != null ? nifiProps.getProperty(key) : null);
            }

            public Set<String> getPropertyKeys() {
                Set<String> prop = additionalProperties.keySet().stream().map(key -> (String)key).collect(Collectors.toSet());
                prop.addAll(nifiProps.getPropertyKeys());
                return prop;
            }
        };
    }

    public synchronized void shutdown() {
        if (this.zooKeeper != null) {
            try {
                this.zooKeeper.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.zooKeeper = null;
    }

    synchronized ZooKeeper getZooKeeper() throws IOException {
        ZooKeeperClientConfig clientConfig = this.getZooKeeperConfig();
        if (this.zooKeeper != null && !this.zooKeeper.getState().isAlive()) {
            this.invalidateClient();
        }
        if (this.zooKeeper == null) {
            if (clientConfig != null && clientConfig.isClientSecure()) {
                SecureClientZooKeeperFactory factory = new SecureClientZooKeeperFactory(clientConfig);
                try {
                    this.zooKeeper = factory.newZooKeeper(this.connectionString, this.timeoutMillis, new NoOpWatcher(), true);
                    logger.debug("Secure ZooKeeper Client connection [{}] created", (Object)this.connectionString);
                }
                catch (Exception e) {
                    logger.error("Secure ZooKeeper Client connection [{}] failed", (Object)this.connectionString, (Object)e);
                    this.invalidateClient();
                }
            } else {
                ZKClientConfig zkClientConfig = new ZKClientConfig();
                if (clientConfig != null) {
                    zkClientConfig.setProperty("jute.maxbuffer", Integer.toString(clientConfig.getJuteMaxbuffer()));
                }
                this.zooKeeper = new ZooKeeper(this.connectionString, this.timeoutMillis, (Watcher)new NoOpWatcher(), zkClientConfig);
                logger.debug("Standard ZooKeeper Client connection [{}] created", (Object)this.connectionString);
            }
            if (this.auth != null) {
                this.zooKeeper.addAuthInfo("digest", this.auth);
            }
        }
        return this.zooKeeper;
    }

    private ZooKeeperClientConfig getZooKeeperConfig() {
        if (this.zooKeeperClientConfig == null) {
            Properties stateProviderProperties = new Properties();
            stateProviderProperties.setProperty("nifi.zookeeper.session.timeout", this.timeoutMillis + " millis");
            stateProviderProperties.setProperty("nifi.zookeeper.connect.timeout", this.timeoutMillis + " millis");
            stateProviderProperties.setProperty("nifi.zookeeper.root.node", this.rootNode);
            stateProviderProperties.setProperty("nifi.zookeeper.connect.string", this.connectionString);
            this.zooKeeperClientConfig = ZooKeeperClientConfig.createConfig(ZooKeeperStateProvider.combineProperties(this.nifiProperties, stateProviderProperties));
        }
        return this.zooKeeperClientConfig;
    }

    private synchronized void invalidateClient() {
        this.shutdown();
    }

    private String getComponentPath(String componentId) {
        return this.rootNode + "/components/" + componentId;
    }

    private void verifyEnabled() throws IOException {
        if (!this.isEnabled()) {
            throw new IOException("Cannot update or retrieve cluster state because node is no longer connected to a cluster.");
        }
    }

    public void onComponentRemoved(String componentId) throws IOException {
        try {
            ZKUtil.deleteRecursive((ZooKeeper)this.getZooKeeper(), (String)this.getComponentPath(componentId));
        }
        catch (KeeperException ke) {
            KeeperException.Code exceptionCode = ke.code();
            if (KeeperException.Code.NONODE == exceptionCode) {
                return;
            }
            if (KeeperException.Code.SESSIONEXPIRED == exceptionCode) {
                this.invalidateClient();
                this.onComponentRemoved(componentId);
                return;
            }
            throw new IOException("Unable to remove state for component with ID '" + componentId + " with exception code " + exceptionCode, ke);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to remove state for component with ID '" + componentId + "' from ZooKeeper due to being interrupted", e);
        }
    }

    public Scope[] getSupportedScopes() {
        return new Scope[]{Scope.CLUSTER};
    }

    public void setState(Map<String, String> state, String componentId) throws IOException {
        this.setState(state, -1, componentId);
    }

    /*
     * Exception decompiling
     */
    private byte[] serialize(Map<String, String> stateValues) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private StateMap deserialize(byte[] data, int recordVersion, String componentId) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setState(Map<String, String> stateValues, int version, String componentId) throws IOException {
        try {
            this.setState(stateValues, version, componentId, true);
        }
        catch (KeeperException.NoNodeException nne) {
            throw new IOException("Unable to create Node in ZooKeeper to set state for component with ID " + componentId, nne);
        }
    }

    private void setState(Map<String, String> stateValues, int version, String componentId, boolean allowNodeCreation) throws IOException, KeeperException.NoNodeException {
        this.verifyEnabled();
        try {
            String path = this.getComponentPath(componentId);
            byte[] data = this.serialize(stateValues);
            ZooKeeper keeper = this.getZooKeeper();
            this.validateDataSize(keeper.getClientConfig(), data, componentId, stateValues.size());
            try {
                keeper.setData(path, data, version);
            }
            catch (KeeperException.NoNodeException nne) {
                if (allowNodeCreation) {
                    this.createNode(path, data, componentId, stateValues, this.acl);
                    return;
                }
                throw nne;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to set cluster-wide state in ZooKeeper for component with ID " + componentId + " due to interruption", e);
        }
        catch (KeeperException.NoNodeException nne) {
            throw nne;
        }
        catch (KeeperException ke) {
            if (KeeperException.Code.SESSIONEXPIRED == ke.code()) {
                this.invalidateClient();
                this.setState(stateValues, version, componentId, allowNodeCreation);
                return;
            }
            if (KeeperException.Code.NODEEXISTS == ke.code()) {
                this.setState(stateValues, version, componentId, allowNodeCreation);
                return;
            }
            throw new IOException("Failed to set cluster-wide state in ZooKeeper for component with ID " + componentId, ke);
        }
        catch (StateTooLargeException stle) {
            throw stle;
        }
        catch (IOException ioe) {
            throw new IOException("Failed to set cluster-wide state in ZooKeeper for component with ID " + componentId, ioe);
        }
    }

    private void createNode(String path, byte[] data, String componentId, Map<String, String> stateValues, List<ACL> acls) throws IOException, KeeperException {
        try {
            ZooKeeper zooKeeper = this.getZooKeeper();
            zooKeeper.create(path, data, acls, CreateMode.PERSISTENT);
        }
        catch (InterruptedException ie) {
            throw new IOException("Failed to update cluster-wide state due to interruption", ie);
        }
        catch (KeeperException ke) {
            KeeperException.Code exceptionCode = ke.code();
            if (KeeperException.Code.NONODE == exceptionCode) {
                String parentPath = StringUtils.substringBeforeLast((String)path, (String)"/");
                this.createNode(parentPath, null, componentId, stateValues, ZooDefs.Ids.OPEN_ACL_UNSAFE);
                this.createNode(path, data, componentId, stateValues, acls);
                return;
            }
            if (KeeperException.Code.SESSIONEXPIRED == exceptionCode) {
                this.invalidateClient();
                this.createNode(path, data, componentId, stateValues, acls);
                return;
            }
            if (KeeperException.Code.NODEEXISTS == exceptionCode) {
                try {
                    this.getZooKeeper().setData(path, data, -1);
                    return;
                }
                catch (KeeperException ke1) {
                    if (ke1.code() == KeeperException.Code.NONODE) {
                        this.createNode(path, data, componentId, stateValues, acls);
                        return;
                    }
                }
                catch (InterruptedException ie) {
                    throw new IOException("Failed to update cluster-wide state due to interruption", ie);
                }
            }
            throw ke;
        }
    }

    public StateMap getState(String componentId) throws IOException {
        this.verifyEnabled();
        try {
            Stat stat = new Stat();
            String path = this.getComponentPath(componentId);
            byte[] data = this.getZooKeeper().getData(path, false, stat);
            StateMap stateMap = this.deserialize(data, stat.getVersion(), componentId);
            return stateMap;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Failed to obtain value from ZooKeeper for component with ID " + componentId + ", due to interruption", e);
        }
        catch (KeeperException ke) {
            KeeperException.Code exceptionCode = ke.code();
            if (KeeperException.Code.NONODE == exceptionCode) {
                return new StandardStateMap(null, -1L);
            }
            if (KeeperException.Code.SESSIONEXPIRED == exceptionCode) {
                this.invalidateClient();
                return this.getState(componentId);
            }
            throw new IOException("Failed to obtain value from ZooKeeper for component with ID " + componentId + " with exception code " + exceptionCode, ke);
        }
        catch (IOException ioe) {
            throw new IOException("Failed to obtain value from ZooKeeper for component with ID " + componentId, ioe);
        }
    }

    public boolean replace(StateMap oldValue, Map<String, String> newValue, String componentId) throws IOException {
        this.verifyEnabled();
        try {
            this.setState(newValue, (int)oldValue.getVersion(), componentId, false);
            return true;
        }
        catch (KeeperException.NoNodeException nne) {
            return false;
        }
        catch (IOException ioe) {
            KeeperException ke;
            Throwable cause = ioe.getCause();
            if (cause instanceof KeeperException && KeeperException.Code.BADVERSION == (ke = (KeeperException)cause).code()) {
                return false;
            }
            throw ioe;
        }
    }

    public void clear(String componentId) throws IOException {
        this.verifyEnabled();
        this.setState(Collections.emptyMap(), componentId);
    }

    private void validateDataSize(ZKClientConfig clientConfig, byte[] data, String componentId, int totalStateValues) throws StateTooLargeException {
        int maximumSize = clientConfig.getInt("jute.maxbuffer", 1048575);
        if (data != null && data.length > maximumSize) {
            String message = String.format("Component [%s] State Values [%d] Data Size [%d B] exceeds nifi.zookeeper.jute.maxbuffer size [%d B]", componentId, totalStateValues, data.length, maximumSize);
            throw new StateTooLargeException(message);
        }
    }

    private static final class NoOpWatcher
    implements Watcher {
        private NoOpWatcher() {
        }

        public void process(WatchedEvent watchedEvent) {
        }
    }
}

