/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import java.util.Arrays;
import java.util.Objects;
import javax.crypto.Cipher;
import org.apache.nifi.encrypt.CipherPropertyEncryptor;
import org.apache.nifi.encrypt.EncryptionException;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.CipherUtility;
import org.apache.nifi.security.util.crypto.NiFiLegacyCipherProvider;
import org.apache.nifi.security.util.crypto.PBECipherProvider;

class PasswordBasedCipherPropertyEncryptor
extends CipherPropertyEncryptor {
    private static final int ARRAY_START = 0;
    private static final boolean ENCRYPT = true;
    private static final boolean DECRYPT = false;
    private final PBECipherProvider cipherProvider;
    private final EncryptionMethod encryptionMethod;
    private final String password;
    private final int keyLength;
    private final int saltLength;
    private final String description;

    protected PasswordBasedCipherPropertyEncryptor(PBECipherProvider cipherProvider, EncryptionMethod encryptionMethod, String password) {
        this.cipherProvider = cipherProvider;
        this.encryptionMethod = encryptionMethod;
        this.password = password;
        this.keyLength = CipherUtility.parseKeyLengthFromAlgorithm((String)encryptionMethod.getAlgorithm());
        this.saltLength = CipherUtility.getSaltLengthForAlgorithm((String)encryptionMethod.getAlgorithm());
        this.description = String.format("%s Encryption Method [%s] Key Length [%d] Salt Length [%d]", this.getClass().getSimpleName(), encryptionMethod.getAlgorithm(), this.keyLength, this.saltLength);
    }

    @Override
    protected Cipher getDecryptionCipher(byte[] encryptedBinary) {
        byte[] salt = this.readSalt(encryptedBinary);
        return this.getCipher(salt, false);
    }

    @Override
    protected Cipher getEncryptionCipher(byte[] encodedParameters) {
        return this.getCipher(encodedParameters, true);
    }

    @Override
    protected byte[] getCipherBinary(byte[] encryptedBinary) {
        return Arrays.copyOfRange(encryptedBinary, this.saltLength, encryptedBinary.length);
    }

    @Override
    protected byte[] getEncodedParameters() {
        byte[] salt = this.cipherProvider instanceof NiFiLegacyCipherProvider ? ((NiFiLegacyCipherProvider)this.cipherProvider).generateSalt(this.encryptionMethod) : this.cipherProvider.generateSalt();
        return salt;
    }

    private Cipher getCipher(byte[] salt, boolean encrypt) {
        try {
            return this.cipherProvider.getCipher(this.encryptionMethod, this.password, salt, this.keyLength, encrypt);
        }
        catch (Exception e) {
            String message = String.format("Failed to get Cipher for Algorithm [%s]", this.encryptionMethod.getAlgorithm());
            throw new EncryptionException(message, e);
        }
    }

    private byte[] readSalt(byte[] binary) {
        byte[] salt = new byte[this.saltLength];
        System.arraycopy(binary, 0, salt, 0, this.saltLength);
        return salt;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (this == object) {
            equals = true;
        } else if (object instanceof PasswordBasedCipherPropertyEncryptor) {
            PasswordBasedCipherPropertyEncryptor encryptor = (PasswordBasedCipherPropertyEncryptor)object;
            equals = Objects.equals(this.encryptionMethod, encryptor.encryptionMethod) && Objects.equals(this.password, encryptor.password);
        }
        return equals;
    }

    public int hashCode() {
        return Objects.hash(this.encryptionMethod, this.password);
    }

    public String toString() {
        return this.description;
    }
}

