/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.encryption.configuration.kms;

import java.io.IOException;
import java.security.KeyStore;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.nifi.repository.encryption.configuration.EncryptedRepositoryType;
import org.apache.nifi.repository.encryption.configuration.kms.EncryptedConfigurationException;
import org.apache.nifi.repository.encryption.configuration.kms.EncryptedRepositoryProperty;
import org.apache.nifi.repository.encryption.configuration.kms.EncryptionKeyProvider;
import org.apache.nifi.repository.encryption.configuration.kms.RepositoryKeyProviderFactory;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.security.kms.KeyProviderFactory;
import org.apache.nifi.security.kms.configuration.FileBasedKeyProviderConfiguration;
import org.apache.nifi.security.kms.configuration.KeyProviderConfiguration;
import org.apache.nifi.security.kms.configuration.KeyStoreKeyProviderConfiguration;
import org.apache.nifi.security.kms.configuration.StaticKeyProviderConfiguration;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.NiFiBootstrapUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

public class StandardRepositoryKeyProviderFactory
implements RepositoryKeyProviderFactory {
    private static final String ROOT_KEY_ALGORITHM = "AES";

    @Override
    public KeyProvider getKeyProvider(EncryptedRepositoryType encryptedRepositoryType, NiFiProperties niFiProperties) {
        Objects.requireNonNull(encryptedRepositoryType, "Encrypted Repository Type required");
        Objects.requireNonNull(niFiProperties, "NiFi Properties required");
        EncryptedRepositoryProperty encryptedRepositoryProperty = EncryptedRepositoryProperty.fromEncryptedRepositoryType(encryptedRepositoryType);
        EncryptionKeyProvider encryptionKeyProvider = this.getEncryptionKeyProvider(encryptedRepositoryProperty, niFiProperties);
        KeyProviderConfiguration<?> keyProviderConfiguration = this.getKeyProviderConfiguration(encryptedRepositoryProperty, encryptionKeyProvider, niFiProperties);
        return KeyProviderFactory.getKeyProvider(keyProviderConfiguration);
    }

    private EncryptionKeyProvider getEncryptionKeyProvider(EncryptedRepositoryProperty encryptedRepositoryProperty, NiFiProperties niFiProperties) {
        EncryptionKeyProvider encryptionKeyProvider;
        String sharedKeyProvider = niFiProperties.getProperty("nifi.repository.encryption.key.provider");
        if (StringUtils.isBlank((String)sharedKeyProvider)) {
            String classProperty = encryptedRepositoryProperty.getImplementationClass();
            String implementationClass = niFiProperties.getProperty(classProperty);
            if (StringUtils.isBlank((String)implementationClass)) {
                String message = String.format("Key Provider Property [%s] not configured", classProperty);
                throw new EncryptedConfigurationException(message);
            }
            encryptionKeyProvider = EncryptionKeyProvider.fromImplementationClass(implementationClass);
        } else {
            try {
                encryptionKeyProvider = EncryptionKeyProvider.valueOf(sharedKeyProvider);
            }
            catch (IllegalArgumentException e) {
                EncryptedRepositoryType encryptedRepositoryType = encryptedRepositoryProperty.getEncryptedRepositoryType();
                String message = String.format("Key Provider [%s] not supported for Repository Type [%s] ", new Object[]{sharedKeyProvider, encryptedRepositoryType});
                throw new EncryptedConfigurationException(message);
            }
        }
        if (encryptionKeyProvider == null) {
            EncryptedRepositoryType encryptedRepositoryType = encryptedRepositoryProperty.getEncryptedRepositoryType();
            String message = String.format("Key Provider [%s] not found for Repository Type [%s] ", new Object[]{sharedKeyProvider, encryptedRepositoryType});
            throw new EncryptedConfigurationException(message);
        }
        return encryptionKeyProvider;
    }

    private KeyProviderConfiguration<?> getKeyProviderConfiguration(EncryptedRepositoryProperty encryptedRepositoryProperty, EncryptionKeyProvider encryptionKeyProvider, NiFiProperties niFiProperties) {
        if (EncryptionKeyProvider.NIFI_PROPERTIES == encryptionKeyProvider) {
            Map encryptionKeys = niFiProperties.getRepositoryEncryptionKeys(encryptedRepositoryProperty.getPropertyType());
            return new StaticKeyProviderConfiguration(encryptionKeys);
        }
        if (EncryptionKeyProvider.FILE_PROPERTIES == encryptionKeyProvider) {
            SecretKey rootKey = StandardRepositoryKeyProviderFactory.getRootKey();
            String location = niFiProperties.getProperty(encryptedRepositoryProperty.getLocation());
            return new FileBasedKeyProviderConfiguration(location, rootKey);
        }
        if (EncryptionKeyProvider.KEYSTORE == encryptionKeyProvider) {
            String providerPassword = this.getProviderPassword(encryptedRepositoryProperty, niFiProperties);
            if (StringUtils.isBlank((String)providerPassword)) {
                throw new EncryptedConfigurationException("Key Provider Password not configured");
            }
            char[] keyStorePassword = providerPassword.toCharArray();
            String location = this.getProviderLocation(encryptedRepositoryProperty, niFiProperties);
            KeystoreType keystoreType = KeyStoreUtils.getKeystoreTypeFromExtension((String)location);
            try {
                KeyStore keyStore = KeyStoreUtils.loadSecretKeyStore((String)location, (char[])keyStorePassword, (String)keystoreType.getType());
                return new KeyStoreKeyProviderConfiguration(keyStore, keyStorePassword);
            }
            catch (TlsException e) {
                throw new EncryptedConfigurationException("Key Store Provider loading failed", e);
            }
        }
        throw new UnsupportedOperationException(String.format("Key Provider [%s] not supported", new Object[]{encryptionKeyProvider}));
    }

    private String getProviderLocation(EncryptedRepositoryProperty encryptedRepositoryProperty, NiFiProperties niFiProperties) {
        String providerLocation = niFiProperties.getProperty("nifi.repository.encryption.key.provider.keystore.location");
        return niFiProperties.getProperty(encryptedRepositoryProperty.getLocation(), providerLocation);
    }

    private String getProviderPassword(EncryptedRepositoryProperty encryptedRepositoryProperty, NiFiProperties niFiProperties) {
        String providerPassword = niFiProperties.getProperty("nifi.repository.encryption.key.provider.keystore.password");
        return niFiProperties.getProperty(encryptedRepositoryProperty.getPassword(), providerPassword);
    }

    private static SecretKey getRootKey() {
        try {
            String rootKeyHex = NiFiBootstrapUtils.extractKeyFromBootstrapFile();
            return new SecretKeySpec(Hex.decode((String)rootKeyHex), ROOT_KEY_ALGORITHM);
        }
        catch (IOException | DecoderException e) {
            throw new EncryptedConfigurationException("Read Root Key from Bootstrap Failed", e);
        }
    }
}

