/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.tls.service.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.input.BoundedReader;
import org.apache.nifi.security.util.CertificateUtils;
import org.apache.nifi.toolkit.tls.service.dto.TlsCertificateAuthorityRequest;
import org.apache.nifi.toolkit.tls.service.dto.TlsCertificateAuthorityResponse;
import org.apache.nifi.toolkit.tls.util.TlsHelper;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsCertificateAuthorityServiceHandler
extends AbstractHandler {
    public static final String CSR_FIELD_MUST_BE_SET = "csr field must be set";
    public static final String HMAC_FIELD_MUST_BE_SET = "hmac field must be set";
    public static final String FORBIDDEN = "forbidden";
    private final Logger logger = LoggerFactory.getLogger(TlsCertificateAuthorityServiceHandler.class);
    private final String signingAlgorithm;
    private final int days;
    private final String token;
    private final X509Certificate caCert;
    private final KeyPair keyPair;
    private final ObjectMapper objectMapper;

    public TlsCertificateAuthorityServiceHandler(String signingAlgorithm, int days, String token, X509Certificate caCert, KeyPair keyPair, ObjectMapper objectMapper) {
        this.signingAlgorithm = signingAlgorithm;
        this.days = days;
        this.token = token;
        this.caCert = caCert;
        this.keyPair = keyPair;
        this.objectMapper = objectMapper;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            TlsCertificateAuthorityRequest tlsCertificateAuthorityRequest = (TlsCertificateAuthorityRequest)this.objectMapper.readValue((Reader)new BoundedReader((Reader)request.getReader(), 0x100000), TlsCertificateAuthorityRequest.class);
            if (!tlsCertificateAuthorityRequest.hasHmac()) {
                this.writeResponse(this.objectMapper, request, response, new TlsCertificateAuthorityResponse(HMAC_FIELD_MUST_BE_SET), 400);
                return;
            }
            if (!tlsCertificateAuthorityRequest.hasCsr()) {
                this.writeResponse(this.objectMapper, request, response, new TlsCertificateAuthorityResponse(CSR_FIELD_MUST_BE_SET), 400);
                return;
            }
            JcaPKCS10CertificationRequest jcaPKCS10CertificationRequest = TlsHelper.parseCsr(tlsCertificateAuthorityRequest.getCsr());
            byte[] expectedHmac = TlsHelper.calculateHMac(this.token, jcaPKCS10CertificationRequest.getPublicKey());
            if (MessageDigest.isEqual(expectedHmac, tlsCertificateAuthorityRequest.getHmac())) {
                String dn = jcaPKCS10CertificationRequest.getSubject().toString();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Received CSR with DN " + dn);
                }
                X509Certificate x509Certificate = CertificateUtils.generateIssuedCertificate((String)dn, (PublicKey)jcaPKCS10CertificationRequest.getPublicKey(), (Extensions)CertificateUtils.getExtensionsFromCSR((JcaPKCS10CertificationRequest)jcaPKCS10CertificationRequest), (X509Certificate)this.caCert, (KeyPair)this.keyPair, (String)this.signingAlgorithm, (int)this.days);
                this.writeResponse(this.objectMapper, request, response, new TlsCertificateAuthorityResponse(TlsHelper.calculateHMac(this.token, this.caCert.getPublicKey()), TlsHelper.pemEncodeJcaObject(x509Certificate)), 200);
                return;
            }
            this.writeResponse(this.objectMapper, request, response, new TlsCertificateAuthorityResponse(FORBIDDEN), 403);
            return;
        }
        catch (Exception e) {
            throw new ServletException("Server error");
        }
        finally {
            baseRequest.setHandled(true);
        }
    }

    private void writeResponse(ObjectMapper objectMapper, HttpServletRequest request, HttpServletResponse response, TlsCertificateAuthorityResponse tlsCertificateAuthorityResponse, int responseCode) throws IOException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Returning code:" + responseCode + " payload " + objectMapper.writeValueAsString((Object)tlsCertificateAuthorityResponse) + " to " + request.getRemoteHost());
        }
        if (responseCode == 200) {
            objectMapper.writeValue((Writer)response.getWriter(), (Object)tlsCertificateAuthorityResponse);
            response.setStatus(responseCode);
        } else {
            response.setStatus(responseCode);
            response.setContentType("application/json");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            objectMapper.writeValue((Writer)response.getWriter(), (Object)tlsCertificateAuthorityResponse);
        }
    }
}

