/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.util;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jline.builtins.Completers;
import org.jline.builtins.Styles;
import org.jline.reader.Candidate;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.utils.StyleResolver;

public class StandardFileNameCompleter
extends Completers.FileNameCompleter {
    private static final String STANDARD_LS_COLORS = "di=1;91:ex=1;92:ln=1;96:fi=";
    private static final String HOME_DIRECTORY_ALIAS = "~";
    private static final String EMPTY = "";
    private static final StyleResolver STYLE_RESOLVER = Styles.style((String)"di=1;91:ex=1;92:ln=1;96:fi=");

    public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
        assert (commandLine != null);
        assert (candidates != null);
        String buffer = commandLine.word().substring(0, commandLine.wordCursor());
        String sep = this.getSeparator(reader.isSet(LineReader.Option.USE_FORWARD_SLASH));
        int lastSep = buffer.lastIndexOf(sep);
        try {
            Path current;
            String curBuf;
            if (lastSep >= 0) {
                curBuf = buffer.substring(0, lastSep + 1);
                current = curBuf.startsWith(HOME_DIRECTORY_ALIAS) ? (curBuf.startsWith(HOME_DIRECTORY_ALIAS + sep) ? this.getUserHome().resolve(curBuf.substring(2)) : this.getUserHome().getParent().resolve(curBuf.substring(1))) : this.getUserDir().resolve(curBuf);
            } else {
                curBuf = EMPTY;
                current = this.getUserDir();
            }
            try (DirectoryStream<Path> directory = Files.newDirectoryStream(current, arg_0 -> ((StandardFileNameCompleter)this).accept(arg_0));){
                directory.forEach(path -> {
                    String value = curBuf + path.getFileName().toString();
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        candidates.add(new Candidate(value + (reader.isSet(LineReader.Option.AUTO_PARAM_SLASH) ? sep : EMPTY), this.getDisplay(reader.getTerminal(), (Path)path, STYLE_RESOLVER, sep), null, null, reader.isSet(LineReader.Option.AUTO_REMOVE_SLASH) ? sep : null, null, false));
                    } else {
                        candidates.add(new Candidate(value, this.getDisplay(reader.getTerminal(), (Path)path, STYLE_RESOLVER, sep), null, null, null, null, true));
                    }
                });
            }
            catch (IOException iOException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

