/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class RegisteredFlowSnapshotMetadataResult
extends AbstractWritableResult<List<VersionedFlowSnapshotMetadata>> {
    private final List<VersionedFlowSnapshotMetadata> versions;

    public RegisteredFlowSnapshotMetadataResult(ResultType resultType, List<VersionedFlowSnapshotMetadata> versions) {
        super(resultType);
        this.versions = versions;
        Validate.notNull(this.versions);
        this.versions.sort(Comparator.comparing(VersionedFlowSnapshotMetadata::getVersion));
    }

    @Override
    public List<VersionedFlowSnapshotMetadata> getResult() {
        return this.versions;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        if (this.versions == null || this.versions.isEmpty()) {
            return;
        }
        String datePattern = "%1$ta, %<tb %<td %<tY %<tR %<tZ";
        int dateLength = String.format("%1$ta, %<tb %<td %<tY %<tR %<tZ", new Date()).length();
        Table table = new Table.Builder().column("Ver", 3, 3, false).column("Date", dateLength, dateLength, false).column("Author", 20, 200, true).column("Message", 8, 40, true).build();
        this.versions.forEach(vfs -> table.addRow(String.valueOf(vfs.getVersion()), String.format("%1$ta, %<tb %<td %<tY %<tR %<tZ", new Date(vfs.getTimestamp())), "TODO", "TODO"));
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

