/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.authorization.AccessPolicy;
import org.apache.nifi.registry.authorization.Tenant;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;

public class AccessPolicyResult
extends AbstractWritableResult<AccessPolicy> {
    private final AccessPolicy accessPolicy;

    public AccessPolicyResult(ResultType resultType, AccessPolicy accessPolicy) {
        super(resultType);
        this.accessPolicy = accessPolicy;
        Validate.notNull((Object)accessPolicy);
    }

    @Override
    public AccessPolicy getResult() {
        return this.accessPolicy;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        output.printf("Resource: %s\nAction  : %s\nUsers   : %s\nGroups  : %s\n", this.accessPolicy.getResource(), this.accessPolicy.getAction(), this.joinTenantIdentities(this.accessPolicy.getUsers()), this.joinTenantIdentities(this.accessPolicy.getUserGroups()));
    }

    private String joinTenantIdentities(Set<Tenant> tenants) {
        return tenants.stream().map(tenant -> tenant.getIdentity()).collect(Collectors.joining(", "));
    }
}

