/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;

public class ReportingTaskResult
extends AbstractWritableResult<ReportingTaskEntity> {
    private final ReportingTaskEntity reportingTaskEntity;

    public ReportingTaskResult(ResultType resultType, ReportingTaskEntity reportingTaskEntity) {
        super(resultType);
        this.reportingTaskEntity = reportingTaskEntity;
        Validate.notNull((Object)reportingTaskEntity);
    }

    @Override
    public ReportingTaskEntity getResult() {
        return this.reportingTaskEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        ReportingTaskDTO reportingTaskDTO = this.reportingTaskEntity.getComponent();
        BundleDTO bundle = reportingTaskDTO.getBundle();
        output.printf("Name  : %s\nID    : %s\nType  : %s\nBundle: %s - %s %s\nState : %s\n", reportingTaskDTO.getName(), reportingTaskDTO.getId(), reportingTaskDTO.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion(), reportingTaskDTO.getState());
    }
}

