/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.VersionsClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.entity.StartVersionControlRequestEntity;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;
import org.apache.nifi.web.api.entity.VersionedFlowUpdateRequestEntity;

public class JerseyVersionsClient
extends AbstractJerseyClient
implements VersionsClient {
    private final WebTarget versionsTarget;

    public JerseyVersionsClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyVersionsClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.versionsTarget = baseTarget.path("/versions");
    }

    @Override
    public VersionControlInformationEntity getVersionControlInfo(String processGroupId) throws IOException, NiFiClientException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        return this.executeAction("Error getting version control info", () -> {
            WebTarget target = this.versionsTarget.path("process-groups/{id}").resolveTemplate("id", (Object)processGroupId);
            return (VersionControlInformationEntity)this.getRequestBuilder(target).get(VersionControlInformationEntity.class);
        });
    }

    @Override
    public VersionedFlowUpdateRequestEntity updateVersionControlInfo(String processGroupId, VersionControlInformationEntity entity) throws IOException, NiFiClientException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Version control information entity cannot be null");
        }
        return this.executeAction("Error updating version control information", () -> {
            WebTarget target = this.versionsTarget.path("update-requests/process-groups/{id}").resolveTemplate("id", (Object)processGroupId);
            return (VersionedFlowUpdateRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), VersionedFlowUpdateRequestEntity.class);
        });
    }

    @Override
    public VersionedFlowUpdateRequestEntity getUpdateRequest(String updateRequestId) throws IOException, NiFiClientException {
        if (StringUtils.isBlank((CharSequence)updateRequestId)) {
            throw new IllegalArgumentException("Update request id cannot be null or blank");
        }
        return this.executeAction("Error getting update request", () -> {
            WebTarget target = this.versionsTarget.path("update-requests/{id}").resolveTemplate("id", (Object)updateRequestId);
            return (VersionedFlowUpdateRequestEntity)this.getRequestBuilder(target).get(VersionedFlowUpdateRequestEntity.class);
        });
    }

    @Override
    public VersionedFlowUpdateRequestEntity deleteUpdateRequest(String updateRequestId) throws IOException, NiFiClientException {
        if (StringUtils.isBlank((CharSequence)updateRequestId)) {
            throw new IllegalArgumentException("Update request id cannot be null or blank");
        }
        return this.executeAction("Error deleting update request", () -> {
            WebTarget target = this.versionsTarget.path("update-requests/{id}").resolveTemplate("id", (Object)updateRequestId);
            return (VersionedFlowUpdateRequestEntity)this.getRequestBuilder(target).delete(VersionedFlowUpdateRequestEntity.class);
        });
    }

    @Override
    public VersionControlInformationEntity startVersionControl(String processGroupId, StartVersionControlRequestEntity startVersionControlRequestEntity) throws IOException, NiFiClientException {
        if (startVersionControlRequestEntity == null) {
            throw new IllegalArgumentException("Request Entity cannot be null");
        }
        return this.executeAction("Error starting version control", () -> {
            WebTarget target = this.versionsTarget.path("process-groups/{id}").resolveTemplate("id", (Object)processGroupId);
            return (VersionControlInformationEntity)this.getRequestBuilder(target).post(Entity.entity((Object)startVersionControlRequestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), VersionControlInformationEntity.class);
        });
    }

    @Override
    public VersionedFlowUpdateRequestEntity initiateRevertFlowVersion(String processGroupId, VersionControlInformationEntity versionControlInformation) throws IOException, NiFiClientException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (versionControlInformation == null) {
            throw new IllegalArgumentException("Version control information entity cannot be null");
        }
        return this.executeAction("Error reverting flow version", () -> {
            WebTarget target = this.versionsTarget.path("revert-requests/process-groups/{id}").resolveTemplate("id", (Object)processGroupId);
            return (VersionedFlowUpdateRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)versionControlInformation, (MediaType)MediaType.APPLICATION_JSON_TYPE), VersionedFlowUpdateRequestEntity.class);
        });
    }

    @Override
    public VersionedFlowUpdateRequestEntity getRevertFlowVersionRequest(String requestId) throws IOException, NiFiClientException {
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Update request id cannot be null or blank");
        }
        return this.executeAction("Error getting revert request", () -> {
            WebTarget target = this.versionsTarget.path("revert-requests/{id}").resolveTemplate("id", (Object)requestId);
            return (VersionedFlowUpdateRequestEntity)this.getRequestBuilder(target).get(VersionedFlowUpdateRequestEntity.class);
        });
    }

    @Override
    public VersionedFlowUpdateRequestEntity deleteRevertFlowVersionRequest(String requestId) throws IOException, NiFiClientException {
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Update request id cannot be null or blank");
        }
        return this.executeAction("Error deleting revert request", () -> {
            WebTarget target = this.versionsTarget.path("revert-requests/{id}").resolveTemplate("id", (Object)requestId);
            return (VersionedFlowUpdateRequestEntity)this.getRequestBuilder(target).delete(VersionedFlowUpdateRequestEntity.class);
        });
    }
}

