/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.RequestConfig;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.CopySnippetRequestEntity;
import org.apache.nifi.web.api.entity.FlowEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupImportEntity;
import org.apache.nifi.web.api.entity.ProcessGroupReplaceRequestEntity;
import org.apache.nifi.web.api.entity.TemplateEntity;
import org.apache.nifi.web.api.entity.VariableRegistryEntity;
import org.apache.nifi.web.api.entity.VariableRegistryUpdateRequestEntity;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class JerseyProcessGroupClient
extends AbstractJerseyClient
implements ProcessGroupClient {
    private final WebTarget processGroupsTarget;

    public JerseyProcessGroupClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyProcessGroupClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.processGroupsTarget = baseTarget.path("/process-groups");
    }

    @Override
    public ProcessGroupEntity createProcessGroup(String parentGroupdId, ProcessGroupEntity entity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentGroupdId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Process group entity cannot be null");
        }
        return this.executeAction("Error creating process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/process-groups").resolveTemplate("id", (Object)parentGroupdId);
            return (ProcessGroupEntity)this.getRequestBuilder(target).post(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessGroupEntity.class);
        });
    }

    @Override
    public ProcessGroupEntity getProcessGroup(String processGroupId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        return this.executeAction("Error getting process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}").resolveTemplate("id", (Object)processGroupId);
            return (ProcessGroupEntity)this.getRequestBuilder(target).get(ProcessGroupEntity.class);
        });
    }

    @Override
    public ProcessGroupEntity updateProcessGroup(ProcessGroupEntity entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Process group entity cannot be null");
        }
        return this.executeAction("Error updating process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}").resolveTemplate("id", (Object)entity.getId());
            return (ProcessGroupEntity)this.getRequestBuilder(target).put(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessGroupEntity.class);
        });
    }

    @Override
    public VariableRegistryEntity getVariables(String processGroupId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        return this.executeAction("Error getting variables for process group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/variable-registry").resolveTemplate("id", (Object)processGroupId);
            return (VariableRegistryEntity)this.getRequestBuilder(target).get(VariableRegistryEntity.class);
        });
    }

    @Override
    public VariableRegistryUpdateRequestEntity updateVariableRegistry(String processGroupId, VariableRegistryEntity variableRegistryEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (variableRegistryEntity == null) {
            throw new IllegalArgumentException("Variable registry entity cannot be null");
        }
        return this.executeAction("Error getting variable registry update request", () -> {
            WebTarget target = this.processGroupsTarget.path("{processGroupId}/variable-registry/update-requests").resolveTemplate("processGroupId", (Object)processGroupId);
            return (VariableRegistryUpdateRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)variableRegistryEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), VariableRegistryUpdateRequestEntity.class);
        });
    }

    @Override
    public VariableRegistryUpdateRequestEntity getVariableRegistryUpdateRequest(String processGroupId, String requestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Request id cannot be null or blank");
        }
        return this.executeAction("Error getting variable registry update request", () -> {
            WebTarget target = this.processGroupsTarget.path("{processGroupId}/variable-registry/update-requests/{updateId}").resolveTemplate("processGroupId", (Object)processGroupId).resolveTemplate("updateId", (Object)requestId);
            return (VariableRegistryUpdateRequestEntity)this.getRequestBuilder(target).get(VariableRegistryUpdateRequestEntity.class);
        });
    }

    @Override
    public VariableRegistryUpdateRequestEntity deleteVariableRegistryUpdateRequest(String processGroupId, String requestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Request id cannot be null or blank");
        }
        return this.executeAction("Error getting variable registry update request", () -> {
            WebTarget target = this.processGroupsTarget.path("{processGroupId}/variable-registry/update-requests/{updateId}").resolveTemplate("processGroupId", (Object)processGroupId).resolveTemplate("updateId", (Object)requestId);
            return (VariableRegistryUpdateRequestEntity)this.getRequestBuilder(target).delete(VariableRegistryUpdateRequestEntity.class);
        });
    }

    @Override
    public ControllerServiceEntity createControllerService(String processGroupId, ControllerServiceEntity controllerService) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (controllerService == null) {
            throw new IllegalArgumentException("Controller service entity cannot be null");
        }
        return this.executeAction("Error creating controller service", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/controller-services").resolveTemplate("id", (Object)processGroupId);
            return (ControllerServiceEntity)this.getRequestBuilder(target).post(Entity.entity((Object)controllerService, (String)"application/json"), ControllerServiceEntity.class);
        });
    }

    @Override
    public TemplateEntity uploadTemplate(String processGroupId, TemplateDTO templateDTO) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (templateDTO == null) {
            throw new IllegalArgumentException("The template dto cannot be null");
        }
        return this.executeAction("Error uploading template file", () -> {
            WebTarget target = (WebTarget)this.processGroupsTarget.path("{id}/templates/upload").resolveTemplate("id", (Object)processGroupId).register(MultiPartFeature.class);
            FormDataMultiPart form = new FormDataMultiPart();
            form.field("template", (Object)templateDTO, MediaType.TEXT_XML_TYPE);
            return (TemplateEntity)this.getRequestBuilder(target).post(Entity.entity((Object)form, (String)"multipart/form-data"), TemplateEntity.class);
        });
    }

    @Override
    public ProcessGroupReplaceRequestEntity replaceProcessGroup(String processGroupId, ProcessGroupImportEntity importEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (importEntity == null || importEntity.getVersionedFlowSnapshot() == null) {
            throw new IllegalArgumentException("ProcessGroupImportEntity cannot be null and must have a non-null VersionedFlowSnapshot");
        }
        return this.executeAction("Error creating process group replacement request", () -> {
            WebTarget target = this.processGroupsTarget.path("{processGroupId}/replace-requests").resolveTemplate("processGroupId", (Object)processGroupId);
            return (ProcessGroupReplaceRequestEntity)this.getRequestBuilder(target).post(Entity.entity((Object)importEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessGroupReplaceRequestEntity.class);
        });
    }

    @Override
    public ProcessGroupReplaceRequestEntity getProcessGroupReplaceRequest(String processGroupId, String requestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Request id cannot be null or blank");
        }
        return this.executeAction("Error getting process group replacement request", () -> {
            WebTarget target = this.processGroupsTarget.path("replace-requests/{requestId}").resolveTemplate("requestId", (Object)requestId);
            return (ProcessGroupReplaceRequestEntity)this.getRequestBuilder(target).get(ProcessGroupReplaceRequestEntity.class);
        });
    }

    @Override
    public ProcessGroupReplaceRequestEntity deleteProcessGroupReplaceRequest(String processGroupId, String requestId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (StringUtils.isBlank((CharSequence)requestId)) {
            throw new IllegalArgumentException("Request id cannot be null or blank");
        }
        return this.executeAction("Error deleting process group replacement request", () -> {
            WebTarget target = this.processGroupsTarget.path("replace-requests/{requestId}").resolveTemplate("requestId", (Object)requestId);
            return (ProcessGroupReplaceRequestEntity)this.getRequestBuilder(target).delete(ProcessGroupReplaceRequestEntity.class);
        });
    }

    @Override
    public FlowEntity copySnippet(String processGroupId, CopySnippetRequestEntity copySnippetRequestEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processGroupId)) {
            throw new IllegalArgumentException("Process group id cannot be null or blank");
        }
        if (copySnippetRequestEntity == null) {
            throw new IllegalArgumentException("Snippet Request Entity cannot be null");
        }
        return this.executeAction("Error copying snippet to Process Group", () -> {
            WebTarget target = this.processGroupsTarget.path("{id}/snippet-instance").resolveTemplate("id", (Object)processGroupId);
            return (FlowEntity)this.getRequestBuilder(target).post(Entity.entity((Object)copySnippetRequestEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), FlowEntity.class);
        });
    }
}

