/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.nifi.toolkit.cli.api.Command;
import org.apache.nifi.toolkit.cli.api.CommandGroup;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.session.SessionVariable;
import org.apache.nifi.toolkit.cli.impl.util.StandardFileNameCompleter;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.utils.AttributedString;

public class CLICompleter
implements Completer {
    private static final Set<String> FILE_COMPLETION_ARGS;
    private static final Set<String> FILE_COMPLETION_VARS;
    private final Map<String, List<String>> topLevelCommandMap;
    private final Map<String, List<String>> commandOptionsMap;
    private final Completer fileNameCompleter = new StandardFileNameCompleter();

    public CLICompleter(Collection<Command> topLevelCommands, Collection<CommandGroup> commandGroups) {
        TreeMap topLevel = new TreeMap();
        for (Command topLevelCommand : topLevelCommands) {
            topLevel.put(topLevelCommand.getName(), Collections.emptyList());
        }
        for (CommandGroup commandGroup : commandGroups) {
            List subCommands = commandGroup.getCommands().stream().map(cmd -> cmd.getName()).collect(Collectors.toList());
            topLevel.put(commandGroup.getName(), subCommands);
        }
        this.topLevelCommandMap = Collections.unmodifiableMap(topLevel);
        TreeMap commandOptions = new TreeMap();
        for (CommandGroup commandGroup : commandGroups) {
            for (Command command : commandGroup.getCommands()) {
                List options = command.getOptions().getOptions().stream().map(o -> "-" + o.getOpt()).collect(Collectors.toList());
                commandOptions.put(command.getName(), options);
            }
        }
        this.commandOptionsMap = Collections.unmodifiableMap(commandOptions);
    }

    public Collection<String> getTopLevelCommands() {
        return this.topLevelCommandMap.keySet();
    }

    public Collection<String> getSubCommands(String topLevelCommand) {
        return this.topLevelCommandMap.containsKey(topLevelCommand) ? (Collection)this.topLevelCommandMap.get(topLevelCommand) : Collections.emptyList();
    }

    public Collection<String> getOptions(String secondLevelCommand) {
        return this.commandOptionsMap.containsKey(secondLevelCommand) ? (Collection)this.commandOptionsMap.get(secondLevelCommand) : Collections.emptyList();
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        Objects.requireNonNull(line);
        Objects.requireNonNull(candidates);
        if (line.wordIndex() < 0) {
            return;
        }
        if (line.wordIndex() == 0) {
            this.addCandidates(this.topLevelCommandMap.keySet(), candidates);
            return;
        }
        if (line.wordIndex() == 1) {
            List<String> subCommands;
            String firstLevel = (String)line.words().get(0);
            if (this.topLevelCommandMap.containsKey(firstLevel) && (subCommands = this.topLevelCommandMap.get(firstLevel)) != null) {
                this.addCandidates(subCommands, candidates);
            }
            return;
        }
        if (line.wordIndex() >= 2) {
            String firstLevel = (String)line.words().get(0);
            String secondLevel = (String)line.words().get(1);
            if (!this.topLevelCommandMap.containsKey(firstLevel)) {
                return;
            }
            List<String> subCommands = this.topLevelCommandMap.get(firstLevel);
            if (!subCommands.contains(secondLevel)) {
                return;
            }
            if (!this.commandOptionsMap.containsKey(secondLevel)) {
                return;
            }
            if ("session".equals(firstLevel)) {
                if (line.wordIndex() == 2) {
                    this.addCandidates(SessionVariable.getAllVariableNames(), candidates);
                } else if (line.wordIndex() == 3) {
                    String currWord = line.word();
                    String prevWord = (String)line.words().get(line.wordIndex() - 1);
                    if (FILE_COMPLETION_VARS.contains(prevWord)) {
                        this.fileNameCompleter.complete(reader, (ParsedLine)new ArgumentCompleter.ArgumentLine(currWord, currWord.length()), candidates);
                    }
                }
            } else {
                String currWord = line.word();
                String prevWord = (String)line.words().get(line.wordIndex() - 1);
                if (FILE_COMPLETION_ARGS.contains(prevWord)) {
                    this.fileNameCompleter.complete(reader, (ParsedLine)new ArgumentCompleter.ArgumentLine(currWord, currWord.length()), candidates);
                } else {
                    List<String> options = this.commandOptionsMap.get(secondLevel);
                    if (options != null) {
                        this.addCandidates(options, candidates);
                    }
                }
            }
        }
    }

    private void addCandidates(Collection<String> values, List<Candidate> candidates) {
        for (String value : values) {
            candidates.add(new Candidate(AttributedString.stripAnsi((String)value), value, null, null, null, null, true));
        }
    }

    static {
        HashSet<String> args = new HashSet<String>();
        for (CommandOption option : CommandOption.values()) {
            if (!option.isFile()) continue;
            args.add("-" + option.getShortName());
        }
        FILE_COMPLETION_ARGS = Collections.unmodifiableSet(args);
        HashSet<String> vars = new HashSet<String>();
        vars.add(SessionVariable.NIFI_CLIENT_PROPS.getVariableName());
        vars.add(SessionVariable.NIFI_REGISTRY_CLIENT_PROPS.getVariableName());
        FILE_COMPLETION_VARS = Collections.unmodifiableSet(vars);
    }
}

