/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.SqlExecutionContext;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuestDbWritingTemplate<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestDbWritingTemplate.class);
    private final String tableName;

    protected QuestDbWritingTemplate(String tableName) {
        this.tableName = tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(CairoEngine engine, SqlExecutionContext context, Collection<T> entries) {
        if (entries.isEmpty()) {
            return;
        }
        try (TableWriter tableWriter = engine.getWriter(context.getCairoSecurityContext(), (CharSequence)this.tableName, (CharSequence)"adding rows");){
            this.addRows(tableWriter, entries);
            tableWriter.commit();
        }
        catch (Exception e) {
            LOGGER.error("Error happened during writing into table " + this.tableName, (Throwable)e);
        }
        finally {
            engine.releaseInactive();
        }
    }

    protected abstract void addRows(TableWriter var1, Collection<T> var2);
}

