/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.tasks;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.io.Closeable;

public class TableWriterTask
implements Closeable {
    public static final int CMD_SLAVE_SYNC = 1;
    public static final int CMD_ALTER_TABLE = 2;
    public static final int CMD_UPDATE_TABLE = 3;
    public static final int TSK_BEGIN = 64;
    public static final int TSK_COMPLETE = 65;
    private final long data;
    private final long dataSize;
    private AsyncWriterCommand cmd;
    private int type;
    private long tableId;
    private String tableName;
    private long appendPtr;
    private long appendLim;
    private long instance;
    private long sequence;
    private long ip;

    public TableWriterTask(long data, long dataSize) {
        this.data = data;
        this.dataSize = dataSize;
        this.reset();
    }

    private void reset() {
        this.appendPtr = this.data;
        this.appendLim = this.data + this.dataSize;
    }

    @Override
    public void close() {
        this.appendPtr = 0L;
        this.appendLim = 0L;
    }

    public void fromSlaveSyncRequest(long tableId, String tableName, long txMem, long txMemSize, long metaMem, long metaMemSize, long slaveIP, long sequence) {
        this.reset();
        this.checkCapacity(txMemSize + metaMemSize + 16L);
        Unsafe.getUnsafe().putLong(this.data, txMemSize);
        Vect.memcpy(this.data + 8L, txMem, txMemSize);
        Unsafe.getUnsafe().putLong(this.data + txMemSize + 8L, metaMemSize);
        Vect.memcpy(this.data + txMemSize + 16L, metaMem, metaMemSize);
        this.type = 1;
        this.tableId = tableId;
        this.tableName = tableName;
        this.ip = slaveIP;
        this.sequence = sequence;
    }

    public void of(int type, long tableId, String tableName) {
        this.tableId = tableId;
        this.tableName = tableName;
        this.type = type;
        this.appendPtr = this.data;
        this.ip = 0L;
    }

    public AsyncWriterCommand getAsyncWriterCommand() {
        return this.cmd;
    }

    public void setAsyncWriterCommand(AsyncWriterCommand cmd) {
        this.cmd = cmd;
    }

    public long getData() {
        return this.data;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getInstance() {
        return this.instance;
    }

    public void setInstance(long instance) {
        this.instance = instance;
    }

    public long getIp() {
        return this.ip;
    }

    public void setIp(long ip) {
        this.ip = ip;
    }

    public long getSequence() {
        return this.sequence;
    }

    public long getTableId() {
        return this.tableId;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getType() {
        return this.type;
    }

    public void putStr(CharSequence value) {
        int len = value.length();
        int byteLen = len * 2 + 4;
        this.checkCapacity(byteLen);
        Unsafe.getUnsafe().putInt(this.appendPtr, len);
        Chars.copyStrChars(value, 0, len, this.appendPtr + 4L);
        this.appendPtr += (long)byteLen;
    }

    public void putByte(byte c) {
        this.checkCapacity(1L);
        Unsafe.getUnsafe().putByte(this.appendPtr++, c);
    }

    public void putInt(int value) {
        this.checkCapacity(4L);
        Unsafe.getUnsafe().putInt(this.appendPtr, value);
        this.appendPtr += 4L;
    }

    public void putShort(short value) {
        this.checkCapacity(2L);
        Unsafe.getUnsafe().putShort(this.appendPtr, value);
        this.appendPtr += 2L;
    }

    public void putLong(long value) {
        this.checkCapacity(8L);
        Unsafe.getUnsafe().putLong(this.appendPtr, value);
        this.appendPtr += 8L;
    }

    private void checkCapacity(long byteCount) {
        if (this.appendPtr + byteCount > this.appendLim) {
            throw CairoException.critical(0).put("async command/event queue buffer overflow");
        }
    }
}

