/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.tasks;

import io.questdb.std.LongList;
import io.questdb.std.Mutable;

public class ColumnPurgeTask
implements Mutable {
    public static final int BLOCK_SIZE = 4;
    public static final int OFFSET_COLUMN_VERSION = 0;
    public static final int OFFSET_PARTITION_TIMESTAMP = 1;
    public static final int OFFSET_PARTITION_NAME_TXN = 2;
    public static final int OFFSET_UPDATE_ROW_ID = 3;
    private final LongList updatedColumnInfo = new LongList();
    private CharSequence columnName;
    private String tableName;
    private int tableId;
    private int partitionBy;
    private long updateTxn;
    private int columnType;
    private long truncateVersion;

    public void appendColumnInfo(long columnVersion, long partitionTimestamp, long partitionNameTxn) {
        this.updatedColumnInfo.add(columnVersion, partitionTimestamp, partitionNameTxn, 0L);
    }

    public void appendColumnInfo(long columnVersion, long partitionTimestamp, long partitionNameTxn, long updateRowId) {
        this.updatedColumnInfo.add(columnVersion, partitionTimestamp, partitionNameTxn, updateRowId);
    }

    @Override
    public void clear() {
        this.updatedColumnInfo.clear();
    }

    public void copyFrom(ColumnPurgeTask inTask) {
        this.tableName = inTask.tableName;
        this.columnName = inTask.columnName;
        this.tableId = inTask.tableId;
        this.partitionBy = inTask.partitionBy;
        this.updateTxn = inTask.updateTxn;
        this.columnType = inTask.columnType;
        this.truncateVersion = inTask.truncateVersion;
        this.updatedColumnInfo.clear();
        this.updatedColumnInfo.add(inTask.updatedColumnInfo);
    }

    public CharSequence getColumnName() {
        return this.columnName;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public int getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getTruncateVersion() {
        return this.truncateVersion;
    }

    public LongList getUpdatedColumnInfo() {
        return this.updatedColumnInfo;
    }

    public long getUpdateTxn() {
        return this.updateTxn;
    }

    public void of(String tableName, CharSequence columnName, int tableId, long truncateVersion, int columnType, int partitionBy, long updateTxn) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.tableId = tableId;
        this.columnType = columnType;
        this.partitionBy = partitionBy;
        this.updateTxn = updateTxn;
        this.truncateVersion = truncateVersion;
        this.updatedColumnInfo.clear();
    }

    public void of(String tableName, CharSequence columnName, int tableId, int truncateVersion, int columnType, int partitionBy, long updateTxn, LongList columnVersions) {
        this.of(tableName, columnName, tableId, truncateVersion, columnType, partitionBy, updateTxn);
        this.updatedColumnInfo.add(columnVersions);
    }
}

