/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class Path
extends AbstractCharSink
implements Closeable,
LPSZ {
    public static final ThreadLocal<Path> PATH = new ThreadLocal<Path>(Path::new);
    public static final ThreadLocal<Path> PATH2 = new ThreadLocal<Path>(Path::new);
    public static final Closeable CLEANER = Path::clearThreadLocals;
    private static final int OVERHEAD = 4;
    private long ptr;
    private long wptr;
    private int capacity;
    private int len;

    public Path() {
        this(255);
    }

    public Path(int capacity) {
        this.capacity = capacity;
        this.ptr = this.wptr = Unsafe.malloc(capacity + 1, 24);
    }

    public static void clearThreadLocals() {
        Misc.free(PATH);
        Misc.free(PATH2);
    }

    public static Path getThreadLocal(CharSequence root) {
        return PATH.get().of(root);
    }

    public static Path getThreadLocal(Path root) {
        return PATH.get().of(root);
    }

    public static Path getThreadLocal2(CharSequence root) {
        return PATH2.get().of(root);
    }

    public Path $() {
        if (1L + (this.wptr - this.ptr) >= (long)this.capacity) {
            this.extend((int)(16L + (this.wptr - this.ptr)));
        }
        Unsafe.getUnsafe().putByte(this.wptr++, (byte)0);
        return this;
    }

    public void $at(int index) {
        Unsafe.getUnsafe().putByte(this.ptr + (long)index, (byte)0);
    }

    public void put(int index, char c) {
        Unsafe.getUnsafe().putByte(this.ptr + (long)index, (byte)c);
    }

    @Override
    public long address() {
        return this.ptr;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    public Path chop$() {
        this.trimTo(this.length());
        return this;
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            Unsafe.free(this.ptr, this.capacity + 1, 24);
            this.ptr = 0L;
        }
    }

    public Path concat(CharSequence str) {
        return this.concat(str, 0, str.length());
    }

    public Path concat(long pUtf8NameZ) {
        this.ensureSeparator();
        long p = pUtf8NameZ;
        while (true) {
            int b;
            if (this.len + 4 >= this.capacity) {
                this.extend(this.len * 2 + 4);
            }
            if ((b = Unsafe.getUnsafe().getByte(p++)) == 0) break;
            Unsafe.getUnsafe().putByte(this.wptr, (byte)(b == 47 && Os.type == 3 ? 92 : b));
            ++this.wptr;
            ++this.len;
        }
        return this;
    }

    public Path concat(CharSequence str, int from, int to) {
        this.ensureSeparator();
        this.copy(str, from, to);
        return this;
    }

    @Override
    public void flush() {
        this.$();
    }

    @Override
    public Path put(CharSequence str) {
        int l = str.length();
        if (l + this.len >= this.capacity) {
            this.extend(l + this.len);
        }
        Chars.asciiStrCpy(str, l, this.wptr);
        this.wptr += (long)l;
        this.len += l;
        return this;
    }

    @Override
    public CharSink put(CharSequence cs, int lo, int hi) {
        int l = hi - lo;
        if (l + this.len >= this.capacity) {
            this.extend(l + this.len);
        }
        Chars.asciiStrCpy(cs, lo, l, this.wptr);
        this.wptr += (long)l;
        this.len += l;
        return this;
    }

    @Override
    public Path put(char c) {
        if (1 + this.len >= this.capacity) {
            this.extend(16 + this.len);
        }
        Unsafe.getUnsafe().putByte(this.wptr++, (byte)c);
        ++this.len;
        return this;
    }

    @Override
    public Path put(int value) {
        super.put(value);
        return this;
    }

    @Override
    public Path put(long value) {
        super.put(value);
        return this;
    }

    @Override
    public CharSink put(char[] chars, int start, int len) {
        if (len + this.len >= this.capacity) {
            this.extend(len);
        }
        Chars.asciiCopyTo(chars, start, len, this.wptr);
        this.wptr += (long)len;
        return this;
    }

    @Override
    public void putUtf8Special(char c) {
        if (c == '/' && Os.type == 3) {
            this.put('\\');
        } else {
            this.put(c);
        }
    }

    @Override
    public final int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        return (char)Unsafe.getUnsafe().getByte(this.ptr + (long)index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public Path of(CharSequence str) {
        this.checkClosed();
        if (str == this) {
            this.len = str.length();
            this.wptr = this.ptr + (long)this.len;
            return this;
        }
        this.wptr = this.ptr;
        this.len = 0;
        return this.concat(str);
    }

    public Path of(Path other) {
        return this.of((LPSZ)other);
    }

    public Path of(LPSZ other) {
        int len = other.length();
        if (this.ptr == 0L) {
            this.ptr = Unsafe.malloc(len + 1, 24);
            this.capacity = len;
        } else if (this.capacity < len) {
            this.extend(len);
        }
        if (len > 0) {
            Unsafe.getUnsafe().copyMemory(other.address(), this.ptr, len);
        }
        this.len = len;
        this.wptr = this.ptr + (long)this.len;
        return this;
    }

    public Path of(CharSequence str, int from, int to) {
        this.checkClosed();
        this.wptr = this.ptr;
        this.len = 0;
        return this.concat(str, from, to);
    }

    public Path seekZ() {
        for (int count = 0; count < this.capacity + 1; ++count) {
            if (Unsafe.getUnsafe().getByte(this.ptr + (long)count) != 0) continue;
            this.len = count;
            this.wptr = this.ptr + (long)this.len;
            break;
        }
        return this;
    }

    public Path slash() {
        this.ensureSeparator();
        return this;
    }

    public Path slash$() {
        this.ensureSeparator();
        return this.$();
    }

    @Override
    @NotNull
    public String toString() {
        if (this.ptr != 0L) {
            StringSink b = Misc.getThreadLocalBuilder();
            if (Unsafe.getUnsafe().getByte(this.wptr - 1L) == 0) {
                Chars.utf8Decode(this.ptr, this.wptr - 1L, b);
            } else {
                Chars.utf8Decode(this.ptr, this.wptr, b);
            }
            return ((Object)b).toString();
        }
        return "";
    }

    public Path trimTo(int len) {
        this.len = len;
        this.wptr = this.ptr + (long)len;
        return this;
    }

    public Path parent() {
        if (this.len > 0) {
            int idx = this.len - 1;
            char last = (char)Unsafe.getUnsafe().getByte(this.ptr + (long)idx);
            if (last == Files.SEPARATOR || last == '\u0000') {
                if (idx < 2) {
                    return this;
                }
                --idx;
            }
            while (idx > 0 && (char)Unsafe.getUnsafe().getByte(this.ptr + (long)idx) != Files.SEPARATOR) {
                --idx;
            }
            this.len = idx;
            this.wptr = this.ptr + (long)this.len;
        }
        return this;
    }

    private void checkClosed() {
        if (this.ptr == 0L) {
            this.ptr = this.wptr = Unsafe.malloc(this.capacity + 1, 24);
        }
    }

    private void copy(CharSequence str, int from, int to) {
        this.encodeUtf8(str, from, to);
    }

    protected final void ensureSeparator() {
        if (this.missingTrailingSeparator()) {
            Unsafe.getUnsafe().putByte(this.wptr, (byte)Files.SEPARATOR);
            ++this.wptr;
            ++this.len;
        }
    }

    private void extend(int len) {
        long p = Unsafe.realloc(this.ptr, this.capacity + 1, len + 1, 24);
        long d = this.wptr - this.ptr;
        this.ptr = p;
        this.wptr = p + d;
        this.capacity = len;
    }

    private boolean missingTrailingSeparator() {
        return this.len > 0 && Unsafe.getUnsafe().getByte(this.wptr - 1L) != Files.SEPARATOR;
    }
}

