/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.fastdouble;

import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.fastdouble.FastDoubleMath;
import io.questdb.std.fastdouble.FastDoubleSwar;
import io.questdb.std.fastdouble.FastDoubleUtils;
import java.nio.charset.StandardCharsets;

final class FastDoubleMem {
    FastDoubleMem() {
    }

    static double parseFloatingPointLiteral(long str, int offset, int length, boolean rejectOverflow) throws NumericException {
        boolean hasLeadingZero;
        boolean isNegative;
        int endIndex = offset + length;
        if (offset < 0) {
            throw NumericException.INSTANCE;
        }
        int index = FastDoubleMem.skipWhitespace(str, offset, endIndex);
        if (index == endIndex) {
            throw NumericException.INSTANCE;
        }
        byte ch = Unsafe.getUnsafe().getByte(str + (long)index);
        boolean bl = isNegative = ch == 45;
        if (isNegative || ch == 43) {
            byte by = ch = ++index < endIndex ? Unsafe.getUnsafe().getByte(str + (long)index) : (byte)0;
            if (ch == 0) {
                throw NumericException.INSTANCE;
            }
        }
        if (ch >= 73) {
            return ch == 78 ? FastDoubleMem.parseNaN(str, index, endIndex) : FastDoubleMem.parseInfinity(str, index, endIndex, isNegative);
        }
        boolean bl2 = hasLeadingZero = ch == 48;
        if (hasLeadingZero) {
            byte by = ch = ++index < endIndex ? Unsafe.getUnsafe().getByte(str + (long)index) : (byte)0;
            if (ch == 120 || ch == 88) {
                return FastDoubleMem.parseHexFloatingPointLiteral(str, index + 1, offset, endIndex, isNegative, rejectOverflow);
            }
        }
        return FastDoubleMem.parseDecFloatLiteral(str, index, offset, endIndex, isNegative, hasLeadingZero, rejectOverflow);
    }

    private static boolean isDigit(byte c) {
        return 48 <= c && c <= 57;
    }

    private static int skipWhitespace(long str, int index, int endIndex) {
        while (index < endIndex && (Unsafe.getUnsafe().getByte(str + (long)index) & 0xFF) <= 32) {
            ++index;
        }
        return index;
    }

    private static double parseDecFloatLiteral(long str, int index, int startIndex, int endIndex, boolean isNegative, boolean hasLeadingZero, boolean rejectOverflow) throws NumericException {
        int exponentOfTruncatedSignificand;
        boolean isSignificandTruncated;
        int exponent;
        int digitCount;
        long significand = 0L;
        int significandStartIndex = index;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        byte ch = 0;
        while (index < endIndex) {
            ch = Unsafe.getUnsafe().getByte(str + (long)index);
            if (FastDoubleMem.isDigit(ch)) {
                significand = 10L * significand + (long)ch - 48L;
            } else {
                int eightDigits;
                if (ch != 46) break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index;
                while (index < endIndex - 8 && (eightDigits = FastDoubleMem.tryToParseEightDigits(str, index + 1)) >= 0) {
                    significand = 100000000L * significand + (long)eightDigits;
                    index += 8;
                }
            }
            ++index;
        }
        int significandEndIndex = index;
        if (virtualIndexOfPoint < 0) {
            digitCount = index - significandStartIndex;
            virtualIndexOfPoint = index;
            exponent = 0;
        } else {
            digitCount = index - significandStartIndex - 1;
            exponent = virtualIndexOfPoint - index + 1;
        }
        int expNumber = 0;
        if (ch == 101 || ch == 69) {
            boolean neg_exp;
            ch = ++index < endIndex ? Unsafe.getUnsafe().getByte(str + (long)index) : (byte)0;
            boolean bl = neg_exp = ch == 45;
            if (neg_exp || ch == 43) {
                ch = ++index < endIndex ? Unsafe.getUnsafe().getByte(str + (long)index) : (byte)0;
            }
            illegal |= !FastDoubleMem.isDigit(ch);
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + ch - 48;
            } while (FastDoubleMem.isDigit(ch = ++index < endIndex ? Unsafe.getUnsafe().getByte(str + (long)index) : (byte)0));
            if (neg_exp) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (index < endIndex && (ch == 100 || ch == 68 || ch == 102 || ch == 70)) {
            ++index;
        }
        index = FastDoubleMem.skipWhitespace(str, index, endIndex);
        if (illegal || index < endIndex || !hasLeadingZero && digitCount == 0) {
            throw NumericException.INSTANCE;
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 19) {
            significand = 0L;
            for (index = significandStartIndex; index < significandEndIndex; ++index) {
                ch = Unsafe.getUnsafe().getByte(str + (long)index);
                if (ch == 46) {
                    ++skipCountInTruncatedDigits;
                    continue;
                }
                if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                significand = 10L * significand + (long)ch - 48L;
            }
            isSignificandTruncated = index < significandEndIndex;
            exponentOfTruncatedSignificand = virtualIndexOfPoint - index + skipCountInTruncatedDigits + expNumber;
        } else {
            isSignificandTruncated = false;
            exponentOfTruncatedSignificand = 0;
        }
        return FastDoubleMem.valueOfFloatLiteral(str, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand, rejectOverflow);
    }

    private static double parseHexFloatingPointLiteral(long str, int index, int startIndex, int endIndex, boolean isNegative, boolean rejectOverflow) throws NumericException {
        boolean isSignificandTruncated;
        boolean hasExponent;
        int digitCount;
        long significand = 0L;
        int exponent = 0;
        int significandStartIndex = index;
        int virtualIndexOfPoint = -1;
        boolean illegal = false;
        byte ch = 0;
        while (index < endIndex) {
            int hexValue;
            ch = Unsafe.getUnsafe().getByte(str + (long)index);
            int n = hexValue = ch < 0 ? -1 : FastDoubleUtils.CHAR_TO_HEX_MAP[ch];
            if (hexValue >= 0) {
                significand = significand << 4 | (long)hexValue;
            } else {
                if (hexValue != -4) break;
                illegal |= virtualIndexOfPoint >= 0;
                virtualIndexOfPoint = index;
            }
            ++index;
        }
        int significandEndIndex = index;
        if (virtualIndexOfPoint < 0) {
            digitCount = significandEndIndex - significandStartIndex;
            virtualIndexOfPoint = significandEndIndex;
        } else {
            digitCount = significandEndIndex - significandStartIndex - 1;
            exponent = Math.min(virtualIndexOfPoint - index + 1, 1024) * 4;
        }
        int expNumber = 0;
        boolean bl = hasExponent = ch == 112 || ch == 80;
        if (hasExponent) {
            boolean neg_exp;
            ch = ++index < endIndex ? Unsafe.getUnsafe().getByte(str + (long)index) : (byte)0;
            boolean bl2 = neg_exp = ch == 45;
            if (neg_exp || ch == 43) {
                ch = ++index < endIndex ? Unsafe.getUnsafe().getByte(str + (long)index) : (byte)0;
            }
            illegal |= !FastDoubleMem.isDigit(ch);
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + ch - 48;
            } while (FastDoubleMem.isDigit(ch = ++index < endIndex ? Unsafe.getUnsafe().getByte(str + (long)index) : (byte)0));
            if (neg_exp) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (index < endIndex && (ch == 100 || ch == 68 || ch == 102 || ch == 70)) {
            ++index;
        }
        index = FastDoubleMem.skipWhitespace(str, index, endIndex);
        if (illegal || index < endIndex || digitCount == 0 || !hasExponent) {
            throw NumericException.INSTANCE;
        }
        int skipCountInTruncatedDigits = 0;
        if (digitCount > 16) {
            significand = 0L;
            for (index = significandStartIndex; index < significandEndIndex; ++index) {
                int hexValue;
                ch = Unsafe.getUnsafe().getByte(str + (long)index);
                int n = hexValue = ch < 0 ? -1 : FastDoubleUtils.CHAR_TO_HEX_MAP[ch];
                if (hexValue >= 0) {
                    if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                    significand = significand << 4 | (long)hexValue;
                    continue;
                }
                ++skipCountInTruncatedDigits;
            }
            isSignificandTruncated = index < significandEndIndex;
        } else {
            isSignificandTruncated = false;
        }
        return FastDoubleMem.valueOfHexLiteral(str, startIndex, endIndex, isNegative, significand, exponent, isSignificandTruncated, virtualIndexOfPoint - index + skipCountInTruncatedDigits + expNumber, rejectOverflow);
    }

    private static double parseInfinity(long str, int index, int endIndex, boolean negative) throws NumericException {
        if (index + 7 < endIndex && Unsafe.getUnsafe().getByte(str + (long)index) == 73 && Unsafe.getUnsafe().getByte(str + (long)index + 1L) == 110 && Unsafe.getUnsafe().getByte(str + (long)index + 2L) == 102 && Unsafe.getUnsafe().getByte(str + (long)index + 3L) == 105 && Unsafe.getUnsafe().getByte(str + (long)index + 4L) == 110 && Unsafe.getUnsafe().getByte(str + (long)index + 5L) == 105 && Unsafe.getUnsafe().getByte(str + (long)index + 6L) == 116 && Unsafe.getUnsafe().getByte(str + (long)index + 7L) == 121 && (index = FastDoubleMem.skipWhitespace(str, index + 8, endIndex)) == endIndex) {
            return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        throw NumericException.INSTANCE;
    }

    private static double parseNaN(long str, int index, int endIndex) throws NumericException {
        if (index + 2 < endIndex && Unsafe.getUnsafe().getByte(str + (long)index + 1L) == 97 && Unsafe.getUnsafe().getByte(str + (long)index + 2L) == 78 && (index = FastDoubleMem.skipWhitespace(str, index + 3, endIndex)) == endIndex) {
            return Double.NaN;
        }
        throw NumericException.INSTANCE;
    }

    private static int tryToParseEightDigits(long str, int offset) {
        return FastDoubleSwar.tryToParseEightDigitsUtf8(Unsafe.getUnsafe().getLong(str + (long)offset));
    }

    static double valueOfFloatLiteral(long str, int startIndex, int endIndex, boolean isNegative, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand, boolean rejectOverflow) throws NumericException {
        double d = FastDoubleMath.tryDecFloatToDoubleTruncated(isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        return FastDoubleMem.dealWithNaN(d, str, startIndex, endIndex, rejectOverflow);
    }

    private static double dealWithNaN(double value, long str, int startIndex, int endIndex, boolean rejectOverflow) throws NumericException {
        if (Double.isNaN(value)) {
            int len = endIndex - startIndex;
            byte[] b = new byte[len];
            for (int i = 0; i < len; ++i) {
                b[i] = Unsafe.getUnsafe().getByte(str + (long)startIndex + (long)i);
            }
            double v = Double.parseDouble(new String(b, StandardCharsets.ISO_8859_1));
            if (rejectOverflow && (v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY || v == 0.0)) {
                throw NumericException.INSTANCE;
            }
            return v;
        }
        return value;
    }

    static double valueOfHexLiteral(long str, int startIndex, int endIndex, boolean isNegative, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand, boolean rejectOverflow) throws NumericException {
        double d = FastDoubleMath.tryHexFloatToDoubleTruncated(isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        return FastDoubleMem.dealWithNaN(d, str, startIndex, endIndex, rejectOverflow);
    }
}

