/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime.millitime;

import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.StringSink;

public final class Dates {
    public static final long DAY_MILLIS = 86400000L;
    public static final long HOUR_MILLIS = 3600000L;
    public static final long MINUTE_MILLIS = 60000L;
    public static final long SECOND_MILLIS = 1000L;
    public static final int STATE_INIT = 0;
    public static final int STATE_UTC = 1;
    public static final int STATE_GMT = 2;
    public static final int STATE_HOUR = 3;
    public static final int STATE_DELIM = 4;
    public static final int STATE_MINUTE = 5;
    public static final int STATE_END = 6;
    public static final int STATE_SIGN = 7;
    private static final long AVG_YEAR_MILLIS = 31556952000L;
    private static final long YEAR_MILLIS = 31536000000L;
    private static final long LEAP_YEAR_MILLIS = 31622400000L;
    private static final long HALF_YEAR_MILLIS = 15778476000L;
    private static final long EPOCH_MILLIS = 62167195440000L;
    private static final long HALF_EPOCH_MILLIS = 31083597720000L;
    private static final int DAY_HOURS = 24;
    private static final int HOUR_MINUTES = 60;
    private static final int MINUTE_SECONDS = 60;
    private static final int DAYS_0000_TO_1970 = 719527;
    private static final int[] DAYS_PER_MONTH = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long[] MIN_MONTH_OF_YEAR_MILLIS = new long[12];
    private static final long[] MAX_MONTH_OF_YEAR_MILLIS = new long[12];
    private static final char BEFORE_ZERO = '/';
    private static final char AFTER_NINE = ':';

    private Dates() {
    }

    public static long addDays(long millis, int days) {
        return millis + (long)days * 86400000L;
    }

    public static long addHours(long millis, int hours) {
        return millis + (long)hours * 3600000L;
    }

    public static long addMonths(long millis, int months) {
        int _y;
        boolean l;
        if (months == 0) {
            return millis;
        }
        int y = Dates.getYear(millis);
        int m = Dates.getMonthOfYear(millis, y, l = Dates.isLeapYear(y));
        int _m = m - 1 + months;
        if (_m > -1) {
            _y = y + _m / 12;
            _m = _m % 12 + 1;
        } else {
            _y = y + _m / 12 - 1;
            if ((_m = -_m % 12) == 0) {
                _m = 12;
            }
            if ((_m = 12 - _m + 1) == 1) {
                ++_y;
            }
        }
        int _d = Dates.getDayOfMonth(millis, y, m, l);
        int maxDay = Dates.getDaysPerMonth(_m, Dates.isLeapYear(_y));
        if (_d > maxDay) {
            _d = maxDay;
        }
        return Dates.toMillis(_y, _m, _d) + Dates.getTime(millis) + (long)(millis < 0L ? 1 : 0);
    }

    public static long addYear(long millis, int years) {
        if (years == 0) {
            return millis;
        }
        int y = Dates.getYear(millis);
        boolean leap1 = Dates.isLeapYear(y);
        boolean leap2 = Dates.isLeapYear(y + years);
        int m = Dates.getMonthOfYear(millis, y, leap1);
        return Dates.yearMillis(y + years, leap2) + Dates.monthOfYearMillis(m, leap2) + (long)(Dates.getDayOfMonth(millis, y, m, leap1) - 1) * 86400000L + Dates.getTime(millis) + (long)(millis < 0L ? 1 : 0);
    }

    public static long ceilDD(long millis) {
        int y = Dates.getYear(millis);
        boolean l = Dates.isLeapYear(y);
        int m = Dates.getMonthOfYear(millis, y, l);
        return Dates.yearMillis(y, l) + Dates.monthOfYearMillis(m, l) + (long)(Dates.getDayOfMonth(millis, y, m, l) - 1) * 86400000L + 82800000L + 3540000L + 59000L + 999L;
    }

    public static long ceilMM(long millis) {
        int y = Dates.getYear(millis);
        boolean l = Dates.isLeapYear(y);
        int m = Dates.getMonthOfYear(millis, y, l);
        return Dates.yearMillis(y, l) + Dates.monthOfYearMillis(m, l) + (long)(Dates.getDaysPerMonth(m, l) - 1) * 86400000L + 82800000L + 3540000L + 59000L + 999L;
    }

    public static long ceilYYYY(long millis) {
        int y = Dates.getYear(millis);
        boolean l = Dates.isLeapYear(y);
        return Dates.yearMillis(y, l) + Dates.monthOfYearMillis(12, l) + (long)(DAYS_PER_MONTH[11] - 1) * 86400000L + 82800000L + 3540000L + 59000L + 999L;
    }

    public static long endOfYear(int year) {
        return Dates.toMillis(year, 12, 31, 23, 59) + 59000L + 999L;
    }

    public static long floorDD(long millis) {
        return millis - Dates.getTime(millis);
    }

    public static long floorHH(long millis) {
        return millis - millis % 3600000L;
    }

    public static long floorMI(long millis) {
        return millis - millis % 60000L;
    }

    public static long floorMM(long millis) {
        int y = Dates.getYear(millis);
        boolean l = Dates.isLeapYear(y);
        return Dates.yearMillis(y, l) + Dates.monthOfYearMillis(Dates.getMonthOfYear(millis, y, l), l);
    }

    public static long floorYYYY(long millis) {
        int y = Dates.getYear(millis);
        return Dates.yearMillis(y, Dates.isLeapYear(y));
    }

    public static int getDayOfMonth(long millis, int year, int month, boolean leap) {
        long dateMillis = Dates.yearMillis(year, leap);
        return (int)((millis - (dateMillis += Dates.monthOfYearMillis(month, leap))) / 86400000L) + 1;
    }

    public static int getDayOfYear(long millis) {
        int year = Dates.getYear(millis);
        boolean leap = Dates.isLeapYear(year);
        long yearStart = Dates.yearMillis(year, leap);
        return (int)((millis - yearStart) / 86400000L) + 1;
    }

    public static int getDayOfWeek(long millis) {
        long d;
        if (millis > -1L) {
            d = millis / 86400000L;
        } else {
            d = (millis - 86399999L) / 86400000L;
            if (d < -3L) {
                return 7 + (int)((d + 4L) % 7L);
            }
        }
        return 1 + (int)((d + 3L) % 7L);
    }

    public static int getDayOfWeekSundayFirst(long millis) {
        long d;
        if (millis > -1L) {
            d = millis / 86400000L;
        } else {
            d = (millis - 86399999L) / 86400000L;
            if (d < -4L) {
                return 7 + (int)((d + 5L) % 7L);
            }
        }
        return 1 + (int)((d + 4L) % 7L);
    }

    public static int getWeekOfYear(long millis) {
        return Dates.getDayOfYear(millis) / 7 + 1;
    }

    public static int getWeekOfMonth(long millis) {
        int year = Dates.getYear(millis);
        boolean leap = Dates.isLeapYear(year);
        return Dates.getDayOfMonth(millis, year, Dates.getMonthOfYear(millis, year, leap), leap) / 7 + 1;
    }

    public static long getDaysBetween(long a, long b) {
        if (b < a) {
            return Dates.getDaysBetween(b, a);
        }
        return (b - a) / 86400000L;
    }

    public static int getDaysPerMonth(int m, boolean leap) {
        return leap & m == 2 ? 29 : DAYS_PER_MONTH[m - 1];
    }

    public static int getHourOfDay(long millis) {
        if (millis > -1L) {
            return (int)(millis / 3600000L % 24L);
        }
        return 23 + (int)((millis + 1L) / 3600000L % 24L);
    }

    public static int getMillisOfSecond(long millis) {
        if (millis > -1L) {
            return (int)(millis % 1000L);
        }
        return 999 + (int)((millis + 1L) % 1000L);
    }

    public static int getMinuteOfHour(long millis) {
        if (millis > -1L) {
            return (int)(millis / 60000L % 60L);
        }
        return 59 + (int)((millis + 1L) / 60000L % 60L);
    }

    public static int getMonthOfYear(long millis, int year, boolean leap) {
        int i = (int)(millis - Dates.yearMillis(year, leap) >> 10);
        return leap ? (i < 15356250 ? (i < 7678125 ? (i < 2615625 ? 1 : (i < 5062500 ? 2 : 3)) : (i < 10209375 ? 4 : (i < 12825000 ? 5 : 6))) : (i < 23118750 ? (i < 17971875 ? 7 : (i < 20587500 ? 8 : 9)) : (i < 25734375 ? 10 : (i < 28265625 ? 11 : 12)))) : (i < 15271875 ? (i < 7593750 ? (i < 2615625 ? 1 : (i < 4978125 ? 2 : 3)) : (i < 10125000 ? 4 : (i < 12740625 ? 5 : 6))) : (i < 23034375 ? (i < 17887500 ? 7 : (i < 20503125 ? 8 : 9)) : (i < 25650000 ? 10 : (i < 28181250 ? 11 : 12))));
    }

    public static long getMonthsBetween(long a, long b) {
        if (b < a) {
            return Dates.getMonthsBetween(b, a);
        }
        int aYear = Dates.getYear(a);
        int bYear = Dates.getYear(b);
        boolean aLeap = Dates.isLeapYear(aYear);
        boolean bLeap = Dates.isLeapYear(bYear);
        int aMonth = Dates.getMonthOfYear(a, aYear, aLeap);
        int bMonth = Dates.getMonthOfYear(b, bYear, bLeap);
        long aResidual = a - Dates.yearMillis(aYear, aLeap) - Dates.monthOfYearMillis(aMonth, aLeap);
        long bResidual = b - Dates.yearMillis(bYear, bLeap) - Dates.monthOfYearMillis(bMonth, bLeap);
        long months = 12L * (long)(bYear - aYear) + (long)(bMonth - aMonth);
        if (aResidual > bResidual) {
            return months - 1L;
        }
        return months;
    }

    public static int getSecondOfMinute(long millis) {
        if (millis > -1L) {
            return (int)(millis / 1000L % 60L);
        }
        return 59 + (int)((millis + 1L) / 1000L % 60L);
    }

    public static int getYear(long millis) {
        boolean leap;
        int year;
        long yearStart;
        long diff;
        long mid = (millis >> 1) + 31083597720000L;
        if (mid < 0L) {
            mid = mid - 15778476000L + 1L;
        }
        if ((diff = millis - (yearStart = Dates.yearMillis(year = (int)(mid / 15778476000L), leap = Dates.isLeapYear(year)))) < 0L) {
            --year;
        } else if (diff >= 31536000000L && (yearStart += leap ? 31622400000L : 31536000000L) <= millis) {
            ++year;
        }
        return year;
    }

    public static long getYearsBetween(long a, long b) {
        return Dates.getMonthsBetween(a, b) / 12L;
    }

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static long monthOfYearMillis(int month, boolean leap) {
        return leap ? MAX_MONTH_OF_YEAR_MILLIS[month - 1] : MIN_MONTH_OF_YEAR_MILLIS[month - 1];
    }

    public static long nextOrSameDayOfWeek(long millis, int dow) {
        int thisDow = Dates.getDayOfWeek(millis);
        if (thisDow == dow) {
            return millis;
        }
        if (thisDow < dow) {
            return millis + (long)(dow - thisDow) * 86400000L;
        }
        return millis + (long)(7 - (thisDow - dow)) * 86400000L;
    }

    public static long parseOffset(CharSequence in, int lo, int hi) {
        int minute;
        int hour;
        boolean negative;
        int state;
        int p;
        block34: {
            p = lo;
            state = 0;
            negative = false;
            hour = 0;
            minute = 0;
            try {
                while (p < hi) {
                    char c = in.charAt(p);
                    switch (state) {
                        case 0: {
                            switch (c) {
                                case 'U': 
                                case 'u': {
                                    state = 1;
                                    break;
                                }
                                case 'G': 
                                case 'g': {
                                    state = 2;
                                    break;
                                }
                                case 'Z': 
                                case 'z': {
                                    state = 6;
                                    break;
                                }
                                case '+': {
                                    state = 3;
                                    break;
                                }
                                case '-': {
                                    negative = true;
                                    state = 3;
                                    break;
                                }
                                default: {
                                    if (Dates.isDigit(c)) {
                                        state = 3;
                                        --p;
                                        break;
                                    }
                                    return Long.MIN_VALUE;
                                }
                            }
                            ++p;
                            break;
                        }
                        case 1: {
                            if (p > hi - 2 || Chars.noMatch(in, p, p + 2, "tc", 0, 2)) {
                                return Long.MIN_VALUE;
                            }
                            state = 7;
                            p += 2;
                            break;
                        }
                        case 2: {
                            if (p > hi - 2 || Chars.noMatch(in, p, p + 2, "mt", 0, 2)) {
                                return Long.MIN_VALUE;
                            }
                            state = 7;
                            p += 2;
                            break;
                        }
                        case 7: {
                            switch (c) {
                                case '+': {
                                    break;
                                }
                                case '-': {
                                    negative = true;
                                    break;
                                }
                                default: {
                                    return Long.MIN_VALUE;
                                }
                            }
                            ++p;
                            state = 3;
                            break;
                        }
                        case 3: {
                            if (!Dates.isDigit(c) || p >= hi - 1) {
                                return Long.MIN_VALUE;
                            }
                            hour = Numbers.parseInt(in, p, p + 2);
                            state = 4;
                            p += 2;
                            break;
                        }
                        case 4: {
                            if (c == ':') {
                                state = 5;
                                ++p;
                                break;
                            }
                            if (Dates.isDigit(c)) {
                                state = 5;
                                break;
                            }
                            return Long.MIN_VALUE;
                        }
                        case 5: {
                            if (!Dates.isDigit(c) || p >= hi - 1) {
                                return Long.MIN_VALUE;
                            }
                            minute = Numbers.parseInt(in, p, p + 2);
                            p += 2;
                            state = 6;
                            break block34;
                        }
                        default: {
                            return Long.MIN_VALUE;
                        }
                    }
                }
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }
        switch (state) {
            case 4: 
            case 6: {
                if (hour > 23 || minute > 59) {
                    return Long.MIN_VALUE;
                }
                int min = hour * 60 + minute;
                return Numbers.encodeLowHighInts(negative ? -min : min, p - lo);
            }
        }
        return Long.MIN_VALUE;
    }

    public static long previousOrSameDayOfWeek(long millis, int dow) {
        int thisDow = Dates.getDayOfWeek(millis);
        if (thisDow == dow) {
            return millis;
        }
        if (thisDow < dow) {
            return millis - (long)(7 + (thisDow - dow)) * 86400000L;
        }
        return millis - (long)(thisDow - dow) * 86400000L;
    }

    public static long toMillis(int y, int m, int d, int h, int mi) {
        return Dates.toMillis(y, Dates.isLeapYear(y), m, d, h, mi);
    }

    public static long toMillis(int y, boolean leap, int m, int d, int h, int mi) {
        return Dates.yearMillis(y, leap) + Dates.monthOfYearMillis(m, leap) + (long)(d - 1) * 86400000L + (long)h * 3600000L + (long)mi * 60000L;
    }

    public static String toString(long millis) {
        StringSink sink = Misc.getThreadLocalBuilder();
        DateFormatUtils.appendDateTime(sink, millis);
        return sink.toString();
    }

    public static long yearMillis(int year, boolean leap) {
        int leapYears = year / 100;
        if (year < 0) {
            leapYears = (year + 3 >> 2) - leapYears + (leapYears + 3 >> 2) - 1;
        } else {
            leapYears = (year >> 2) - leapYears + (leapYears >> 2);
            if (leap) {
                --leapYears;
            }
        }
        return ((long)year * 365L + (long)(leapYears - 719527)) * 86400000L;
    }

    private static boolean isDigit(char c) {
        return c > '/' && c < ':';
    }

    private static long getTime(long millis) {
        return millis < 0L ? 86399999L + millis % 86400000L : millis % 86400000L;
    }

    private static long toMillis(int y, int m, int d) {
        boolean l = Dates.isLeapYear(y);
        return Dates.yearMillis(y, l) + Dates.monthOfYearMillis(m, l) + (long)(d - 1) * 86400000L;
    }

    static {
        long minSum = 0L;
        long maxSum = 0L;
        for (int i = 0; i < 11; ++i) {
            Dates.MIN_MONTH_OF_YEAR_MILLIS[i + 1] = minSum += (long)DAYS_PER_MONTH[i] * 86400000L;
            Dates.MAX_MONTH_OF_YEAR_MILLIS[i + 1] = maxSum += (long)Dates.getDaysPerMonth(i + 1, true) * 86400000L;
        }
    }
}

