/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.datetime;

import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.GenericLexer;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.TimeZoneRuleFactory;
import io.questdb.std.datetime.TimeZoneRules;
import java.text.DateFormatSymbols;

public class DateLocale {
    private final IntObjHashMap<ObjList<CharSequence>> months = new IntObjHashMap();
    private final IntObjHashMap<ObjList<CharSequence>> weekdays = new IntObjHashMap();
    private final IntObjHashMap<ObjList<CharSequence>> amspms = new IntObjHashMap();
    private final IntObjHashMap<ObjList<CharSequence>> eras = new IntObjHashMap();
    private final IntObjHashMap<ObjList<CharSequence>> zones = new IntObjHashMap();
    private final String[] monthArray;
    private final String[] shortMonthArray;
    private final String[] weekdayArray;
    private final String[] shortWeekdayArray;
    private final String[] ampmArray;
    private final String[] eraArray;
    private final TimeZoneRuleFactory factory;

    public DateLocale(DateFormatSymbols symbols, TimeZoneRuleFactory timeZoneRuleFactory, CharSequenceHashSet cache) {
        this.factory = timeZoneRuleFactory;
        this.monthArray = symbols.getMonths();
        DateLocale.index(this.monthArray, this.months);
        this.shortMonthArray = symbols.getShortMonths();
        DateLocale.index(this.shortMonthArray, this.months);
        this.weekdayArray = symbols.getWeekdays();
        DateLocale.index(this.weekdayArray, this.weekdays);
        this.shortWeekdayArray = symbols.getShortWeekdays();
        DateLocale.index(this.shortWeekdayArray, this.weekdays);
        this.ampmArray = symbols.getAmPmStrings();
        DateLocale.index(this.ampmArray, this.amspms);
        this.eraArray = symbols.getEras();
        DateLocale.index(this.eraArray, this.eras);
        this.indexZones(symbols.getZoneStrings(), timeZoneRuleFactory, cache);
    }

    public static void sort(IntObjHashMap<ObjList<CharSequence>> map) {
        ObjList<CharSequence>[] values = map.getValues();
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            ObjList<CharSequence> l;
            if (values[i] == null || (l = values[i]).size() <= 1) continue;
            l.sort(GenericLexer.COMPARATOR);
        }
    }

    public String getAMPM(int index) {
        return this.ampmArray[index];
    }

    public String getEra(int index) {
        return this.eraArray[index];
    }

    public String getMonth(int index) {
        return this.monthArray[index];
    }

    public TimeZoneRules getRules(CharSequence timeZoneName, int resolution) throws NumericException {
        return this.getZoneRules(Numbers.decodeLowInt(this.matchZone(timeZoneName, 0, timeZoneName.length())), resolution);
    }

    public String getShortMonth(int index) {
        return this.shortMonthArray[index];
    }

    public String getShortWeekday(int index) {
        return this.shortWeekdayArray[index];
    }

    public String getWeekday(int index) {
        return this.weekdayArray[index];
    }

    public TimeZoneRules getZoneRules(int index, int resolution) {
        return this.factory.getTimeZoneRulesQuick(index, resolution);
    }

    public long matchAMPM(CharSequence content, int lo, int hi) throws NumericException {
        return DateLocale.findToken(content, lo, hi, this.amspms);
    }

    public long matchEra(CharSequence content, int lo, int hi) throws NumericException {
        return DateLocale.findToken(content, lo, hi, this.eras);
    }

    public long matchMonth(CharSequence content, int lo, int hi) throws NumericException {
        return DateLocale.findToken(content, lo, hi, this.months);
    }

    public long matchWeekday(CharSequence content, int lo, int hi) throws NumericException {
        return DateLocale.findToken(content, lo, hi, this.weekdays);
    }

    public long matchZone(CharSequence content, int lo, int hi) throws NumericException {
        return DateLocale.findToken(content, lo, hi, this.zones);
    }

    private static void defineToken(String token, int pos, IntObjHashMap<ObjList<CharSequence>> map) {
        ObjList<Object> l;
        if (token == null || token.length() == 0) {
            return;
        }
        char c0 = Character.toUpperCase(token.charAt(0));
        int index = map.keyIndex(c0);
        if (index > -1) {
            l = new ObjList();
            map.putAt(index, c0, l);
        } else {
            l = map.valueAtQuick(index);
        }
        l.add((char)pos + token.toUpperCase());
    }

    private static long findToken(CharSequence content, int lo, int hi, IntObjHashMap<ObjList<CharSequence>> map) throws NumericException {
        if (lo >= hi) {
            throw NumericException.INSTANCE;
        }
        char c = Character.toUpperCase(content.charAt(lo));
        ObjList<CharSequence> l = map.get(c);
        if (l == null) {
            throw NumericException.INSTANCE;
        }
        int sz = l.size();
        for (int i = 0; i < sz; ++i) {
            boolean match;
            CharSequence txt = l.get(i);
            int n = txt.length() - 1;
            boolean bl = match = n <= hi - lo;
            if (match) {
                for (int k = 1; k < n; ++k) {
                    if (Character.toUpperCase(content.charAt(lo + k)) == txt.charAt(k + 1)) continue;
                    match = false;
                    break;
                }
            }
            if (!match) continue;
            return Numbers.encodeLowHighInts(txt.charAt(0), n);
        }
        throw NumericException.INSTANCE;
    }

    private static void index(String[] tokens, IntObjHashMap<ObjList<CharSequence>> map) {
        int n = tokens.length;
        for (int i = 0; i < n; ++i) {
            DateLocale.defineToken(tokens[i], i, map);
        }
        DateLocale.sort(map);
    }

    private void indexZones(String[][] zones, TimeZoneRuleFactory timeZoneRuleFactory, CharSequenceHashSet cache) {
        int index;
        if (cache.add("UTC") && (index = timeZoneRuleFactory.getTimeZoneRulesIndex("UTC")) != -1) {
            DateLocale.defineToken("UTC", index, this.zones);
        }
        for (String[] zNames : zones) {
            String key = zNames[0];
            int index2 = timeZoneRuleFactory.getTimeZoneRulesIndex(key);
            if (index2 == -1) continue;
            int m = zNames.length;
            for (int k = 0; k < m; ++k) {
                String name = zNames[k];
                if (!cache.add(name)) continue;
                DateLocale.defineToken(name, index2, this.zones);
            }
        }
        DateLocale.sort(this.zones);
    }
}

