/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.Reopenable;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public class MemoryPages
implements Closeable,
Mutable,
Reopenable {
    private static final Log LOG = LogFactory.getLog(MemoryPages.class);
    private final long pageSize;
    private final long mask;
    private final int bits;
    private final LongList pages = new LongList();
    private long cachePageHi;
    private long cachePageLo;
    private final int maxPages;

    public MemoryPages(long pageSize, int maxPages) {
        this.pageSize = Numbers.ceilPow2(pageSize);
        this.bits = Numbers.msb(this.pageSize);
        this.mask = this.pageSize - 1L;
        this.maxPages = maxPages;
        this.allocate0(0L);
    }

    public long addressOf(long offset) {
        return this.pages.getQuick((int)(offset >>> this.bits)) + (offset & this.mask);
    }

    public long allocate(long length) {
        return this.addressOf(this.allocateOffset(length));
    }

    public long allocateOffset(long length) {
        if (this.cachePageLo + length > this.cachePageHi) {
            this.allocate0(this.cachePageLo + length >>> this.bits);
        }
        return (this.cachePageLo += length) - length;
    }

    @Override
    public void clear() {
        this.cachePageLo = 0L;
        this.cachePageHi = this.cachePageLo + this.pageSize;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.pages.size(); ++i) {
            long address = this.pages.getQuick(i);
            if (address == 0L) continue;
            Unsafe.free(address, this.pageSize, 6);
        }
        this.pages.clear();
        this.cachePageLo = 0L;
        this.cachePageHi = 0L;
    }

    @Override
    public void reopen() {
        this.allocate0(0L);
    }

    public long size() {
        return this.cachePageLo;
    }

    private void allocate0(long index) {
        if (index > Integer.MAX_VALUE) {
            throw new OutOfMemoryError();
        }
        if (index > (long)this.maxPages) {
            throw LimitOverflowException.instance().put("Maximum number of pages (").put(this.maxPages).put(") breached in MemoryPages");
        }
        if (index >= (long)this.pages.size()) {
            this.pages.extendAndSet((int)index, Unsafe.malloc(this.pageSize, 6));
            LOG.debug().$("new page [size=").$(this.pageSize).$(']').$();
        }
        this.cachePageLo = index << this.bits;
        this.cachePageHi = this.cachePageLo + this.pageSize;
    }

    public long countNumberOf(int chunkSize) {
        return (this.cachePageLo >> this.bits) * (this.pageSize / (long)chunkSize) + (this.cachePageLo & this.mask) / (long)chunkSize;
    }
}

