/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLowerCaseAsciiCharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;

public class LowerCaseAsciiCharSequenceHashSet
extends AbstractLowerCaseAsciiCharSequenceHashSet {
    private static final int MIN_INITIAL_CAPACITY = 16;

    public LowerCaseAsciiCharSequenceHashSet() {
        this(16);
    }

    private LowerCaseAsciiCharSequenceHashSet(int initialCapacity) {
        this(initialCapacity, 0.4);
    }

    private LowerCaseAsciiCharSequenceHashSet(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.clear();
    }

    public boolean add(CharSequence key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public void addAt(int index, CharSequence key) {
        this.keys[index] = Chars.toLowerCaseAscii(key);
        if (--this.free < 1) {
            this.rehash();
        }
    }

    public boolean contains(CharSequence key) {
        return this.keyIndex(key) < 0;
    }

    public CharSequence keyAt(int index) {
        return this.keys[-index - 1];
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }

    private void rehash() {
        int newCapacity = this.capacity * 2;
        int size = this.size();
        this.free = this.capacity = newCapacity;
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        CharSequence[] newKeys = new CharSequence[len];
        CharSequence[] oldKeys = this.keys;
        this.mask = len - 1;
        this.keys = newKeys;
        this.free -= size;
        for (CharSequence key : oldKeys) {
            if (key == null) continue;
            this.keys[this.keyIndex((CharSequence)key)] = key;
        }
    }
}

