/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Long256Acceptor;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;

public abstract class Long256FromCharSequenceDecoder
implements Long256Acceptor {
    public static void decode(CharSequence hexString, int startPos, int endPos, Long256Acceptor acceptor) throws NumericException {
        int minPos = startPos - 16;
        int lim = endPos;
        int p = lim - 16;
        long l0 = Long256FromCharSequenceDecoder.parse64BitGroup(startPos, minPos, hexString, p, lim);
        lim = p;
        p = lim - 16;
        long l1 = Long256FromCharSequenceDecoder.parse64BitGroup(startPos, minPos, hexString, p, lim);
        lim = p;
        long l2 = Long256FromCharSequenceDecoder.parse64BitGroup(startPos, minPos, hexString, p -= 16, lim);
        lim = p;
        if ((p -= 16) > startPos) {
            throw NumericException.INSTANCE;
        }
        long l3 = Long256FromCharSequenceDecoder.parse64BitGroup(startPos, minPos, hexString, p, lim);
        acceptor.setAll(l0, l1, l2, l3);
    }

    @Override
    public abstract void setAll(long var1, long var3, long var5, long var7);

    private static long parse64BitGroup(int startPos, int minPos, CharSequence hexString, int p, int lim) throws NumericException {
        assert (minPos == startPos - 16);
        if (p >= startPos) {
            return Numbers.parseHexLong(hexString, p, lim);
        }
        if (p > minPos) {
            return Numbers.parseHexLong(hexString, startPos, lim);
        }
        return 0L;
    }
}

