/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Chars;
import io.questdb.std.Unsafe;

public final class Hash {
    private static final long XXH_PRIME64_1 = -7046029288634856825L;
    private static final long XXH_PRIME64_2 = -4417276706812531889L;
    private static final long XXH_PRIME64_3 = 1609587929392839161L;
    private static final long XXH_PRIME64_4 = -8796714831421723037L;
    private static final long XXH_PRIME64_5 = 2870177450012600261L;
    private static final int SPREAD_HASH_BITS = Integer.MAX_VALUE;
    private static final MemoryAccessor unsafeAccessor = new MemoryAccessor(){

        @Override
        public long getLong(long offset) {
            return Unsafe.getUnsafe().getLong(offset);
        }

        @Override
        public int getInt(long offset) {
            return Unsafe.getUnsafe().getInt(offset);
        }

        @Override
        public byte getByte(long offset) {
            return Unsafe.getUnsafe().getByte(offset);
        }
    };

    private Hash() {
    }

    public static int boundedHash(CharSequence s, int max) {
        return s == null ? -1 : Chars.hashCode(s) & 0xFFFFFFF & max;
    }

    public static long hashMem(long p, long len) {
        return Hash.xxHash64(p, len, 0L, unsafeAccessor);
    }

    public static long xxHash64(long p, long len, long seed, MemoryAccessor accessor) {
        long h64;
        long end = p + len;
        if (len >= 32L) {
            long lim = end - 32L;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += accessor.getLong(p) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += accessor.getLong(p += 8L) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += accessor.getLong(p += 8L) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += accessor.getLong(p += 8L) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
            } while ((p += 8L) <= lim);
            h64 = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            h64 ^= (v1 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            h64 ^= (v2 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            h64 ^= (v3 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            h64 ^= (v4 *= -7046029288634856825L);
            h64 = h64 * -7046029288634856825L + -8796714831421723037L;
        } else {
            h64 = seed + 2870177450012600261L;
        }
        h64 += len;
        while (p <= end - 8L) {
            long k1 = accessor.getLong(p);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            h64 ^= (k1 *= -7046029288634856825L);
            h64 = Long.rotateLeft(h64, 27) * -7046029288634856825L + -8796714831421723037L;
            p += 8L;
        }
        if (p <= end - 4L) {
            h64 ^= ((long)accessor.getInt(p) & 0xFFFFFFFFL) * -7046029288634856825L;
            h64 = Long.rotateLeft(h64, 23) * -4417276706812531889L + 1609587929392839161L;
            p += 4L;
        }
        while (p < end) {
            h64 ^= (long)(accessor.getByte(p) & 0xFF) * 2870177450012600261L;
            h64 = Long.rotateLeft(h64, 11) * -7046029288634856825L;
            ++p;
        }
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        h64 *= 1609587929392839161L;
        h64 ^= h64 >>> 32;
        return h64;
    }

    public static int spread(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    public static interface MemoryAccessor {
        public long getLong(long var1);

        public int getInt(long var1);

        public byte getByte(long var1);
    }
}

