/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.cairo.CairoException;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.Os;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

public class FilesFacadeImpl
implements FilesFacade {
    public static final FilesFacade INSTANCE = new FilesFacadeImpl();
    public static final int _16M = 0x1000000;
    private long mapPageSize = 0L;
    private final FsOperation copyFsOperation = this::copy;
    private final FsOperation hardLinkFsOperation = this::hardLink;

    @Override
    public boolean allocate(long fd, long size) {
        if (Os.type != 3) {
            return Files.allocate(fd, size);
        }
        return true;
    }

    @Override
    public long append(long fd, long buf, int len) {
        return Files.append(fd, buf, len);
    }

    @Override
    public boolean close(long fd) {
        return Files.close(fd) == 0;
    }

    @Override
    public int copy(LPSZ from, LPSZ to) {
        return Files.copy(from, to);
    }

    @Override
    public int copyRecursive(Path src, Path dst, int dirMode) {
        return this.runRecursive(src, dst, dirMode, this.copyFsOperation);
    }

    @Override
    public int errno() {
        return Os.errno();
    }

    @Override
    public boolean exists(LPSZ path) {
        return Files.exists(path);
    }

    @Override
    public boolean exists(long fd) {
        return Files.exists(fd);
    }

    @Override
    public void fadvise(long fd, long offset, long len, int advise) {
        Files.fadvise(fd, offset, len, advise);
    }

    @Override
    public long findClose(long findPtr) {
        if (findPtr != 0L) {
            Files.findClose(findPtr);
        }
        return 0L;
    }

    @Override
    public long findFirst(LPSZ path) {
        long ptr = Files.findFirst(path);
        if (ptr == -1L) {
            throw CairoException.critical(Os.errno()).put("findFirst failed on ").put(path);
        }
        return ptr;
    }

    @Override
    public long findName(long findPtr) {
        return Files.findName(findPtr);
    }

    @Override
    public int findNext(long findPtr) {
        int r = Files.findNext(findPtr);
        if (r == -1) {
            throw CairoException.critical(Os.errno()).put("findNext failed");
        }
        return r;
    }

    @Override
    public int findType(long findPtr) {
        return Files.findType(findPtr);
    }

    @Override
    public int fsync(long fd) {
        return Files.fsync(fd);
    }

    @Override
    public long getLastModified(LPSZ path) {
        return Files.getLastModified(path);
    }

    @Override
    public long getMapPageSize() {
        if (this.mapPageSize == 0L) {
            this.mapPageSize = this.computeMapPageSize();
        }
        return this.mapPageSize;
    }

    @Override
    public long getOpenFileCount() {
        return Files.getOpenFileCount();
    }

    @Override
    public long getPageSize() {
        return Files.PAGE_SIZE;
    }

    @Override
    public int hardLink(LPSZ src, LPSZ hardLink) {
        return Files.hardLink(src, hardLink);
    }

    @Override
    public int hardLinkDirRecursive(Path src, Path dst, int dirMode) {
        return this.runRecursive(src, dst, dirMode, this.hardLinkFsOperation);
    }

    @Override
    public boolean isCrossDeviceCopyError(int errno) {
        return Os.isPosix() && errno == 18;
    }

    @Override
    public boolean isRestrictedFileSystem() {
        return Os.type == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateDir(LPSZ path, FindVisitor func) {
        long p = this.findFirst(path);
        if (p > 0L) {
            try {
                do {
                    func.onFind(this.findName(p), this.findType(p));
                } while (this.findNext(p) > 0);
            }
            finally {
                this.findClose(p);
            }
        }
    }

    @Override
    public long length(long fd) {
        long r = Files.length(fd);
        if (r < 0L) {
            throw CairoException.critical(Os.errno()).put("Checking file size failed");
        }
        return r;
    }

    @Override
    public long length(LPSZ name) {
        return Files.length(name);
    }

    @Override
    public int lock(long fd) {
        return Files.lock(fd);
    }

    @Override
    public int mkdir(Path path, int mode) {
        return Files.mkdir(path, mode);
    }

    @Override
    public int mkdirs(Path path, int mode) {
        return Files.mkdirs(path, mode);
    }

    @Override
    public long mmap(long fd, long len, long offset, int flags, int memoryTag) {
        return Files.mmap(fd, len, offset, flags, memoryTag);
    }

    @Override
    public long mremap(long fd, long addr, long previousSize, long newSize, long offset, int mode, int memoryTag) {
        return Files.mremap(fd, addr, previousSize, newSize, offset, mode, memoryTag);
    }

    @Override
    public int msync(long addr, long len, boolean async) {
        return Files.msync(addr, len, async);
    }

    @Override
    public void munmap(long address, long size, int memoryTag) {
        Files.munmap(address, size, memoryTag);
    }

    @Override
    public long openAppend(LPSZ name) {
        return Files.openAppend(name);
    }

    @Override
    public long openCleanRW(LPSZ name, long size) {
        return Files.openCleanRW(name, size);
    }

    @Override
    public long openRO(LPSZ name) {
        return Files.openRO(name);
    }

    @Override
    public long openRW(LPSZ name, long opts) {
        return Files.openRW(name, opts);
    }

    @Override
    public long read(long fd, long buf, long len, long offset) {
        return Files.read(fd, buf, len, offset);
    }

    @Override
    public long readULong(long fd, long offset) {
        return Files.readULong(fd, offset);
    }

    @Override
    public boolean remove(LPSZ name) {
        return Files.remove(name);
    }

    @Override
    public int rename(LPSZ from, LPSZ to) {
        return Files.rename(from, to);
    }

    @Override
    public int rmdir(Path name) {
        return Files.rmdir(name);
    }

    @Override
    public int sync() {
        return Files.sync();
    }

    @Override
    public boolean touch(LPSZ path) {
        return Files.touch(path);
    }

    @Override
    public boolean truncate(long fd, long size) {
        return Files.truncate(fd, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void walk(Path path, FindVisitor func) {
        int len = path.length();
        long p = this.findFirst(path);
        if (p > 0L) {
            try {
                do {
                    long name;
                    if (!Files.notDots(name = this.findName(p))) continue;
                    int type = this.findType(p);
                    path.trimTo(len);
                    if (type == 8) {
                        func.onFind(name, type);
                        continue;
                    }
                    this.walk(path.concat(name).$(), func);
                } while (this.findNext(p) > 0);
            }
            finally {
                this.findClose(p);
            }
        }
    }

    @Override
    public long write(long fd, long address, long len, long offset) {
        return Files.write(fd, address, len, offset);
    }

    private long computeMapPageSize() {
        long pageSize = this.getPageSize();
        long mapPageSize = pageSize * pageSize;
        if (mapPageSize < pageSize || mapPageSize > 0x1000000L) {
            if (0x1000000L % pageSize == 0L) {
                return 0x1000000L;
            }
            return pageSize;
        }
        return mapPageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runRecursive(Path src, Path dst, int dirMode, FsOperation operation) {
        int dstLen = dst.length();
        int srcLen = src.length();
        int len = src.length();
        long p = this.findFirst(src.$());
        src.chop$();
        if (!this.exists(dst.$()) && -1 == this.mkdir(dst, dirMode)) {
            return -1;
        }
        dst.chop$();
        if (p > 0L) {
            try {
                do {
                    int res;
                    long name;
                    if (!Files.notDots(name = this.findName(p))) continue;
                    int type = this.findType(p);
                    src.trimTo(len);
                    if (type == 8) {
                        src.concat(name);
                        dst.concat(name);
                        res = operation.invoke(src.$(), dst.$());
                        if (res < 0) {
                            int n = res;
                            return n;
                        }
                        src.trimTo(srcLen);
                        dst.trimTo(dstLen);
                        continue;
                    }
                    src.concat(name);
                    dst.concat(name);
                    this.mkdir(dst.$(), dirMode);
                    dst.chop$();
                    res = this.runRecursive(src, dst, dirMode, operation);
                    if (res < 0) {
                        int n = res;
                        return n;
                    }
                    src.trimTo(srcLen);
                    dst.trimTo(dstLen);
                } while (this.findNext(p) > 0);
            }
            finally {
                this.findClose(p);
                src.trimTo(srcLen);
                dst.trimTo(dstLen);
            }
        }
        return 0;
    }

    @FunctionalInterface
    private static interface FsOperation {
        public int invoke(LPSZ var1, LPSZ var2);
    }
}

