/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.str.StringSink;
import java.util.Arrays;

public class BoolList
implements Mutable {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private static final boolean NO_ENTRY_VALUE = false;
    private boolean[] buffer;
    private int pos = 0;

    public BoolList() {
        this(16);
    }

    public BoolList(int capacity) {
        this.buffer = new boolean[Math.max(capacity, 16)];
    }

    public void add(boolean value) {
        this.ensureCapacity(this.pos + 1);
        this.buffer[this.pos++] = value;
    }

    public void addAll(BoolList that) {
        int p = this.pos;
        int s = that.size();
        this.setPos(p + s);
        System.arraycopy(that.buffer, 0, this.buffer, p, s);
    }

    public void arrayCopy(int srcPos, int dstPos, int length) {
        System.arraycopy(this.buffer, srcPos, this.buffer, dstPos, length);
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public void clear(int capacity) {
        this.ensureCapacity(capacity);
        this.pos = 0;
        Arrays.fill(this.buffer, false);
    }

    public void extendAndSet(int index, boolean value) {
        this.extendCapacity(index + 1);
        this.buffer[index] = value;
    }

    private void extendCapacity(int newPos) {
        if (newPos > this.pos) {
            this.ensureCapacity(newPos);
            Arrays.fill(this.buffer, this.pos, newPos, false);
            this.pos = newPos;
        }
    }

    public boolean get(int index) {
        assert (index < this.pos);
        return this.buffer[index];
    }

    public boolean getLast() {
        if (this.pos > 0) {
            return this.buffer[this.pos - 1];
        }
        return false;
    }

    public boolean getQuiet(int index) {
        if (index < this.pos) {
            return this.buffer[index];
        }
        return false;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof BoolList && this.equals((BoolList)that);
    }

    public String toString() {
        StringSink b = Misc.getThreadLocalBuilder();
        b.put('[');
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                b.put(',');
            }
            b.put(this.get(i));
        }
        b.put(']');
        return ((Object)b).toString();
    }

    public void insert(int index, boolean element) {
        this.ensureCapacity(++this.pos);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.pos - index - 1);
        this.buffer[index] = element;
    }

    public void removeIndex(int index) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - 1;
        if (move > 0) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, move);
        }
        int index1 = --this.pos;
        this.buffer[index1] = false;
    }

    public boolean replace(int index, boolean value) {
        assert (index < this.pos);
        return this.replace0(index, value);
    }

    public boolean extendAndReplace(int index, boolean value) {
        this.extendCapacity(index + 1);
        return this.replace0(index, value);
    }

    private boolean replace0(int index, boolean value) {
        boolean val = this.buffer[index];
        this.buffer[index] = value;
        return val;
    }

    public void set(int index, boolean element) {
        if (index < this.pos) {
            this.buffer[index] = element;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public void setAll(int capacity, boolean value) {
        this.setPos(capacity);
        Arrays.fill(this.buffer, 0, this.pos, value);
    }

    public void setPos(int capacity) {
        this.ensureCapacity(capacity);
        this.pos = capacity;
    }

    public void setQuick(int index, boolean value) {
        assert (index < this.pos);
        this.buffer[index] = value;
    }

    public int size() {
        return this.pos;
    }

    public void zero(boolean value) {
        Arrays.fill(this.buffer, 0, this.pos, value);
    }

    private void ensureCapacity(int capacity) {
        int l = this.buffer.length;
        if (capacity > l) {
            int newCap = Math.max(l << 1, capacity);
            boolean[] buf = new boolean[newCap];
            System.arraycopy(this.buffer, 0, buf, 0, l);
            this.buffer = buf;
        }
    }

    private boolean equals(BoolList that) {
        if (this.pos != that.pos) {
            return false;
        }
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (this.buffer[i] == that.buffer[i]) continue;
            return false;
        }
        return true;
    }
}

