/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.EpollAccessor;
import io.questdb.network.EpollFacade;
import io.questdb.network.NetworkError;
import io.questdb.std.Files;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public final class Epoll
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Epoll.class);
    private final long events;
    private final long epollFd;
    private final int capacity;
    private final EpollFacade epf;
    private boolean closed = false;
    private long _rPtr;

    public Epoll(EpollFacade epf, int capacity) {
        this.epf = epf;
        this.capacity = capacity;
        this.events = this._rPtr = Unsafe.calloc((long)EpollAccessor.SIZEOF_EVENT * (long)capacity, 1);
        this.epollFd = epf.epollCreate();
        Files.bumpFileCount(this.epollFd);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.epf.getNetworkFacade().close(this.epollFd, LOG);
        Unsafe.free(this.events, (long)EpollAccessor.SIZEOF_EVENT * (long)this.capacity, 1);
        this.closed = true;
    }

    public int control(long fd, long id, int cmd, int event) {
        Unsafe.getUnsafe().putInt(this.events + (long)EpollAccessor.EVENTS_OFFSET, event | EpollAccessor.EPOLLET | EpollAccessor.EPOLLONESHOT);
        Unsafe.getUnsafe().putLong(this.events + (long)EpollAccessor.DATA_OFFSET, id);
        return this.epf.epollCtl(this.epollFd, cmd, fd, this.events);
    }

    public long getData() {
        return Unsafe.getUnsafe().getLong(this._rPtr + (long)EpollAccessor.DATA_OFFSET);
    }

    public int getEvent() {
        return Unsafe.getUnsafe().getInt(this._rPtr + (long)EpollAccessor.EVENTS_OFFSET);
    }

    public void listen(long sfd) {
        Unsafe.getUnsafe().putInt(this.events + (long)EpollAccessor.EVENTS_OFFSET, EpollAccessor.EPOLLIN | EpollAccessor.EPOLLET);
        Unsafe.getUnsafe().putLong(this.events + (long)EpollAccessor.DATA_OFFSET, 0L);
        if (this.epf.epollCtl(this.epollFd, EpollAccessor.EPOLL_CTL_ADD, sfd, this.events) != 0) {
            throw NetworkError.instance(this.epf.errno(), "epoll_ctl");
        }
    }

    public void removeListen(long sfd) {
        Unsafe.getUnsafe().putInt(this.events + (long)EpollAccessor.EVENTS_OFFSET, EpollAccessor.EPOLLIN | EpollAccessor.EPOLLET);
        Unsafe.getUnsafe().putLong(this.events + (long)EpollAccessor.DATA_OFFSET, 0L);
        if (this.epf.epollCtl(this.epollFd, EpollAccessor.EPOLL_CTL_DEL, sfd, this.events) != 0) {
            throw NetworkError.instance(this.epf.errno(), "epoll_ctl");
        }
    }

    public int poll() {
        return this.epf.epollWait(this.epollFd, this.events, this.capacity, 0);
    }

    public void setOffset(int offset) {
        this._rPtr = this.events + (long)offset;
    }
}

