/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.Metrics;
import io.questdb.log.Log;
import io.questdb.mp.Job;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.Worker;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.std.Misc;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public class WorkerPool {
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final int workerCount;
    private final int[] workerAffinity;
    private final SOCountDownLatch started = new SOCountDownLatch(1);
    private final ObjList<ObjHashSet<Job>> workerJobs;
    private final SOCountDownLatch halted;
    private final ObjList<Worker> workers = new ObjList();
    private final ObjList<ObjList<Closeable>> cleaners;
    private final boolean haltOnError;
    private final boolean daemons;
    private final String poolName;
    private final long yieldThreshold;
    private final long sleepThreshold;
    private final long sleepMs;
    private final ObjList<Closeable> freeOnHalt = new ObjList();
    private final Metrics metrics;

    public WorkerPool(WorkerPoolConfiguration configuration) {
        this(configuration, Metrics.disabled());
    }

    public WorkerPool(WorkerPoolConfiguration configuration, Metrics metrics) {
        this.workerCount = configuration.getWorkerCount();
        int[] workerAffinity = configuration.getWorkerAffinity();
        this.workerAffinity = workerAffinity != null && workerAffinity.length > 0 ? workerAffinity : Misc.getWorkerAffinity(this.workerCount);
        this.halted = new SOCountDownLatch(this.workerCount);
        this.haltOnError = configuration.haltOnError();
        this.daemons = configuration.isDaemonPool();
        this.poolName = configuration.getPoolName();
        this.yieldThreshold = configuration.getYieldThreshold();
        this.sleepThreshold = configuration.getSleepThreshold();
        this.sleepMs = configuration.getSleepTimeout();
        this.metrics = metrics;
        assert (this.workerAffinity.length == this.workerCount);
        this.workerJobs = new ObjList(this.workerCount);
        this.cleaners = new ObjList(this.workerCount);
        for (int i = 0; i < this.workerCount; ++i) {
            this.workerJobs.add(new ObjHashSet());
            this.cleaners.add(new ObjList());
        }
    }

    public void assign(Job job) {
        assert (!this.running.get());
        for (int i = 0; i < this.workerCount; ++i) {
            this.workerJobs.getQuick(i).add(job);
        }
    }

    public void assign(int worker, Job job) {
        assert (worker > -1 && worker < this.workerCount);
        this.workerJobs.getQuick(worker).add(job);
    }

    public void assign(int worker, Closeable cleaner) {
        assert (worker > -1 && worker < this.workerCount);
        this.cleaners.getQuick(worker).add(cleaner);
    }

    public void assignCleaner(Closeable cleaner) {
        assert (!this.running.get());
        for (int i = 0; i < this.workerCount; ++i) {
            this.cleaners.getQuick(i).add(cleaner);
        }
    }

    public void freeOnHalt(Closeable closeable) {
        assert (!this.running.get());
        this.freeOnHalt.add(closeable);
    }

    public int getWorkerCount() {
        return this.workerCount;
    }

    public void halt() {
        if (this.running.compareAndSet(true, false)) {
            this.started.await();
            for (int i = 0; i < this.workerCount; ++i) {
                this.workers.getQuick(i).halt();
            }
            this.halted.await();
            Misc.freeObjList(this.workers);
            Misc.freeObjList(this.freeOnHalt);
        }
    }

    public void start() {
        this.start(null);
    }

    public void start(@Nullable Log log) {
        if (this.running.compareAndSet(false, true)) {
            for (int i = 0; i < this.workerCount; ++i) {
                int index = i;
                Worker worker = new Worker(this.workerJobs.getQuick(i), this.halted, this.workerAffinity[i], log, ex -> {
                    ObjList<Closeable> cl = this.cleaners.getQuick(index);
                    int n = cl.size();
                    for (int j = 0; j < n; ++j) {
                        Misc.free(cl.getQuick(j));
                    }
                    if (log != null) {
                        log.info().$("cleaned [worker=").$(index).$(']').$();
                    }
                }, this.haltOnError, i, this.poolName, this.yieldThreshold, this.sleepThreshold, this.sleepMs, this.metrics);
                worker.setDaemon(this.daemons);
                this.workers.add(worker);
                worker.start();
            }
            if (log != null) {
                log.info().$("started").$();
            }
            this.started.countDown();
        }
    }
}

