/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.AbstractSSequence;
import io.questdb.mp.WaitStrategy;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import java.util.Arrays;

abstract class AbstractMSequence
extends AbstractSSequence {
    private final int[] flags;
    private final int mask;
    private final int shift;

    AbstractMSequence(int cycle, WaitStrategy waitStrategy) {
        super(waitStrategy);
        this.flags = new int[cycle];
        Arrays.fill(this.flags, -1);
        this.mask = cycle - 1;
        this.shift = Numbers.msb(cycle);
    }

    @Override
    public long availableIndex(long lo) {
        long l;
        long hi = this.value + 1L;
        for (l = lo; l < hi && this.available0(l); ++l) {
        }
        return l - 1L;
    }

    @Override
    public long current() {
        return this.value;
    }

    @Override
    public void setCurrent(long value) {
        this.value = value;
    }

    @Override
    public void done(long cursor) {
        Unsafe.getUnsafe().putOrderedInt(this.flags, ((cursor & (long)this.mask) << (int)Unsafe.INT_SCALE) + Unsafe.INT_OFFSET, (int)(cursor >>> this.shift));
        this.barrier.getWaitStrategy().signal();
    }

    private boolean available0(long lo) {
        return Unsafe.getUnsafe().getIntVolatile(this.flags, ((lo & (long)this.mask) << (int)Unsafe.INT_SCALE) + Unsafe.INT_OFFSET) == (int)(lo >>> this.shift);
    }
}

