/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.Gauge;
import io.questdb.metrics.PrometheusFormatUtils;
import io.questdb.std.str.CharSink;
import java.util.concurrent.atomic.LongAdder;

public class GaugeImpl
implements Gauge {
    private final LongAdder counter;
    private final CharSequence name;

    public GaugeImpl(CharSequence name) {
        this.name = name;
        this.counter = new LongAdder();
    }

    @Override
    public void inc() {
        this.counter.increment();
    }

    @Override
    public void dec() {
        this.counter.decrement();
    }

    @Override
    public void add(long value) {
        this.counter.add(value);
    }

    @Override
    public long getValue() {
        return this.counter.sum();
    }

    @Override
    public void scrapeIntoPrometheus(CharSink sink) {
        this.appendType(sink);
        this.appendMetricName(sink);
        PrometheusFormatUtils.appendSampleLineSuffix(sink, this.counter.longValue());
        PrometheusFormatUtils.appendNewLine(sink);
    }

    private void appendType(CharSink sink) {
        sink.put(PrometheusFormatUtils.TYPE_PREFIX);
        sink.put(this.name);
        sink.put(" gauge\n");
    }

    private void appendMetricName(CharSink sink) {
        sink.put(PrometheusFormatUtils.METRIC_NAME_PREFIX);
        sink.put(this.name);
    }
}

