/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.Metrics;
import io.questdb.log.Log;
import io.questdb.log.LogConsoleWriter;
import io.questdb.log.LogError;
import io.questdb.log.LogLevel;
import io.questdb.log.LogRecordSink;
import io.questdb.log.LogWriter;
import io.questdb.log.LogWriterConfig;
import io.questdb.log.Logger;
import io.questdb.log.SyncLogger;
import io.questdb.mp.FanOut;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.Sequence;
import io.questdb.mp.WorkerPool;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Properties;

public class LogFactory
implements Closeable {
    public static final LogFactory INSTANCE = new LogFactory();
    public static final String DEBUG_TRIGGER = "ebug";
    public static final String DEBUG_TRIGGER_ENV = "QDB_DEBUG";
    public static final String CONFIG_SYSTEM_PROPERTY = "out";
    private static final int DEFAULT_QUEUE_DEPTH = 1024;
    private static final int DEFAULT_MSG_SIZE = 4096;
    public static final String DEFAULT_CONFIG_NAME = "log.conf";
    private static final String DEFAULT_CONFIG = "/io/questdb/site/conf/log.conf";
    public static final String LOG_DIR_VAR = "${log.dir}";
    private static final String EMPTY_STR = "";
    private static final CharSequenceHashSet reserved = new CharSequenceHashSet();
    private static final LengthDescendingComparator LDC = new LengthDescendingComparator();
    private final CharSequenceObjHashMap<ScopeConfiguration> scopeConfigMap = new CharSequenceObjHashMap();
    private final ObjList<ScopeConfiguration> scopeConfigs = new ObjList();
    private final ObjHashSet<LogWriter> jobs = new ObjHashSet();
    private final MicrosecondClock clock;
    private final StringSink sink = new StringSink();
    private WorkerPool workerPool;
    private boolean configured = false;
    private int queueDepth = 1024;
    private int recordLength = 4096;
    static boolean envEnabled = true;
    static boolean overwriteWithSyncLogging = false;

    public LogFactory() {
        this(MicrosecondClockImpl.INSTANCE);
    }

    public LogFactory(MicrosecondClock clock) {
        this.clock = clock;
    }

    public static void configureAsync() {
        overwriteWithSyncLogging = false;
    }

    public static void configureFromProperties(LogFactory factory, Properties properties, WorkerPool workerPool, String logDir) {
        factory.workerPool = workerPool;
        String writers = LogFactory.getProperty(properties, "writers");
        if (writers == null) {
            factory.configured = true;
            return;
        }
        String s = LogFactory.getProperty(properties, "queueDepth");
        if (s != null && s.length() > 0) {
            try {
                factory.setQueueDepth(Numbers.parseInt(s));
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for queueDepth");
            }
        }
        if ((s = LogFactory.getProperty(properties, "recordLength")) != null && s.length() > 0) {
            try {
                factory.setRecordLength(Numbers.parseInt(s));
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for recordLength");
            }
        }
        for (String w : writers.split(",")) {
            LogWriterConfig conf = LogFactory.createWriter(properties, w.trim(), logDir);
            if (conf == null) continue;
            factory.add(conf);
        }
        factory.bind();
    }

    public static void configureFromSystemProperties(LogFactory factory) {
        LogFactory.configureFromSystemProperties(factory, null);
    }

    public static void configureFromSystemProperties(LogFactory factory, WorkerPool workerPool) {
        LogFactory.configureFromSystemProperties(factory, workerPool, null);
    }

    public static void configureFromSystemProperties(LogFactory factory, WorkerPool workerPool, String rootDir) {
        block49: {
            Properties properties;
            Throwable throwable;
            FileInputStream fis;
            File f;
            String conf = System.getProperty(CONFIG_SYSTEM_PROPERTY);
            if (conf == null) {
                conf = DEFAULT_CONFIG;
            }
            boolean initialized = false;
            String logDir = ".";
            if (rootDir != null && DEFAULT_CONFIG.equals(conf)) {
                String logPath;
                logDir = Paths.get(rootDir, "log").toString();
                File logDirFile = new File(logDir);
                if (!logDirFile.exists() && logDirFile.mkdir()) {
                    System.err.printf("Created log directory: %s%n", logDir);
                }
                if ((f = new File(logPath = Paths.get(rootDir, "conf", DEFAULT_CONFIG_NAME).toString())).isFile() && f.canRead()) {
                    System.err.printf("Reading log configuration from %s%n", logPath);
                    try {
                        fis = new FileInputStream(logPath);
                        throwable = null;
                        try {
                            properties = new Properties();
                            properties.load(fis);
                            LogFactory.configureFromProperties(factory, properties, workerPool, logDir);
                            System.err.printf("Log configuration loaded from: %s%n", logPath);
                            initialized = true;
                        }
                        catch (Throwable properties2) {
                            throwable = properties2;
                            throw properties2;
                        }
                        finally {
                            if (fis != null) {
                                if (throwable != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (Throwable properties2) {
                                        throwable.addSuppressed(properties2);
                                    }
                                } else {
                                    fis.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new LogError("Cannot read " + logPath, e);
                    }
                }
            }
            if (!initialized) {
                try (InputStream is = LogFactory.class.getResourceAsStream(conf);){
                    if (is != null) {
                        Properties properties3 = new Properties();
                        properties3.load(is);
                        LogFactory.configureFromProperties(factory, properties3, workerPool, logDir);
                        System.err.println("Log configuration loaded from default internal file.");
                        break block49;
                    }
                    f = new File(conf);
                    if (f.canRead()) {
                        fis = new FileInputStream(f);
                        throwable = null;
                        try {
                            properties = new Properties();
                            properties.load(fis);
                            LogFactory.configureFromProperties(factory, properties, workerPool, logDir);
                            System.err.printf("Log configuration loaded from: %s%n", conf);
                            break block49;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fis != null) {
                                if (throwable != null) {
                                    try {
                                        fis.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    fis.close();
                                }
                            }
                        }
                    }
                    factory.configureDefaultWriter();
                    System.err.println("Log configuration loaded loaded using factory defaults.");
                }
                catch (IOException e) {
                    if (!DEFAULT_CONFIG.equals(conf)) {
                        throw new LogError("Cannot read " + conf, e);
                    }
                    factory.configureDefaultWriter();
                }
            }
        }
        factory.startThread();
    }

    public static void configureSync() {
        overwriteWithSyncLogging = true;
    }

    public static Log getLog(Class clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(CharSequence key) {
        if (!LogFactory.INSTANCE.configured) {
            LogFactory.configureFromSystemProperties(INSTANCE, null);
        }
        return INSTANCE.create(key);
    }

    public void add(LogWriterConfig config) {
        ScopeConfiguration scopeConf;
        int index = this.scopeConfigMap.keyIndex(config.getScope());
        if (index > -1) {
            scopeConf = new ScopeConfiguration(LogLevel.MAX);
            this.scopeConfigMap.putAt(index, config.getScope(), scopeConf);
            this.scopeConfigs.add(scopeConf);
        } else {
            scopeConf = this.scopeConfigMap.valueAtQuick(index);
        }
        scopeConf.add(config);
    }

    public void assign(WorkerPool workerPool) {
        int n = this.jobs.size();
        for (int i = 0; i < n; ++i) {
            workerPool.assign(this.jobs.get(i));
        }
        if (this.workerPool == null) {
            this.workerPool = workerPool;
        }
    }

    public void bind() {
        int i;
        if (this.configured) {
            return;
        }
        this.configured = true;
        int n = this.scopeConfigs.size();
        for (i = 0; i < n; ++i) {
            ScopeConfiguration conf = this.scopeConfigs.get(i);
            conf.bind(this.jobs, this.queueDepth, this.recordLength);
        }
        this.scopeConfigMap.sortKeys(LDC);
        n = this.jobs.size();
        for (i = 0; i < n; ++i) {
            this.jobs.get(i).bindProperties(this);
        }
        if (this.workerPool != null) {
            this.assign(this.workerPool);
        }
    }

    @Override
    public void close() {
        int i;
        this.haltThread();
        int n = this.jobs.size();
        for (i = 0; i < n; ++i) {
            Misc.free(this.jobs.get(i));
        }
        n = this.scopeConfigs.size();
        for (i = 0; i < n; ++i) {
            Misc.free(this.scopeConfigs.getQuick(i));
        }
    }

    public void flushJobsAndClose() {
        int i;
        this.haltThread();
        int n = this.jobs.size();
        for (i = 0; i < n; ++i) {
            LogWriter job = this.jobs.get(i);
            if (job == null) continue;
            try {
                while (job.run(0)) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Misc.free(job);
        }
        n = this.scopeConfigs.size();
        for (i = 0; i < n; ++i) {
            Misc.free(this.scopeConfigs.getQuick(i));
        }
    }

    public Log create(CharSequence key) {
        if (!this.configured) {
            throw new LogError("Not configured");
        }
        ScopeConfiguration scopeConfiguration = this.find(key);
        if (scopeConfiguration == null) {
            return new Logger(this.clock, LogFactory.compressScope(key, this.sink), null, null, null, null, null, null, null, null, null, null);
        }
        Holder inf = scopeConfiguration.getHolder(Numbers.msb(2));
        Holder dbg = scopeConfiguration.getHolder(Numbers.msb(1));
        Holder err = scopeConfiguration.getHolder(Numbers.msb(4));
        Holder cri = scopeConfiguration.getHolder(Numbers.msb(8));
        Holder adv = scopeConfiguration.getHolder(Numbers.msb(16));
        if (!overwriteWithSyncLogging) {
            return new Logger(this.clock, LogFactory.compressScope(key, this.sink), dbg == null ? null : dbg.ring, dbg == null ? null : dbg.lSeq, inf == null ? null : inf.ring, inf == null ? null : inf.lSeq, err == null ? null : err.ring, err == null ? null : err.lSeq, cri == null ? null : cri.ring, cri == null ? null : cri.lSeq, adv == null ? null : adv.ring, adv == null ? null : adv.lSeq);
        }
        return new SyncLogger(this.clock, LogFactory.compressScope(key, this.sink), dbg == null ? null : dbg.ring, dbg == null ? null : dbg.lSeq, inf == null ? null : inf.ring, inf == null ? null : inf.lSeq, err == null ? null : err.ring, err == null ? null : err.lSeq, cri == null ? null : cri.ring, cri == null ? null : cri.lSeq, adv == null ? null : adv.ring, adv == null ? null : adv.lSeq);
    }

    public int getQueueDepth() {
        return this.queueDepth;
    }

    ObjHashSet<LogWriter> getJobs() {
        return this.jobs;
    }

    private void setQueueDepth(int queueDepth) {
        this.queueDepth = queueDepth;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    private void setRecordLength(int recordLength) {
        this.recordLength = recordLength;
    }

    public void haltThread() {
        if (this.workerPool != null) {
            this.workerPool.halt();
            this.workerPool = null;
        }
    }

    public void startThread() {
        if (this.workerPool != null) {
            return;
        }
        this.workerPool = new WorkerPool(new WorkerPoolConfiguration(){

            @Override
            public int getWorkerCount() {
                return 1;
            }

            @Override
            public boolean isDaemonPool() {
                return true;
            }

            @Override
            public String getPoolName() {
                return "logging";
            }
        }, Metrics.disabled());
        this.assign(this.workerPool);
        this.workerPool.start();
    }

    private static String getProperty(Properties properties, String key) {
        if (envEnabled) {
            String envValue = System.getenv("QDB_LOG_" + key.replace('.', '_').toUpperCase());
            if (envValue == null) {
                return properties.getProperty(key);
            }
            return envValue;
        }
        return properties.getProperty(key);
    }

    private static LogWriterConfig createWriter(Properties properties, String writerName, String logDir) {
        Constructor<?> constructor;
        Class<?> cl;
        String writer = "w." + writerName + '.';
        String clazz = LogFactory.getProperty(properties, writer + "class");
        String levelStr = LogFactory.getProperty(properties, writer + "level");
        String scope = LogFactory.getProperty(properties, writer + "scope");
        if (clazz == null) {
            return null;
        }
        try {
            cl = Class.forName(clazz);
            constructor = cl.getDeclaredConstructor(RingQueue.class, SCSequence.class, Integer.TYPE);
        }
        catch (ClassNotFoundException e) {
            throw new LogError("Class not found " + clazz, e);
        }
        catch (NoSuchMethodException e) {
            throw new LogError("Constructor(RingQueue, Sequence, int) expected: " + clazz, e);
        }
        int level = 0;
        if (levelStr != null) {
            block17: for (String s : levelStr.split(",")) {
                switch (s.toUpperCase()) {
                    case "DEBUG": {
                        level |= 1;
                        continue block17;
                    }
                    case "INFO": {
                        level |= 2;
                        continue block17;
                    }
                    case "ERROR": {
                        level |= 4;
                        continue block17;
                    }
                    case "CRITICAL": {
                        level |= 8;
                        continue block17;
                    }
                    case "ADVISORY": {
                        level |= 0x10;
                        continue block17;
                    }
                    default: {
                        throw new LogError("Unknown level: " + s);
                    }
                }
            }
        }
        if (LogFactory.isForcedDebug()) {
            level |= 1;
        }
        int msb = Numbers.msb(level);
        level = (-1 >>> msb - 1 << msb | level) & LogLevel.MASK;
        return new LogWriterConfig(scope == null ? EMPTY_STR : scope, level, (ring, seq, level1) -> {
            try {
                LogWriter w1 = (LogWriter)constructor.newInstance(ring, seq, level1);
                for (String n : properties.stringPropertyNames()) {
                    String p;
                    if (!n.startsWith(writer) || reserved.contains(p = n.substring(writer.length()))) continue;
                    try {
                        Field f = cl.getDeclaredField(p);
                        if (f.getType() != String.class) continue;
                        String value = LogFactory.getProperty(properties, n);
                        if (logDir != null && value.contains(LOG_DIR_VAR)) {
                            value = value.replace(LOG_DIR_VAR, logDir);
                        }
                        Unsafe.getUnsafe().putObject(w1, Unsafe.getUnsafe().objectFieldOffset(f), value);
                    }
                    catch (Exception e) {
                        throw new LogError("Unknown property: " + n, e);
                    }
                }
                return w1;
            }
            catch (Exception e) {
                throw new LogError("Error creating log writer", e);
            }
        });
    }

    private static boolean isForcedDebug() {
        return System.getProperty(DEBUG_TRIGGER) != null || System.getenv().containsKey(DEBUG_TRIGGER_ENV);
    }

    private static CharSequence compressScope(CharSequence key, StringSink builder) {
        builder.clear();
        char c = '\u0000';
        boolean pick = true;
        int z = 0;
        int n = key.length();
        for (int i = 0; i < n; ++i) {
            char a = key.charAt(i);
            if (a == '.') {
                if (pick) continue;
                builder.put(c).put('.');
                pick = true;
                continue;
            }
            if (!pick) continue;
            c = a;
            z = i;
            pick = false;
        }
        while (z < key.length()) {
            builder.put(key.charAt(z));
            ++z;
        }
        builder.put(' ');
        return builder.toString();
    }

    private void configureDefaultWriter() {
        int level = 30;
        if (LogFactory.isForcedDebug()) {
            level |= 1;
        }
        this.add(new LogWriterConfig(level, LogConsoleWriter::new));
        this.bind();
    }

    private ScopeConfiguration find(CharSequence key) {
        ObjList<CharSequence> keys = this.scopeConfigMap.keys();
        CharSequence k = null;
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            CharSequence s = keys.getQuick(i);
            if (!Chars.startsWith(key, s)) continue;
            k = s;
            break;
        }
        if (k == null) {
            return null;
        }
        return this.scopeConfigMap.get(k);
    }

    static {
        reserved.add("scope");
        reserved.add("class");
        reserved.add("level");
        Os.init();
    }

    private static class Holder
    implements Closeable {
        private final RingQueue<LogRecordSink> ring;
        private final Sequence lSeq;
        private SCSequence wSeq;
        private FanOut fanOut;

        public Holder(int queueDepth, int recordLength) {
            this.ring = new RingQueue<LogRecordSink>(LogRecordSink::new, Numbers.ceilPow2(recordLength), queueDepth, 1);
            this.lSeq = new MPSequence(queueDepth);
        }

        @Override
        public void close() {
            Misc.free(this.ring);
        }
    }

    private static class LengthDescendingComparator
    implements Comparator<CharSequence>,
    Serializable {
        private LengthDescendingComparator() {
        }

        @Override
        public int compare(CharSequence o1, CharSequence o2) {
            int l2;
            int l1 = o1.length();
            if (l1 < (l2 = o2.length())) {
                return 1;
            }
            if (l1 > l2) {
                return -11;
            }
            return 0;
        }
    }

    private static class ScopeConfiguration
    implements Closeable {
        private final int[] channels;
        private final ObjList<LogWriterConfig> writerConfigs = new ObjList();
        private final IntObjHashMap<Holder> holderMap = new IntObjHashMap();
        private final ObjList<Holder> holderList = new ObjList();
        private int ci = 0;

        public ScopeConfiguration(int levels) {
            this.channels = new int[levels];
        }

        public void bind(ObjHashSet<LogWriter> jobs, int queueDepth, int recordLength) {
            int i;
            for (int index : this.channels) {
                int keyIndex;
                if (index <= 0 || (keyIndex = this.holderMap.keyIndex(index)) <= -1) continue;
                Holder h = new Holder(queueDepth, recordLength);
                this.holderMap.putAt(keyIndex, index, h);
                this.holderList.add(h);
            }
            int n = this.writerConfigs.size();
            for (i = 0; i < n; ++i) {
                LogWriterConfig c = this.writerConfigs.getQuick(i);
                Holder h = this.holderMap.get(this.channels[Numbers.msb(c.getLevel())]);
                if (h.wSeq != null) {
                    if (h.fanOut == null) {
                        h.fanOut = FanOut.to(h.wSeq).and(h.wSeq = new SCSequence());
                    } else {
                        h.fanOut.and(h.wSeq = new SCSequence());
                    }
                } else {
                    h.wSeq = new SCSequence();
                }
                jobs.add(c.getFactory().createLogWriter(h.ring, h.wSeq, c.getLevel()));
            }
            n = this.holderList.size();
            for (i = 0; i < n; ++i) {
                Holder h = this.holderList.getQuick(i);
                if (h.fanOut != null) {
                    h.lSeq.then(h.fanOut).then(h.lSeq);
                    continue;
                }
                h.lSeq.then(h.wSeq).then(h.lSeq);
            }
        }

        @Override
        public void close() {
            int n = this.holderList.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.holderList.getQuick(i));
            }
        }

        private void add(LogWriterConfig conf) {
            int i;
            int mask = conf.getLevel();
            int min = Integer.MAX_VALUE;
            int q = ++this.ci;
            int n = this.channels.length;
            for (i = 0; i < n; ++i) {
                if ((mask >> i & 1) != 1) continue;
                int that = this.channels[i];
                if (that == 0) {
                    this.channels[i] = q;
                }
                if (that <= 0 || that >= min) continue;
                min = that;
            }
            if (mask > 1 && min < Integer.MAX_VALUE) {
                n = this.channels.length;
                for (i = 0; i < n; ++i) {
                    if ((mask >> i & 1) != 1) continue;
                    this.channels[i] = min;
                }
            }
            this.writerConfigs.add(conf);
        }

        private Holder getHolder(int index) {
            return this.holderMap.get(this.channels[index]);
        }
    }
}

