/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.LogFactory;
import io.questdb.log.LogRecordSink;
import io.questdb.log.LogWriter;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Files;
import java.io.Closeable;

public class LogConsoleWriter
extends SynchronizedJob
implements Closeable,
LogWriter {
    private final long fd = Files.getStdOutFd();
    private final RingQueue<LogRecordSink> ring;
    private final SCSequence subSeq;
    private final int level;
    private final QueueConsumer<LogRecordSink> myConsumer = this::toStdOut;

    public LogConsoleWriter(RingQueue<LogRecordSink> ring, SCSequence subSeq, int level) {
        this.ring = ring;
        this.subSeq = subSeq;
        this.level = level;
    }

    @Override
    public void bindProperties(LogFactory factory) {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean runSerially() {
        return this.subSeq.consumeAll(this.ring, this.myConsumer);
    }

    private void toStdOut(LogRecordSink sink) {
        if ((sink.getLevel() & this.level) != 0) {
            Files.append(this.fd, sink.getAddress(), sink.length());
        }
    }
}

