/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.BuildInformationHolder;
import io.questdb.log.HttpLogRecordSink;
import io.questdb.log.Log;
import io.questdb.log.LogAlertSocket;
import io.questdb.log.LogError;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecordSink;
import io.questdb.log.LogWriter;
import io.questdb.log.TemplateParser;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class LogAlertSocketWriter
extends SynchronizedJob
implements Closeable,
LogWriter {
    static final String DEFAULT_ALERT_TPT_FILE = "/alert-manager-tpt.json";
    static final CharSequenceObjHashMap<CharSequence> ALERT_PROPS = TemplateParser.adaptMap(System.getenv());
    private static final String DEFAULT_ENV_VALUE = "GLOBAL";
    private static final String ORG_ID_ENV = "ORGID";
    public static final String QDB_VERSION_ENV = "QDB_VERSION";
    private static final String NAMESPACE_ENV = "NAMESPACE";
    private static final String CLUSTER_ENV = "CLUSTER_NAME";
    private static final String INSTANCE_ENV = "INSTANCE_NAME";
    private static final String MESSAGE_ENV = "ALERT_MESSAGE";
    private static final String MESSAGE_ENV_VALUE = "${ALERT_MESSAGE}";
    private final int level;
    private final MicrosecondClock clock;
    private final StringSink sink = new StringSink();
    private final FilesFacade ff;
    private final NetworkFacade nf;
    private final SCSequence writeSequence;
    private final RingQueue<LogRecordSink> alertsSourceQueue;
    private final QueueConsumer<LogRecordSink> alertsProcessor = this::onLogRecord;
    private final TemplateParser alertTemplate = new TemplateParser();
    private HttpLogRecordSink alertSink;
    private LogAlertSocket socket;
    private ObjList<TemplateParser.TemplateNode> alertTemplateNodes;
    private int alertTemplateNodesLen;
    private Log log;
    private String defaultAlertHost;
    private String defaultAlertPort;
    private String location;
    private String inBufferSize;
    private String outBufferSize;
    private String alertTargets;
    private String reconnectDelay;
    private final CharSequenceObjHashMap<CharSequence> properties;

    public LogAlertSocketWriter(RingQueue<LogRecordSink> alertsSrc, SCSequence writeSequence, int level) {
        this(FilesFacadeImpl.INSTANCE, NetworkFacadeImpl.INSTANCE, MicrosecondClockImpl.INSTANCE, alertsSrc, writeSequence, level, ALERT_PROPS);
    }

    public LogAlertSocketWriter(FilesFacade ff, NetworkFacade nf, MicrosecondClock clock, RingQueue<LogRecordSink> alertsSrc, SCSequence writeSequence, int level, CharSequenceObjHashMap<CharSequence> properties) {
        this.ff = ff;
        this.nf = nf;
        this.clock = clock;
        this.alertsSourceQueue = alertsSrc;
        this.writeSequence = writeSequence;
        this.level = level & ~(1 << Numbers.msb(16));
        this.properties = properties;
    }

    @Override
    public void bindProperties(LogFactory factory) {
        int nInBufferSize = 0x200000;
        if (this.inBufferSize != null) {
            try {
                nInBufferSize = Numbers.parseIntSize(this.inBufferSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for inBufferSize: " + this.inBufferSize);
            }
        }
        int nOutBufferSize = 0x400000;
        if (this.outBufferSize != null) {
            try {
                nOutBufferSize = Numbers.parseIntSize(this.outBufferSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for outBufferSize: " + this.outBufferSize);
            }
        }
        long nReconnectDelay = 250000000L;
        if (this.reconnectDelay != null) {
            try {
                nReconnectDelay = Numbers.parseLong(this.reconnectDelay) * 1000000L;
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for reconnectDelay: " + this.reconnectDelay);
            }
        }
        if (this.defaultAlertHost == null) {
            this.defaultAlertHost = "127.0.0.1";
        }
        int nDefaultPort = 9093;
        if (this.defaultAlertPort != null) {
            try {
                nDefaultPort = Numbers.parseInt(this.defaultAlertPort);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for defaultAlertPort: " + this.defaultAlertPort);
            }
        }
        this.log = factory.create(LogAlertSocketWriter.class.getName());
        this.socket = new LogAlertSocket(this.nf, this.alertTargets, nInBufferSize, nOutBufferSize, nReconnectDelay, this.defaultAlertHost, nDefaultPort, this.log);
        this.alertSink = new HttpLogRecordSink(this.socket).putHeader(LogAlertSocket.localHostIp).setMark();
        this.loadLogAlertTemplate();
        this.socket.connect();
    }

    @Override
    public void close() {
        Misc.free(this.socket);
    }

    @Override
    public boolean runSerially() {
        return this.writeSequence.consumeAll(this.alertsSourceQueue, this.alertsProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readFile(String location, long address, long addressSize, FilesFacade ff, CharSink sink) {
        long fdTemplate = -1L;
        try (Path path = new Path();){
            path.of(location);
            fdTemplate = ff.openRO(path.$());
            if (fdTemplate == -1L) {
                throw new LogError(String.format("Cannot read %s [errno=%d]", location, ff.errno()));
            }
            long size = ff.length(fdTemplate);
            if (size > addressSize) {
                throw new LogError("Template file is too big");
            }
            if (size < 0L || size != ff.read(fdTemplate, address, size, 0L)) {
                throw new LogError(String.format("Cannot read %s [errno=%d, size=%d]", location, ff.errno(), size));
            }
            Chars.utf8Decode(address, address + size, sink);
        }
        finally {
            if (fdTemplate != -1L) {
                ff.close(fdTemplate);
            }
        }
    }

    HttpLogRecordSink getAlertSink() {
        return this.alertSink;
    }

    String getAlertTargets() {
        return this.socket.getAlertTargets();
    }

    void setAlertTargets(String alertTargets) {
        this.alertTargets = alertTargets;
    }

    String getDefaultAlertHost() {
        return this.socket.getDefaultAlertHost();
    }

    void setDefaultAlertHost(String defaultAlertHost) {
        this.defaultAlertHost = defaultAlertHost;
    }

    int getDefaultAlertPort() {
        return this.socket.getDefaultAlertPort();
    }

    void setDefaultAlertPort(String defaultAlertPort) {
        this.defaultAlertPort = defaultAlertPort;
    }

    int getInBufferSize() {
        return this.socket.getInBufferSize();
    }

    void setInBufferSize(String inBufferSize) {
        this.inBufferSize = inBufferSize;
    }

    String getLocation() {
        return this.location;
    }

    void setLocation(String location) {
        this.location = location;
    }

    int getOutBufferSize() {
        return this.socket.getOutBufferSize();
    }

    void setOutBufferSize(String outBufferSize) {
        this.outBufferSize = outBufferSize;
    }

    long getReconnectDelay() {
        return this.socket.getReconnectDelay();
    }

    void setReconnectDelay(String reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    private void loadLogAlertTemplate() {
        long now = this.clock.getTicks();
        if (this.location == null || this.location.isEmpty()) {
            this.location = DEFAULT_ALERT_TPT_FILE;
        }
        this.location = this.alertTemplate.parseEnv(this.location, now).toString();
        boolean needsReading = true;
        try (InputStream is = LogAlertSocketWriter.class.getResourceAsStream(this.location);){
            if (is != null) {
                byte[] buff = new byte[0x200000];
                int len = is.read(buff, 0, buff.length);
                String template = new String(buff, 0, len, Files.UTF_8);
                this.alertTemplate.parse((CharSequence)template, now, this.properties);
                needsReading = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (needsReading) {
            this.sink.clear();
            LogAlertSocketWriter.readFile(this.location, this.socket.getInBufferPtr(), this.socket.getInBufferSize(), this.ff, this.sink);
            this.alertTemplate.parse((CharSequence)this.sink, now, this.properties);
        }
        if (this.alertTemplate.getKeyOffset(MESSAGE_ENV) < 0) {
            throw new LogError(String.format("Bad template, no %s declaration found %s", MESSAGE_ENV_VALUE, this.location));
        }
        this.alertTemplateNodes = this.alertTemplate.getTemplateNodes();
        this.alertTemplateNodesLen = this.alertTemplateNodes.size();
    }

    void onLogRecord(LogRecordSink logRecord) {
        int len = logRecord.length();
        if ((logRecord.getLevel() & this.level) != 0 && len > 0) {
            this.alertTemplate.setDateValue(this.clock.getTicks());
            this.alertSink.rewindToMark();
            for (int i = 0; i < this.alertTemplateNodesLen; ++i) {
                TemplateParser.TemplateNode comp = this.alertTemplateNodes.getQuick(i);
                if (comp.isEnv(MESSAGE_ENV)) {
                    this.alertSink.put(logRecord);
                    continue;
                }
                this.alertSink.put(comp);
            }
            this.sink.clear();
            this.sink.put(logRecord);
            this.sink.clear(this.sink.length() - "\r\n".length());
            this.log.info().$("Sending: ").$(this.sink).$();
            this.socket.send(this.alertSink.$());
        }
    }

    static {
        if (!ALERT_PROPS.contains(ORG_ID_ENV)) {
            ALERT_PROPS.put(ORG_ID_ENV, DEFAULT_ENV_VALUE);
        }
        if (!ALERT_PROPS.contains(NAMESPACE_ENV)) {
            ALERT_PROPS.put(NAMESPACE_ENV, DEFAULT_ENV_VALUE);
        }
        if (!ALERT_PROPS.contains(CLUSTER_ENV)) {
            ALERT_PROPS.put(CLUSTER_ENV, DEFAULT_ENV_VALUE);
        }
        if (!ALERT_PROPS.contains(INSTANCE_ENV)) {
            ALERT_PROPS.put(INSTANCE_ENV, DEFAULT_ENV_VALUE);
        }
        if (!ALERT_PROPS.contains(QDB_VERSION_ENV)) {
            ALERT_PROPS.put(QDB_VERSION_ENV, BuildInformationHolder.INSTANCE.toString());
        }
        ALERT_PROPS.put(MESSAGE_ENV, MESSAGE_ENV_VALUE);
    }
}

