/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.engine.union.AbstractSetRecordCursor;
import io.questdb.griffin.engine.union.UnionCastRecord;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

class IntersectCastRecordCursor
extends AbstractSetRecordCursor {
    private final Map map;
    private final RecordSink recordSink;
    private final UnionCastRecord castRecord;
    private UnionCastRecord recordB;
    private boolean isOpen;

    public IntersectCastRecordCursor(Map map, RecordSink recordSink, @NotNull ObjList<Function> castFunctionA, @NotNull ObjList<Function> castFunctionB) {
        this.map = map;
        this.isOpen = true;
        this.recordSink = recordSink;
        this.castRecord = new UnionCastRecord(castFunctionA, castFunctionB);
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            this.map.close();
            super.close();
        }
    }

    @Override
    void of(RecordCursor cursorA, RecordCursor cursorB, SqlExecutionCircuitBreaker circuitBreaker) {
        this.cursorA = cursorA;
        this.cursorB = cursorB;
        this.circuitBreaker = circuitBreaker;
        if (!this.isOpen) {
            this.isOpen = true;
            this.map.reopen();
        }
        this.castRecord.of(cursorA.getRecord(), cursorB.getRecord());
        this.castRecord.setAb(false);
        this.hashCursorB();
        this.castRecord.setAb(true);
        this.toTop();
    }

    @Override
    public Record getRecord() {
        return this.castRecord;
    }

    @Override
    public boolean hasNext() {
        while (this.cursorA.hasNext()) {
            MapKey key = this.map.withKey();
            key.put(this.castRecord, this.recordSink);
            if (key.findValue() != null) {
                return true;
            }
            this.circuitBreaker.statefulThrowExceptionIfTripped();
        }
        return false;
    }

    @Override
    public Record getRecordB() {
        if (this.recordB == null) {
            this.recordB = new UnionCastRecord(this.castRecord.getCastFunctionsA(), this.castRecord.getCastFunctionsB());
            this.recordB.setAb(true);
            this.recordB.of(this.cursorA.getRecordB(), null);
        }
        return this.recordB;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.cursorA.recordAt(((UnionCastRecord)record).getRecordA(), atRowId);
    }

    @Override
    public void toTop() {
        this.cursorA.toTop();
    }

    @Override
    public long size() {
        return -1L;
    }

    private void hashCursorB() {
        while (this.cursorB.hasNext()) {
            MapKey key = this.map.withKey();
            key.put(this.castRecord, this.recordSink);
            key.createValue();
            this.circuitBreaker.statefulThrowExceptionIfTripped();
        }
        this.cursorB = Misc.free(this.cursorB);
    }
}

