/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;

public class TableListRecordCursorFactory
extends AbstractRecordCursorFactory {
    public static final String TABLE_NAME_COLUMN = "table";
    private static final RecordMetadata METADATA;
    private final FilesFacade ff;
    private final TableListRecordCursor cursor;
    private Path path;

    public TableListRecordCursorFactory(FilesFacade ff, CharSequence dbRoot) {
        super(METADATA);
        this.ff = ff;
        this.path = new Path().of(dbRoot).$();
        this.cursor = new TableListRecordCursor();
    }

    @Override
    protected void _close() {
        this.path = Misc.free(this.path);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        return this.cursor.of();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata(TABLE_NAME_COLUMN, 1L, 11));
        METADATA = metadata;
    }

    private class TableListRecordCursor
    implements RecordCursor {
        private final StringSink sink = new StringSink();
        private final TableListRecord record = new TableListRecord();
        private long findPtr = 0L;

        private TableListRecordCursor() {
        }

        @Override
        public void close() {
            this.findPtr = TableListRecordCursorFactory.this.ff.findClose(this.findPtr);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            do {
                if (this.findPtr == 0L) {
                    this.findPtr = TableListRecordCursorFactory.this.ff.findFirst(TableListRecordCursorFactory.this.path);
                    if (this.findPtr > 0L) continue;
                    return false;
                }
                if (TableListRecordCursorFactory.this.ff.findNext(this.findPtr) > 0) continue;
                return false;
            } while (!Files.isDir(TableListRecordCursorFactory.this.ff.findName(this.findPtr), TableListRecordCursorFactory.this.ff.findType(this.findPtr), this.sink));
            return true;
        }

        @Override
        public Record getRecordB() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toTop() {
            this.close();
        }

        @Override
        public long size() {
            return -1L;
        }

        private TableListRecordCursor of() {
            this.toTop();
            return this;
        }

        public class TableListRecord
        implements Record {
            @Override
            public CharSequence getStr(int col) {
                if (col == 0) {
                    return TableListRecordCursor.this.sink;
                }
                return null;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStr(col);
            }

            @Override
            public int getStrLen(int col) {
                return this.getStr(col).length();
            }
        }
    }
}

