/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderSelectedColumnRecord;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.std.IntList;

class SymbolIndexFilteredRowCursor
implements RowCursor {
    private final Function filter;
    private final TableReaderSelectedColumnRecord record;
    private final int columnIndex;
    private final boolean cachedIndexReaderCursor;
    private int symbolKey;
    private RowCursor rowCursor;
    private long rowid;
    private final int indexDirection;

    public SymbolIndexFilteredRowCursor(int columnIndex, int symbolKey, Function filter, boolean cachedIndexReaderCursor, int indexDirection, IntList columnIndexes) {
        this(columnIndex, filter, cachedIndexReaderCursor, indexDirection, columnIndexes);
        this.of(symbolKey);
    }

    public SymbolIndexFilteredRowCursor(int columnIndex, Function filter, boolean cachedIndexReaderCursor, int indexDirection, IntList columnIndexes) {
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
        this.indexDirection = indexDirection;
        this.record = new TableReaderSelectedColumnRecord(columnIndexes);
    }

    @Override
    public boolean hasNext() {
        while (this.rowCursor.hasNext()) {
            long rowid = this.rowCursor.next();
            this.record.setRecordIndex(rowid);
            if (!this.filter.getBool(this.record)) continue;
            this.rowid = rowid;
            return true;
        }
        return false;
    }

    @Override
    public long next() {
        return this.rowid;
    }

    public final void of(int symbolKey) {
        this.symbolKey = TableUtils.toIndexKey(symbolKey);
    }

    public SymbolIndexFilteredRowCursor of(DataFrame dataFrame) {
        this.rowCursor = dataFrame.getBitmapIndexReader(this.columnIndex, this.indexDirection).getCursor(this.cachedIndexReaderCursor, this.symbolKey, dataFrame.getRowLo(), dataFrame.getRowHi() - 1L);
        this.record.jumpTo(dataFrame.getPartitionIndex(), 0L);
        return this;
    }

    void prepare(TableReader tableReader) {
        this.record.of(tableReader);
    }
}

