/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.pool.ReaderPool;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import java.util.Iterator;
import java.util.Map;

public final class ReaderPoolRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final int TABLE_COLUMN_INDEX = 0;
    private static final int OWNER_COLUMN_INDEX = 1;
    private static final int TIMESTAMP_COLUMN_INDEX = 2;
    private static final int TXN_COLUMN_INDEX = 3;
    private static final RecordMetadata METADATA;
    private final CairoEngine cairoEngine;

    public ReaderPoolRecordCursorFactory(CairoEngine cairoEngine) {
        super(METADATA);
        this.cairoEngine = cairoEngine;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        ReaderPoolCursor readerPoolCursor = new ReaderPoolCursor();
        readerPoolCursor.of(this.cairoEngine.getReaderPoolEntries());
        return readerPoolCursor;
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(0, new TableColumnMetadata("table", 1L, 11)).add(1, new TableColumnMetadata("owner", 1L, 6)).add(2, new TableColumnMetadata("timestamp", 1L, 8)).add(3, new TableColumnMetadata("txn", 1L, 6));
        METADATA = metadata;
    }

    private static class ReaderPoolCursor
    implements RecordCursor {
        private Iterator<Map.Entry<CharSequence, ReaderPool.Entry>> iterator;
        private ReaderPool.Entry poolEntry;
        private int allocationIndex = 0;
        private CharSequence tableName;
        private long owner;
        private long timestamp;
        private long txn;
        private final ReaderPoolEntryRecord record = new ReaderPoolEntryRecord();
        private Map<CharSequence, ReaderPool.Entry> readerPoolEntries;

        private ReaderPoolCursor() {
        }

        public void of(Map<CharSequence, ReaderPool.Entry> readerPoolEntries) {
            this.readerPoolEntries = readerPoolEntries;
            this.toTop();
        }

        private boolean tryAdvance() {
            ReaderPool.R reader;
            do {
                if (!this.selectPoolEntry()) {
                    return false;
                }
                this.owner = this.poolEntry.getOwnerVolatile(this.allocationIndex);
                this.timestamp = this.poolEntry.getReleaseOrAcquireTime(this.allocationIndex);
                reader = this.poolEntry.getReader(this.allocationIndex);
                ++this.allocationIndex;
            } while (reader == null);
            this.txn = reader.getTxn();
            return true;
        }

        private boolean selectPoolEntry() {
            while (true) {
                if (this.poolEntry == null) {
                    assert (this.allocationIndex == 0);
                    if (!this.iterator.hasNext()) {
                        return false;
                    }
                    Map.Entry<CharSequence, ReaderPool.Entry> mapEntry = this.iterator.next();
                    this.tableName = mapEntry.getKey();
                    this.poolEntry = mapEntry.getValue();
                    return true;
                }
                if (this.allocationIndex != 32) break;
                this.poolEntry = this.poolEntry.getNext();
                this.allocationIndex = 0;
            }
            return true;
        }

        @Override
        public void close() {
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            return this.tryAdvance();
        }

        @Override
        public Record getRecordB() {
            throw new UnsupportedOperationException("RecordB not implemented");
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            throw new UnsupportedOperationException("Random access not implemented");
        }

        @Override
        public void toTop() {
            this.iterator = this.readerPoolEntries.entrySet().iterator();
            this.allocationIndex = 0;
            this.poolEntry = null;
            this.tableName = null;
        }

        @Override
        public long size() {
            return -1L;
        }

        private class ReaderPoolEntryRecord
        implements Record {
            private ReaderPoolEntryRecord() {
            }

            @Override
            public CharSequence getStr(int col) {
                assert (col == 0);
                return ReaderPoolCursor.this.tableName;
            }

            @Override
            public CharSequence getStrB(int col) {
                return this.getStr(col);
            }

            @Override
            public long getTimestamp(int col) {
                assert (col == 2);
                return ReaderPoolCursor.this.timestamp;
            }

            @Override
            public long getLong(int col) {
                switch (col) {
                    case 1: {
                        return ReaderPoolCursor.this.owner;
                    }
                    case 3: {
                        return ReaderPoolCursor.this.txn;
                    }
                }
                throw CairoException.nonCritical().put("unsupported column number. [column=").put(col).put("]");
            }
        }
    }
}

