/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractRecordListCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LatestByValuesIndexedFilteredRecordCursor
extends AbstractRecordListCursor {
    private final int columnIndex;
    private final IntHashSet found = new IntHashSet();
    private final IntHashSet symbolKeys;
    private final IntHashSet deferredSymbolKeys;
    private final Function filter;

    public LatestByValuesIndexedFilteredRecordCursor(int columnIndex, DirectLongList rows, @NotNull IntHashSet symbolKeys, @Nullable IntHashSet deferredSymbolKeys, Function filter, @NotNull IntList columnIndexes) {
        super(rows, columnIndexes);
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
        this.deferredSymbolKeys = deferredSymbolKeys;
        this.filter = filter;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.filter.toTop();
    }

    @Override
    protected void buildTreeMap(SqlExecutionContext executionContext) throws SqlException {
        DataFrame frame;
        this.filter.init(this, executionContext);
        int keyCount = this.symbolKeys.size();
        if (this.deferredSymbolKeys != null) {
            keyCount += this.deferredSymbolKeys.size();
        }
        this.found.clear();
        int frameColumnIndex = this.columnIndexes.getQuick(this.columnIndex);
        while ((frame = this.dataFrameCursor.next()) != null && this.found.size() < keyCount) {
            int symbolKey;
            int i;
            int partitionIndex = frame.getPartitionIndex();
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(frameColumnIndex, 2);
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(partitionIndex, 0L);
            int n = this.symbolKeys.size();
            for (i = 0; i < n; ++i) {
                symbolKey = this.symbolKeys.get(i);
                this.addFoundKey(symbolKey, indexReader, partitionIndex, rowLo, rowHi);
            }
            if (this.deferredSymbolKeys == null) continue;
            n = this.deferredSymbolKeys.size();
            for (i = 0; i < n; ++i) {
                symbolKey = this.deferredSymbolKeys.get(i);
                if (this.symbolKeys.contains(symbolKey)) continue;
                this.addFoundKey(symbolKey, indexReader, partitionIndex, rowLo, rowHi);
            }
        }
        this.rows.sortAsUnsigned();
    }

    private void addFoundKey(int symbolKey, BitmapIndexReader indexReader, int partitionIndex, long rowLo, long rowHi) {
        int index = this.found.keyIndex(symbolKey);
        if (index > -1) {
            RowCursor cursor = indexReader.getCursor(false, symbolKey, rowLo, rowHi);
            while (cursor.hasNext()) {
                long row = cursor.next();
                this.recordA.setRecordIndex(row);
                if (!this.filter.getBool(this.recordA)) continue;
                this.rows.add(Rows.toRowID(partitionIndex, row));
                this.found.addAt(index, symbolKey);
                break;
            }
        }
    }
}

