/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LatestByValueListRecordCursor
extends AbstractDataFrameRecordCursor {
    private final int shrinkToCapacity;
    private final int columnIndex;
    private final Function filter;
    private IntHashSet foundKeys;
    private IntHashSet symbolKeys;
    private final boolean restrictedByValues;
    private DirectLongList rowIds;
    private int currentRow;

    public LatestByValueListRecordCursor(int columnIndex, @Nullable Function filter, @NotNull IntList columnIndexes, int shrinkToCapacity, boolean restrictedByValues) {
        super(columnIndexes);
        this.shrinkToCapacity = shrinkToCapacity;
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.restrictedByValues = restrictedByValues;
        if (restrictedByValues) {
            this.symbolKeys = new IntHashSet(shrinkToCapacity);
        }
        this.foundKeys = new IntHashSet(shrinkToCapacity);
        this.rowIds = new DirectLongList(shrinkToCapacity, 21);
    }

    @Override
    public void close() {
        super.close();
        if (this.rowIds.size() > (long)this.shrinkToCapacity) {
            this.rowIds = Misc.free(this.rowIds);
            this.rowIds = new DirectLongList(this.shrinkToCapacity, 21);
            this.foundKeys = new IntHashSet(this.shrinkToCapacity);
        }
    }

    @Override
    void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        dataFrameCursor.toTop();
        this.foundKeys.clear();
        this.rowIds.clear();
        if (this.restrictedByValues) {
            if (this.symbolKeys.size() > 0) {
                this.rowIds.setCapacity(this.symbolKeys.size());
                if (this.filter != null) {
                    this.filter.init(this, executionContext);
                    this.filter.toTop();
                    this.findRestrictedWithFilter(this.filter, this.symbolKeys);
                } else {
                    this.findRestrictedNoFilter(this.symbolKeys);
                }
            }
        } else {
            StaticSymbolTable symbolTable = dataFrameCursor.getSymbolTable(this.columnIndexes.getQuick(this.columnIndex));
            int distinctSymbols = symbolTable.getSymbolCount();
            if (symbolTable.containsNullValue()) {
                ++distinctSymbols;
            }
            this.rowIds.setCapacity(distinctSymbols);
            if (distinctSymbols > 0) {
                if (this.filter != null) {
                    this.filter.init(this, executionContext);
                    this.filter.toTop();
                    this.findAllWithFilter(this.filter, distinctSymbols);
                } else {
                    this.findAllNoFilter(distinctSymbols);
                }
            }
        }
        this.toTop();
    }

    IntHashSet getSymbolKeys() {
        return this.symbolKeys;
    }

    public void destroy() {
        this.rowIds = Misc.free(this.rowIds);
    }

    @Override
    public long size() {
        return this.rowIds.size();
    }

    @Override
    public boolean hasNext() {
        if (this.currentRow-- > 0) {
            long rowId = this.rowIds.get(this.currentRow);
            this.recordAt(this.recordA, rowId);
            return true;
        }
        return false;
    }

    private void findAllNoFilter(int distinctCount) {
        DataFrame frame = this.dataFrameCursor.next();
        int foundSize = 0;
        while (frame != null) {
            long rowLo = frame.getRowLo();
            long row = frame.getRowHi();
            this.recordA.jumpTo(frame.getPartitionIndex(), 0L);
            while (row-- > rowLo) {
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frame.getPartitionIndex(), row));
                if (++foundSize != distinctCount) continue;
                return;
            }
            frame = this.dataFrameCursor.next();
        }
    }

    private void findAllWithFilter(Function filter, int distinctCount) {
        DataFrame frame = this.dataFrameCursor.next();
        int foundSize = 0;
        while (frame != null) {
            long rowLo = frame.getRowLo();
            long row = frame.getRowHi();
            this.recordA.jumpTo(frame.getPartitionIndex(), 0L);
            while (row-- > rowLo) {
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!filter.getBool(this.recordA) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frame.getPartitionIndex(), row));
                if (++foundSize != distinctCount) continue;
                return;
            }
            frame = this.dataFrameCursor.next();
        }
    }

    private void findRestrictedNoFilter(IntHashSet symbolKeys) {
        DataFrame frame = this.dataFrameCursor.next();
        int searchSize = symbolKeys.size();
        int foundSize = 0;
        while (frame != null) {
            long rowLo = frame.getRowLo();
            long row = frame.getRowHi();
            this.recordA.jumpTo(frame.getPartitionIndex(), 0L);
            while (row-- > rowLo) {
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!symbolKeys.contains(key) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frame.getPartitionIndex(), row));
                if (++foundSize != searchSize) continue;
                return;
            }
            frame = this.dataFrameCursor.next();
        }
    }

    private void findRestrictedWithFilter(Function filter, IntHashSet symbolKeys) {
        DataFrame frame = this.dataFrameCursor.next();
        int searchSize = symbolKeys.size();
        int foundSize = 0;
        while (frame != null) {
            long rowLo = frame.getRowLo();
            long row = frame.getRowHi();
            this.recordA.jumpTo(frame.getPartitionIndex(), 0L);
            while (row-- > rowLo) {
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (!filter.getBool(this.recordA) || !symbolKeys.contains(key) || !this.foundKeys.add(key)) continue;
                this.rowIds.add(Rows.toRowID(frame.getPartitionIndex(), row));
                if (++foundSize != searchSize) continue;
                return;
            }
            frame = this.dataFrameCursor.next();
        }
    }

    @Override
    public void toTop() {
        this.currentRow = (int)this.rowIds.size();
    }
}

