/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;

class FilteredRecordCursor
implements RecordCursor {
    private final Function filter;
    private RecordCursor base;
    private Record record;

    public FilteredRecordCursor(Function filter) {
        this.filter = filter;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.base.getSymbolTable(columnIndex);
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.base.newSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        while (this.base.hasNext()) {
            if (!this.filter.getBool(this.record)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public Record getRecordB() {
        return this.base.getRecordB();
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.base.recordAt(record, atRowId);
    }

    @Override
    public void toTop() {
        this.base.toTop();
        this.filter.toTop();
    }

    void of(RecordCursor base, SqlExecutionContext executionContext) throws SqlException {
        this.base = base;
        this.record = base.getRecord();
        this.filter.init(this, executionContext);
    }
}

