/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.griffin.engine.table.DeferredSymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.FunctionBasedRowCursorFactory;
import io.questdb.griffin.engine.table.HeapRowCursorFactory;
import io.questdb.griffin.engine.table.SequentialRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterOnValuesRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final DataFrameRecordCursor cursor;
    private final int columnIndex;
    private final Function filter;
    private final ObjList<FunctionBasedRowCursorFactory> cursorFactories;
    private final boolean followedOrderByAdvice;
    private final IntList columnIndexes;
    private final int orderDirection;
    private static final Comparator<FunctionBasedRowCursorFactory> COMPARATOR = FilterOnValuesRecordCursorFactory::compareStrFunctions;
    private static final Comparator<FunctionBasedRowCursorFactory> COMPARATOR_DESC = FilterOnValuesRecordCursorFactory::compareStrFunctionsDesc;

    public FilterOnValuesRecordCursorFactory(@NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, @NotNull ObjList<Function> keyValues, int columnIndex, @NotNull TableReader reader, @Nullable Function filter, int orderByMnemonic, boolean followedOrderByAdvice, int orderDirection, int indexDirection, @NotNull IntList columnIndexes) {
        super(metadata, dataFrameCursorFactory);
        int nKeyValues = keyValues.size();
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.columnIndexes = columnIndexes;
        this.orderDirection = orderDirection;
        this.cursorFactories = new ObjList(nKeyValues);
        SymbolMapReader symbolMapReader = reader.getSymbolMapReader(columnIndex);
        for (int i = 0; i < nKeyValues; ++i) {
            Function symbol = keyValues.get(i);
            if (symbol.isConstant()) {
                this.addSymbolKey(symbolMapReader.keyOf(symbol.getStr(null)), symbol, indexDirection);
                continue;
            }
            this.addSymbolKey(-2, symbol, indexDirection);
        }
        this.cursor = orderByMnemonic == 2 ? new DataFrameRecordCursor(new SequentialRowCursorFactory(this.cursorFactories), false, filter, columnIndexes) : new DataFrameRecordCursor(new HeapRowCursorFactory(this.cursorFactories), false, filter, columnIndexes);
        this.followedOrderByAdvice = followedOrderByAdvice;
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.followedOrderByAdvice;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    private void addSymbolKey(int symbolKey, Function symbolFunction, int indexDirection) {
        FunctionBasedRowCursorFactory rowCursorFactory = this.filter == null ? (symbolKey == -2 ? new DeferredSymbolIndexRowCursorFactory(this.columnIndex, symbolFunction, this.cursorFactories.size() == 0, indexDirection) : new SymbolIndexRowCursorFactory(this.columnIndex, symbolKey, this.cursorFactories.size() == 0, indexDirection, symbolFunction)) : (symbolKey == -2 ? new DeferredSymbolIndexFilteredRowCursorFactory(this.columnIndex, symbolFunction, this.filter, this.cursorFactories.size() == 0, indexDirection, this.columnIndexes) : new SymbolIndexFilteredRowCursorFactory(this.columnIndex, symbolKey, this.filter, this.cursorFactories.size() == 0, indexDirection, this.columnIndexes, symbolFunction));
        this.cursorFactories.add(rowCursorFactory);
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext sqlExecutionContext) throws SqlException {
        int n = this.cursorFactories.size();
        for (int i = 0; i < n; ++i) {
            this.cursorFactories.getQuick(i).getFunction().init(dataFrameCursor, sqlExecutionContext);
        }
        if (this.followedOrderByAdvice && this.orderDirection == 0) {
            this.cursorFactories.sort(COMPARATOR);
        } else {
            this.cursorFactories.sort(COMPARATOR_DESC);
        }
        this.cursor.of(dataFrameCursor, sqlExecutionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, sqlExecutionContext);
        }
        return this.cursor;
    }

    private static int compareStrFunctions(FunctionBasedRowCursorFactory a, FunctionBasedRowCursorFactory b) {
        return Chars.compare(a.getFunction().getStr(null), b.getFunction().getStrB(null));
    }

    private static int compareStrFunctionsDesc(FunctionBasedRowCursorFactory a, FunctionBasedRowCursorFactory b) {
        return Chars.compareDescending(a.getFunction().getStr(null), b.getFunction().getStrB(null));
    }
}

