/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.BwdTableReaderPageFrameCursor;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.griffin.engine.table.FwdTableReaderPageFrameCursor;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.str.CharSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFrameRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    protected final int pageFrameMinRows;
    protected final int pageFrameMaxRows;
    private final DataFrameRecordCursor cursor;
    private final boolean followsOrderByAdvice;
    private final Function filter;
    private final boolean framingSupported;
    private final IntList columnIndexes;
    private final IntList columnSizes;
    protected FwdTableReaderPageFrameCursor fwdPageFrameCursor;
    protected BwdTableReaderPageFrameCursor bwdPageFrameCursor;
    private final boolean supportsRandomAccess;

    public DataFrameRecordCursorFactory(@NotNull CairoConfiguration configuration, RecordMetadata metadata, DataFrameCursorFactory dataFrameCursorFactory, RowCursorFactory rowCursorFactory, boolean followsOrderByAdvice, @Nullable Function filter, boolean framingSupported, @NotNull IntList columnIndexes, @NotNull IntList columnSizes, boolean supportsRandomAccess) {
        super(metadata, dataFrameCursorFactory);
        this.cursor = new DataFrameRecordCursor(rowCursorFactory, rowCursorFactory.isEntity(), filter, columnIndexes);
        this.followsOrderByAdvice = followsOrderByAdvice;
        this.filter = filter;
        this.framingSupported = framingSupported;
        this.columnIndexes = columnIndexes;
        this.columnSizes = columnSizes;
        this.pageFrameMinRows = configuration.getSqlPageFrameMinRows();
        this.pageFrameMaxRows = configuration.getSqlPageFrameMaxRows();
        this.supportsRandomAccess = supportsRandomAccess;
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.filter);
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.followsOrderByAdvice;
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext, int order) throws SqlException {
        DataFrameCursor dataFrameCursor = this.dataFrameCursorFactory.getCursor(executionContext, order);
        if (this.framingSupported) {
            if (order == 0 || order == 2) {
                return this.initFwdPageFrameCursor(executionContext, dataFrameCursor);
            }
            return this.initBwdPageFrameCursor(executionContext, dataFrameCursor);
        }
        return null;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.supportsRandomAccess;
    }

    @Override
    public boolean supportPageFrameCursor() {
        return this.framingSupported;
    }

    @Override
    public boolean supportsUpdateRowId(CharSequence tableName) {
        return this.dataFrameCursorFactory.supportTableRowId(tableName);
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("{\"name\":\"DataFrameRecordCursorFactory\", \"cursorFactory\":");
        this.dataFrameCursorFactory.toSink(sink);
        sink.put('}');
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("DataFrameRecordCursorFactory");
        if (this.filter != null) {
            sink.attr("filter").val(this.filter);
        }
        sink.child(this.dataFrameCursorFactory);
    }

    @Override
    public boolean hasDescendingOrder() {
        return this.dataFrameCursorFactory.getOrder() == 1;
    }

    protected PageFrameCursor initFwdPageFrameCursor(SqlExecutionContext executionContext, DataFrameCursor dataFrameCursor) {
        if (this.fwdPageFrameCursor == null) {
            this.fwdPageFrameCursor = new FwdTableReaderPageFrameCursor(this.columnIndexes, this.columnSizes, executionContext.getSharedWorkerCount(), this.pageFrameMinRows, this.pageFrameMaxRows);
        }
        return this.fwdPageFrameCursor.of(dataFrameCursor);
    }

    protected PageFrameCursor initBwdPageFrameCursor(SqlExecutionContext executionContext, DataFrameCursor dataFrameCursor) {
        if (this.bwdPageFrameCursor == null) {
            this.bwdPageFrameCursor = new BwdTableReaderPageFrameCursor(this.columnIndexes, this.columnSizes, executionContext.getSharedWorkerCount(), this.pageFrameMinRows, this.pageFrameMaxRows);
        }
        return this.bwdPageFrameCursor.of(dataFrameCursor);
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.cursor.of(dataFrameCursor, executionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, executionContext);
        }
        return this.cursor;
    }
}

