/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Long128Util;
import io.questdb.std.Long256Util;
import io.questdb.std.Numbers;

public class RecordComparatorCompiler {
    private final BytecodeAssembler asm;
    private final CharSequenceIntHashMap typeMap = new CharSequenceIntHashMap();
    private final CharSequenceIntHashMap methodMap = new CharSequenceIntHashMap();
    private final IntList fieldIndices = new IntList();
    private final IntList fieldNameIndices = new IntList();
    private final IntList fieldTypeIndices = new IntList();
    private final IntList fieldRecordAccessorIndicesA = new IntList();
    private final IntList fieldRecordAccessorIndicesB = new IntList();
    private final IntList comparatorAccessorIndices = new IntList();
    private final IntList branches = new IntList();

    public RecordComparatorCompiler(BytecodeAssembler asm) {
        this.asm = asm;
    }

    public RecordComparator compile(ColumnTypes columnTypes, IntList keyColumnIndices) {
        assert (keyColumnIndices.size() < 1560);
        this.asm.init(RecordComparator.class);
        this.asm.setupPool();
        int stackMapTableIndex = this.asm.poolUtf8("StackMapTable");
        int thisClassIndex = this.asm.poolClass(this.asm.poolUtf8("io/questdb/griffin/engine/comparator"));
        int interfaceClassIndex = this.asm.poolClass(RecordComparator.class);
        int recordClassIndex = this.asm.poolClass(Record.class);
        int compareNameIndex = this.asm.poolUtf8("compare");
        int compareDescIndex = this.asm.poolUtf8("(Lio/questdb/cairo/sql/Record;)I");
        this.poolFieldArtifacts(compareNameIndex, thisClassIndex, recordClassIndex, columnTypes, keyColumnIndices);
        int setLeftNameIndex = this.asm.poolUtf8("setLeft");
        int setLeftDescIndex = this.asm.poolUtf8("(Lio/questdb/cairo/sql/Record;)V");
        this.asm.finishPool();
        this.asm.defineClass(thisClassIndex);
        this.asm.interfaceCount(1);
        this.asm.putShort(interfaceClassIndex);
        this.asm.fieldCount(this.fieldNameIndices.size());
        int n = this.fieldNameIndices.size();
        for (int i = 0; i < n; ++i) {
            this.asm.defineField(this.fieldNameIndices.getQuick(i), this.fieldTypeIndices.getQuick(i));
        }
        this.asm.methodCount(3);
        this.asm.defineDefaultConstructor();
        this.instrumentSetLeftMethod(setLeftNameIndex, setLeftDescIndex, keyColumnIndices, columnTypes);
        this.instrumentCompareMethod(stackMapTableIndex, compareNameIndex, compareDescIndex, keyColumnIndices, columnTypes);
        this.asm.putShort(0);
        return (RecordComparator)this.asm.newInstance();
    }

    private void instrumentCompareMethod(int stackMapTableIndex, int nameIndex, int descIndex, IntList keyColumns, ColumnTypes columnTypes) {
        this.branches.clear();
        int sz = keyColumns.size();
        int maxStack = sz + (this.fieldIndices.size() > sz ? 4 : 0) + 3;
        this.asm.startMethod(nameIndex, descIndex, maxStack, 3);
        int fieldIndex = 0;
        for (int i = 0; i < sz; ++i) {
            if (i > 0) {
                this.asm.iload(2);
                this.branches.add(this.asm.ifne());
            }
            this.asm.aload(0);
            this.asm.getfield(this.fieldIndices.getQuick(fieldIndex++));
            this.asm.aload(1);
            int index = keyColumns.getQuick(i);
            int columnIndex = (index > 0 ? index : -index) - 1;
            this.asm.iconst(columnIndex);
            this.asm.invokeInterface(this.fieldRecordAccessorIndicesA.getQuick(i), 1);
            if (columnTypes.getColumnType(columnIndex) == 24) {
                this.asm.aload(0);
                this.asm.getfield(this.fieldIndices.getQuick(fieldIndex++));
                this.asm.aload(1);
                this.asm.iconst(columnIndex);
                this.asm.invokeInterface(this.fieldRecordAccessorIndicesB.getQuick(i), 1);
            }
            this.asm.invokeStatic(this.comparatorAccessorIndices.getQuick(i));
            if (index < 0) {
                this.asm.ineg();
            }
            this.asm.istore(2);
        }
        int p = this.asm.position();
        this.asm.iload(2);
        this.asm.ireturn();
        int n = this.branches.size();
        for (int i = 0; i < n; ++i) {
            this.asm.setJmp(this.branches.getQuick(i), p);
        }
        this.asm.endMethodCode();
        this.asm.putShort(0);
        this.asm.putShort(1);
        this.asm.startStackMapTables(stackMapTableIndex, 1);
        this.asm.append_frame(1, p - this.asm.getCodeStart());
        this.asm.putITEM_Integer();
        this.asm.endStackMapTables();
        this.asm.endMethod();
    }

    private void instrumentSetLeftMethod(int nameIndex, int descIndex, IntList keyColumns, ColumnTypes columnTypes) {
        this.asm.startMethod(nameIndex, descIndex, 3, 2);
        int fieldIndex = 0;
        int n = keyColumns.size();
        for (int i = 0; i < n; ++i) {
            this.asm.aload(0);
            this.asm.aload(1);
            int index = keyColumns.getQuick(i);
            int columnIndex = (index > 0 ? index : -index) - 1;
            this.asm.iconst(columnIndex);
            this.asm.invokeInterface(this.fieldRecordAccessorIndicesB.getQuick(i), 1);
            this.asm.putfield(this.fieldIndices.getQuick(fieldIndex++));
            if (columnTypes.getColumnType(columnIndex) != 24) continue;
            this.asm.aload(0);
            this.asm.aload(1);
            this.asm.iconst(columnIndex);
            this.asm.invokeInterface(this.fieldRecordAccessorIndicesA.getQuick(i), 1);
            this.asm.putfield(this.fieldIndices.getQuick(fieldIndex++));
        }
        this.asm.return_();
        this.asm.endMethodCode();
        this.asm.putShort(0);
        this.asm.putShort(0);
        this.asm.endMethod();
    }

    private void poolFieldArtifacts(int compareMethodIndex, int thisClassIndex, int recordClassIndex, ColumnTypes columnTypes, IntList keyColumnIndices) {
        this.typeMap.clear();
        this.fieldIndices.clear();
        this.fieldNameIndices.clear();
        this.fieldTypeIndices.clear();
        this.fieldRecordAccessorIndicesA.clear();
        this.fieldRecordAccessorIndicesB.clear();
        this.comparatorAccessorIndices.clear();
        this.methodMap.clear();
        int n = keyColumnIndices.size();
        for (int i = 0; i < n; ++i) {
            int typeIndex;
            Class comparatorClass;
            String getterNameA;
            String fieldType;
            String getterNameB = null;
            String comparatorDesc = null;
            int index = keyColumnIndices.getQuick(i);
            if (index < 0) {
                index = -index;
            }
            int columnType = columnTypes.getColumnType(--index);
            switch (ColumnType.tagOf(columnType)) {
                case 1: {
                    fieldType = "Z";
                    getterNameA = "getBool";
                    comparatorClass = Boolean.class;
                    break;
                }
                case 2: {
                    fieldType = "B";
                    getterNameA = "getByte";
                    comparatorClass = Byte.class;
                    break;
                }
                case 10: {
                    fieldType = "D";
                    getterNameA = "getDouble";
                    comparatorClass = Numbers.class;
                    break;
                }
                case 9: {
                    fieldType = "F";
                    getterNameA = "getFloat";
                    comparatorClass = Numbers.class;
                    break;
                }
                case 5: {
                    fieldType = "I";
                    getterNameA = "getInt";
                    comparatorClass = Integer.class;
                    break;
                }
                case 6: {
                    fieldType = "J";
                    getterNameA = "getLong";
                    comparatorClass = Long.class;
                    break;
                }
                case 7: {
                    fieldType = "J";
                    getterNameA = "getDate";
                    comparatorClass = Long.class;
                    break;
                }
                case 8: {
                    fieldType = "J";
                    getterNameA = "getTimestamp";
                    comparatorClass = Long.class;
                    break;
                }
                case 3: {
                    fieldType = "S";
                    getterNameA = "getShort";
                    comparatorClass = Short.class;
                    break;
                }
                case 4: {
                    fieldType = "C";
                    getterNameA = "getChar";
                    comparatorClass = Character.class;
                    break;
                }
                case 11: {
                    getterNameA = "getStr";
                    getterNameB = "getStrB";
                    fieldType = "Ljava/lang/CharSequence;";
                    comparatorClass = Chars.class;
                    break;
                }
                case 13: {
                    getterNameA = "getLong256A";
                    getterNameB = "getLong256B";
                    fieldType = "Lio/questdb/std/Long256;";
                    comparatorClass = Long256Util.class;
                    break;
                }
                case 24: {
                    getterNameA = "getLong128Hi";
                    getterNameB = "getLong128Lo";
                    fieldType = "J";
                    comparatorDesc = "(JJJJ)I";
                    comparatorClass = Long128Util.class;
                    break;
                }
                default: {
                    getterNameA = "getSym";
                    getterNameB = "getSymB";
                    fieldType = "Ljava/lang/CharSequence;";
                    comparatorClass = Chars.class;
                    comparatorDesc = "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)I";
                }
            }
            int keyIndex = this.typeMap.keyIndex(fieldType);
            if (keyIndex > -1) {
                typeIndex = this.asm.poolUtf8(fieldType);
                this.typeMap.putAt(keyIndex, fieldType, typeIndex);
            } else {
                typeIndex = this.typeMap.valueAt(keyIndex);
            }
            this.fieldTypeIndices.add(typeIndex);
            int nameIndex = this.asm.poolUtf8().put('f').put(i).$();
            this.fieldNameIndices.add(nameIndex);
            this.fieldIndices.add(this.asm.poolField(thisClassIndex, this.asm.poolNameAndType(nameIndex, typeIndex)));
            String getterType = fieldType;
            if (columnType == 24) {
                this.fieldTypeIndices.add(typeIndex);
                int nameIndex2 = this.asm.poolUtf8().put('f').put(i).put(i).$();
                this.fieldNameIndices.add(nameIndex2);
                int nameAndTypeIndex = this.asm.poolNameAndType(nameIndex2, typeIndex);
                this.fieldIndices.add(this.asm.poolField(thisClassIndex, nameAndTypeIndex));
            }
            int methodIndex = this.asm.poolInterfaceMethod(recordClassIndex, getterNameA, "(I)" + getterType);
            this.methodMap.putIfAbsent(getterNameA, methodIndex);
            this.fieldRecordAccessorIndicesA.add(methodIndex);
            if (getterNameB != null) {
                methodIndex = this.asm.poolInterfaceMethod(recordClassIndex, getterNameB, "(I)" + getterType);
                this.methodMap.putIfAbsent(getterNameB, methodIndex);
            }
            this.fieldRecordAccessorIndicesB.add(methodIndex);
            this.comparatorAccessorIndices.add(this.asm.poolMethod(this.asm.poolClass(comparatorClass), this.asm.poolNameAndType(compareMethodIndex, comparatorDesc == null ? this.asm.poolUtf8().put('(').put(fieldType).put(fieldType).put(")I").$() : this.asm.poolUtf8(comparatorDesc))));
        }
    }
}

