/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.RecordComparator;
import io.questdb.griffin.engine.orderby.LimitedSizeLongTreeChain;
import io.questdb.griffin.engine.orderby.LimitedSizeSortedLightRecordCursor;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.griffin.engine.orderby.SortedLightRecordCursor;
import io.questdb.std.Misc;

public class LimitedSizeSortedLightRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final CairoConfiguration configuration;
    private final RecordComparator comparator;
    private final Function loFunction;
    private final Function hiFunction;
    private DelegatingRecordCursor cursor;

    public LimitedSizeSortedLightRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory base, RecordComparator comparator, Function loFunc, Function hiFunc) {
        super(metadata);
        this.base = base;
        this.loFunction = loFunc;
        this.hiFunction = hiFunc;
        this.configuration = configuration;
        this.comparator = comparator;
    }

    @Override
    protected void _close() {
        this.base.close();
        if (this.cursor != null) {
            this.cursor.close();
        }
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.initialize(executionContext, baseCursor);
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable ex) {
            baseCursor.close();
            Misc.free(this.cursor);
            throw ex;
        }
    }

    private void initialize(SqlExecutionContext executionContext, RecordCursor baseCursor) throws SqlException {
        if (this.isInitialized()) {
            return;
        }
        if (this.canBeOptimized(baseCursor, executionContext)) {
            this.initializeLimitedSizeCursor(executionContext, baseCursor);
        } else {
            this.initializeUnlimitedSizeCursor();
        }
    }

    private void initializeUnlimitedSizeCursor() {
        LongTreeChain chain = new LongTreeChain(this.configuration.getSqlSortKeyPageSize(), this.configuration.getSqlSortKeyMaxPages(), this.configuration.getSqlSortLightValuePageSize(), this.configuration.getSqlSortLightValueMaxPages());
        this.cursor = new SortedLightRecordCursor(chain, this.comparator);
    }

    public void initializeLimitedSizeCursor(SqlExecutionContext executionContext, RecordCursor base) throws SqlException {
        long limit;
        this.loFunction.init(base, executionContext);
        if (this.hiFunction != null) {
            this.hiFunction.init(base, executionContext);
        }
        long skipFirst = 0L;
        long skipLast = 0L;
        boolean isFirstN = false;
        long lo = this.loFunction.getLong(null);
        if (lo < 0L && this.hiFunction == null) {
            limit = -lo;
        } else if (lo > -1L && this.hiFunction == null) {
            isFirstN = true;
            limit = lo;
        } else {
            long hi = this.hiFunction.getLong(null);
            if (lo < 0L) {
                if (lo < hi) {
                    limit = -lo;
                    skipLast = Math.max(-hi, 0L);
                } else {
                    limit = 0L;
                }
            } else if (hi < 0L) {
                limit = -1L;
                skipFirst = lo;
                skipLast = -hi;
            } else if (hi <= lo) {
                limit = 0L;
            } else {
                isFirstN = true;
                limit = hi;
                skipFirst = lo;
            }
        }
        LimitedSizeLongTreeChain chain = new LimitedSizeLongTreeChain(this.configuration.getSqlSortKeyPageSize(), this.configuration.getSqlSortKeyMaxPages(), this.configuration.getSqlSortLightValuePageSize(), this.configuration.getSqlSortLightValueMaxPages(), isFirstN, limit);
        this.cursor = new LimitedSizeSortedLightRecordCursor(chain, this.comparator, limit, skipFirst, skipLast);
    }

    private boolean isInitialized() {
        return this.cursor != null;
    }

    private boolean canBeOptimized(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
        this.loFunction.init(baseCursor, executionContext);
        if (this.hiFunction != null) {
            this.hiFunction.init(baseCursor, executionContext);
        }
        return this.loFunction.getLong(null) < 0L || this.hiFunction == null || this.hiFunction.getLong(null) >= 0L;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public boolean implementsLimit() {
        return true;
    }
}

